/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.api;

import icbm.classic.ICBMClassic;
import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.caps.IExplosive;
import icbm.classic.api.launcher.IMissileLauncher;
import icbm.classic.api.missiles.IMissile;
import icbm.classic.api.refs.ICBMExplosives;
import icbm.classic.api.reg.IExplosiveData;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public final class ICBMClassicHelpers {
    public static IExplosiveData getExplosive(int explosive, boolean returnNull) {
        IExplosiveData data = ICBMClassicAPI.EXPLOSIVE_REGISTRY.getExplosiveData(explosive);
        if (data != null) {
            return data;
        }
        if (ICBMClassic.runningAsDev) {
            ICBMClassic.logger().error("ICBMClassicAPI: Error - Failed to locate explosive for ID[" + explosive + "] this may cause unexpected logic", (Throwable)new RuntimeException());
        }
        return returnNull ? null : ICBMExplosives.CONDENSED;
    }

    public static IExplosiveData getExplosive(String name, boolean returnNull) {
        return ICBMClassicHelpers.getExplosive(new ResourceLocation(name), returnNull);
    }

    public static IExplosiveData getExplosive(ResourceLocation name, boolean returnNull) {
        IExplosiveData data = ICBMClassicAPI.EXPLOSIVE_REGISTRY.getExplosiveData(name);
        if (data != null) {
            return data;
        }
        System.out.println("ICBMClassicAPI: Error - Failed to locate explosive for Name[" + name + "] this may cause unexpected logic");
        return returnNull ? null : ICBMExplosives.CONDENSED;
    }

    public static boolean isMissile(Entity entity) {
        return entity != null && entity.hasCapability(ICBMClassicAPI.MISSILE_CAPABILITY, null);
    }

    public static boolean isMissile(ItemStack stack) {
        return !stack.func_190926_b() && stack.hasCapability(ICBMClassicAPI.MISSILE_STACK_CAPABILITY, null);
    }

    public static IMissile getMissile(Entity entity) {
        return (IMissile)entity.getCapability(ICBMClassicAPI.MISSILE_CAPABILITY, null);
    }

    public static boolean isExplosive(Entity entity) {
        return entity != null && entity.hasCapability(ICBMClassicAPI.EXPLOSIVE_CAPABILITY, null);
    }

    public static IExplosive getExplosive(Entity entity) {
        return (IExplosive)entity.getCapability(ICBMClassicAPI.EXPLOSIVE_CAPABILITY, null);
    }

    public static boolean isLauncher(TileEntity tileEntity, EnumFacing side) {
        return tileEntity != null && tileEntity.hasCapability(ICBMClassicAPI.MISSILE_LAUNCHER_CAPABILITY, side);
    }

    public static IMissileLauncher getLauncher(TileEntity tileEntity, EnumFacing side) {
        return (IMissileLauncher)tileEntity.getCapability(ICBMClassicAPI.MISSILE_LAUNCHER_CAPABILITY, side);
    }

    public static IExplosive getExplosive(ItemStack stack) {
        if (stack.hasCapability(ICBMClassicAPI.EXPLOSIVE_CAPABILITY, null)) {
            return (IExplosive)stack.getCapability(ICBMClassicAPI.EXPLOSIVE_CAPABILITY, null);
        }
        return null;
    }

    @Deprecated
    public static boolean hasEmpHandler(IBlockState iBlockState) {
        return false;
    }
}

