/*
 * Decompiled with CFR 0.152.
 */
package elucent.simplytea.core;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraftforge.common.config.Config;

@net.minecraftforge.common.config.Config(modid="simplytea")
public class Config {
    @Config.Comment(value={"Hunger restored from tea"})
    @Config.LangKey(value="simplytea.config.tea")
    public static TeaCategory tea = new TeaCategory();
    @Config.Comment(value={"Options related to filling the teapot"})
    @Config.LangKey(value="simplytea.config.teapot")
    public static TeapotCategory teapot = new TeapotCategory();
    @Config.Comment(value={"Options related to the tea tree"})
    @Config.LangKey(value="simplytea.config.tree")
    public static TreeCategory tree = new TreeCategory();

    public static void parse() {
        Config.teapot.waterSet.clear();
        Config.teapot.waterSet.addAll(Arrays.asList(Config.teapot.waters));
        Config.teapot.milkSet.clear();
        Config.teapot.milkSet.addAll(Arrays.asList(Config.teapot.milks));
    }

    public static class TeapotCategory {
        @Config.Comment(value={"If true, the teapot will not consume water source blocks when filling. It will still consume water from tank and cauldrons"})
        @Config.LangKey(value="simplytea.config.teapot.infinite_water")
        public boolean infinite_water = true;
        @Config.Comment(value={"If true, the teapot can be filled with water from a cauldron"})
        @Config.LangKey(value="simplytea.config.teapot.fill_from_cauldron")
        public boolean fill_from_cauldron = true;
        @Config.Comment(value={"If true, the teapot can be filled with milk using a cow"})
        @Config.LangKey(value="simplytea.config.teapot.milk_cow")
        public boolean milk_cow = true;
        @Config.Comment(value={"List of fluid IDs treated as water for filling the teapot"})
        @Config.LangKey(value="simplytea.config.teapot.waters")
        public String[] waters = new String[]{"water"};
        @Config.Ignore
        public final Set<String> waterSet = new HashSet<String>();
        @Config.Comment(value={"List of fluid IDs treated as milk for filling the teapot"})
        @Config.LangKey(value="simplytea.config.teapot.milks")
        public String[] milks = new String[]{"milk"};
        @Config.Ignore
        public final Set<String> milkSet = new HashSet<String>();
    }

    public static class Cocoa {
        @Config.RequiresMcRestart
        @Config.Comment(value={"Hunger restored when drinking this tea."})
        @Config.RangeInt(min=0, max=20)
        @Config.LangKey(value="simplytea.config.tea.hunger")
        public int hunger = 4;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Saturation restored when drinking this tea"})
        @Config.RangeDouble(min=0.0, max=10.0)
        @Config.LangKey(value="simplytea.config.tea.saturation")
        public double saturation = 0.6;
        @Config.Comment(value={"If true, drinking cocoa clears status effects like milk"})
        @Config.LangKey(value="simplytea.config.tea.cocoa.clear_effects")
        public boolean clear_effects = true;
    }

    public static class ChorusTea {
        @Config.RequiresMcRestart
        @Config.Comment(value={"Hunger restored when drinking this tea."})
        @Config.RangeInt(min=0, max=20)
        @Config.LangKey(value="simplytea.config.tea.hunger")
        public int hunger;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Saturation restored when drinking this tea"})
        @Config.RangeDouble(min=0.0, max=10.0)
        @Config.LangKey(value="simplytea.config.tea.saturation")
        public double saturation;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Time in seconds for the enderfalling effect from drinking this tea."})
        @Config.RangeInt(min=0, max=600)
        @Config.LangKey(value="simplytea.config.tea.enderfalling_time")
        public int enderfalling_time;

        private ChorusTea(int defaultHunger, double defaultSaturation, int enderfallingTime) {
            this.hunger = defaultHunger;
            this.saturation = defaultSaturation;
            this.enderfalling_time = enderfallingTime;
        }
    }

    public static class HerbalTea {
        @Config.RequiresMcRestart
        @Config.Comment(value={"Hunger restored when drinking this tea."})
        @Config.RangeInt(min=0, max=20)
        @Config.LangKey(value="simplytea.config.tea.hunger")
        public int hunger;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Saturation restored when drinking this tea"})
        @Config.RangeDouble(min=0.0, max=10.0)
        @Config.LangKey(value="simplytea.config.tea.saturation")
        public double saturation;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Hearts restored when sleeping after drinking this tea."})
        @Config.RangeInt(min=0, max=10)
        @Config.LangKey(value="simplytea.config.tea.herbal.hearts")
        public int hearts;

        private HerbalTea(int defaultHunger, double defaultSaturation, int hearts) {
            this.hunger = defaultHunger;
            this.saturation = defaultSaturation;
            this.hearts = hearts;
        }
    }

    public static class CaffeineTea {
        @Config.RequiresMcRestart
        @Config.Comment(value={"Hunger restored when drinking this tea."})
        @Config.RangeInt(min=0, max=20)
        @Config.LangKey(value="simplytea.config.tea.hunger")
        public int hunger;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Saturation restored when drinking this tea"})
        @Config.RangeDouble(min=0.0, max=10.0)
        @Config.LangKey(value="simplytea.config.tea.saturation")
        public double saturation;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Time in seconds for the caffeinated effect from drinking this tea."})
        @Config.RangeInt(min=0, max=600)
        @Config.LangKey(value="simplytea.config.tea.caffeinated_time")
        public int caffeinated_time;

        private CaffeineTea(int defaultHunger, double defaultSaturation, int caffeinatedTime) {
            this.hunger = defaultHunger;
            this.saturation = defaultSaturation;
            this.caffeinated_time = caffeinatedTime;
        }
    }

    public static class TreeCategory {
        @Config.RequiresMcRestart
        @Config.Comment(value={"If true, generates tea trees in forest biomes."})
        @Config.LangKey(value="simplytea.config.tree.enable_generation")
        public boolean enable_generation = true;
        @Config.Comment(value={"Percent chance of leaves to regrow every random tick. Set to 1 to regrow every random tick (old behavior)"})
        @Config.RangeDouble(min=0.0, max=1.0)
        @Config.LangKey(value="simplytea.config.tree.leaf_growth_chance")
        public double leaf_growth_chance = 0.05;
        @Config.Comment(value={"Maximum number of leaves dropped when a single branch is broken or sheared."})
        @Config.RangeInt(min=1, max=64)
        @Config.LangKey(value="simplytea.config.tree.max_leaves")
        public int max_leaves = 3;
        @Config.Comment(value={"Maximum number of sticks dropped when a single branch is broken or sheared."})
        @Config.RangeInt(min=1, max=64)
        @Config.LangKey(value="simplytea.config.tree.max_leaves")
        public int max_sticks = 3;
        @Config.Comment(value={"Percent chance for a tree to drop a sapling when broken or sheared"})
        @Config.RangeDouble(min=0.0, max=1.0)
        @Config.LangKey(value="simplytea.config.tree.sapling_chance")
        public double sapling_chance = 0.1;
        @Config.Comment(value={"Maximum number of chorus petals dropped from a chorus flower when the plant below is broken."})
        @Config.RangeInt(min=1, max=64)
        @Config.LangKey(value="simplytea.config.tree.max_petals")
        public int max_petals = 3;
    }

    public static class TeaCategory {
        @Config.Comment(value={"Stats for floral tea."})
        @Config.LangKey(value="simplytea.config.tea.floral")
        public HerbalTea floral = new HerbalTea(2, 0.5, 1);
        @Config.Comment(value={"Stats for green tea."})
        @Config.LangKey(value="simplytea.config.tea.green")
        public CaffeineTea green = new CaffeineTea(3, 0.5, 150);
        @Config.Comment(value={"Stats for black tea."})
        @Config.LangKey(value="simplytea.config.tea.black")
        public CaffeineTea black = new CaffeineTea(4, 0.8, 210);
        @Config.Comment(value={"Stats for chai tea."})
        @Config.LangKey(value="simplytea.config.tea.green")
        public CaffeineTea chai = new CaffeineTea(5, 0.6, 150);
        @Config.Comment(value={"Stats and effects for chamomile tea, added when Rustic is loaded."})
        @Config.LangKey(value="simplytea.config.tea.chamomile")
        public HerbalTea chamomile = new HerbalTea(2, 0.5, 2);
        @Config.Comment(value={"Stats for chai tea."})
        @Config.LangKey(value="simplytea.config.tea.green")
        public ChorusTea chorus = new ChorusTea(3, 0.8, 150);
        @Config.Comment(value={"Stats and effects for cocoa."})
        @Config.LangKey(value="simplytea.config.tea.cocoa")
        public Cocoa cocoa = new Cocoa();
    }
}

