/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.server;

import crafttweaker.api.command.ICommandManager;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.player.IPlayer;
import crafttweaker.api.player.IUser;
import crafttweaker.api.server.AbstractServer;
import crafttweaker.api.server.IServer;
import crafttweaker.api.world.IBlockPos;
import crafttweaker.api.world.IWorld;
import crafttweaker.mc1120.CraftTweaker;
import crafttweaker.mc1120.command.MCCommandManager;
import crafttweaker.mc1120.player.CommandBlockPlayer;
import crafttweaker.mc1120.player.RconPlayer;
import crafttweaker.mc1120.server.ServerPlayer;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.rcon.RConConsoleSource;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.CommandBlockBaseLogic;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class MCServer
extends AbstractServer {
    private final MinecraftServer server;

    public MCServer(MinecraftServer server) {
        this.server = server;
    }

    private static IUser getPlayer(ICommandSender commandSender) {
        if (commandSender instanceof EntityPlayer) {
            return CraftTweakerMC.getIPlayer((EntityPlayer)commandSender);
        }
        if (commandSender instanceof RConConsoleSource) {
            return new RconPlayer(commandSender);
        }
        if (commandSender instanceof CommandBlockBaseLogic) {
            return new CommandBlockPlayer(commandSender);
        }
        if (commandSender.func_70005_c_().equals("Server")) {
            return ServerPlayer.INSTANCE;
        }
        CraftTweaker.LOG.error("Unsupported command sender: " + commandSender + " defaulting to server player!");
        CraftTweaker.LOG.error("player name: " + commandSender.func_70005_c_());
        CraftTweaker.LOG.error("Please report to mod author if this is incorrect!");
        return ServerPlayer.INSTANCE;
    }

    @Override
    public boolean isOp(IPlayer player) {
        return CraftTweakerMC.getPlayer(player).func_70003_b(this.server.func_110455_j(), "");
    }

    @Override
    public ICommandManager getCommandManager() {
        return new MCCommandManager(this.server.func_71187_D());
    }

    @Override
    public String getDisplayName() {
        return this.server.func_145748_c_().func_150254_d();
    }

    @Override
    public IBlockPos getPosition() {
        return CraftTweakerMC.getIBlockPos(this.server.func_180425_c());
    }

    @Override
    public IWorld getWorld() {
        return CraftTweakerMC.getIWorld(this.server.func_130014_f_());
    }

    @Override
    public IServer getServer() {
        return this;
    }

    @Override
    public void sendMessage(String text) {
        this.server.func_145747_a((ITextComponent)new TextComponentString(text));
    }

    public MinecraftServer getInternal() {
        return this.server;
    }
}

