/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.entitys;

import io.netty.buffer.ByteBuf;
import java.util.Random;
import lumien.randomthings.client.particles.EntityColoredSmokeFX;
import lumien.randomthings.item.ItemWeatherEgg;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityWeatherCloud
extends Entity
implements IEntityAdditionalSpawnData {
    ItemWeatherEgg.TYPE eggType = ItemWeatherEgg.TYPE.SUN;
    int age = 0;

    public EntityWeatherCloud(World worldIn) {
        super(worldIn);
        this.field_70145_X = true;
    }

    public EntityWeatherCloud(World worldIn, double x, double y, double z, ItemWeatherEgg.TYPE eggType) {
        super(worldIn);
        this.field_70145_X = true;
        this.eggType = eggType;
        this.func_70107_b(x, y, z);
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.age < 200) {
            this.field_70181_x = 0.007;
        } else if (this.field_70163_u < (double)this.field_70170_p.func_72800_K()) {
            this.field_70181_x += 0.001;
            this.field_70181_x *= 1.02;
        } else if (!this.field_70170_p.field_72995_K) {
            int i = (300 + new Random().nextInt(600)) * 20;
            WorldInfo info = this.field_70170_p.func_72912_H();
            switch (this.eggType) {
                case RAIN: {
                    info.func_176142_i(0);
                    info.func_76080_g(i);
                    info.func_76090_f(i);
                    info.func_76084_b(true);
                    info.func_76069_a(false);
                    break;
                }
                case STORM: {
                    info.func_176142_i(0);
                    info.func_76080_g(i);
                    info.func_76090_f(i);
                    info.func_76084_b(true);
                    info.func_76069_a(true);
                    break;
                }
                case SUN: {
                    info.func_176142_i(i);
                    info.func_76080_g(0);
                    info.func_76090_f(0);
                    info.func_76084_b(false);
                    info.func_76069_a(false);
                    break;
                }
            }
            this.func_70106_y();
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        if (this.field_70170_p.field_72995_K) {
            this.spawnParticles();
        }
        ++this.age;
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles() {
        switch (this.eggType) {
            case RAIN: {
                this.spawnDefaultCloud();
                for (int i = 0; i < 2; ++i) {
                    double t = Math.PI * 2 * Math.random();
                    double a = 0.25;
                    double b = 0.35;
                    double elX = (a /= 1.5 + Math.random()) * Math.cos(t);
                    double elZ = (b /= 1.5 + Math.random()) * Math.sin(t);
                    this.field_70170_p.func_175682_a(EnumParticleTypes.WATER_WAKE, true, this.field_70165_t + elX, this.field_70163_u - 0.2, this.field_70161_v + elZ, 0.0, -0.05, 0.0, new int[0]);
                }
                break;
            }
            case STORM: {
                this.spawnDefaultCloud();
                double t = Math.PI * 2 * Math.random();
                double a = 0.25;
                double b = 0.35;
                double elX = (a /= 1.5 + Math.random()) * Math.cos(t);
                double elZ = (b /= 1.5 + Math.random()) * Math.sin(t);
                EntityColoredSmokeFX particle = new EntityColoredSmokeFX(this.field_70170_p, this.field_70165_t + elX, this.field_70163_u, this.field_70161_v + elZ, Math.random() * 0.1 - 0.05, Math.random() * 0.2 - 0.1, Math.random() * 0.1 - 0.05);
                particle.func_70538_b(1.0f, 1.0f, 0.0f);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
                break;
            }
            case SUN: {
                this.spawnNiceCloud();
                break;
            }
        }
    }

    private void spawnDefaultCloud() {
        for (double y = -1.0; y <= 1.0; y += 1.0) {
            for (double t = 0.0; t < Math.PI * 2; t += 0.6283185307179586) {
                double a = 0.25;
                double b = 0.35;
                double elX = (a /= Math.abs(y) * 0.5 + 1.0) * Math.cos(t);
                double elZ = (b /= Math.abs(y) * 0.5 + 1.0) * Math.sin(t);
                this.field_70170_p.func_175682_a(EnumParticleTypes.SMOKE_NORMAL, true, this.field_70165_t + elX, this.field_70163_u + y / 8.0, this.field_70161_v + elZ, 0.0, -0.03, 0.0, new int[0]);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnNiceCloud() {
        for (double y = -1.0; y <= 1.0; y += 1.0) {
            for (double t = 0.0; t < Math.PI * 2; t += 1.0471975511965976) {
                double a = 0.25;
                double b = 0.35;
                double elX = (a /= Math.abs(y) * 0.5 + 1.0) * Math.cos(t);
                double elZ = (b /= Math.abs(y) * 0.5 + 1.0) * Math.sin(t);
                EntityColoredSmokeFX particle = new EntityColoredSmokeFX(this.field_70170_p, this.field_70165_t + elX, this.field_70163_u + y / 8.0, this.field_70161_v + elZ, 0.0, -0.03, 0.0);
                float shade = (float)(Math.random() * 0.05 - 0.025);
                particle.func_70538_b(0.95f + shade, 0.95f + shade, 0.95f + shade);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
            }
        }
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.eggType = ItemWeatherEgg.TYPE.values()[compound.func_74762_e("eggType")];
        this.age = compound.func_74762_e("age");
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("eggType", this.eggType.ordinal());
        compound.func_74768_a("age", this.age);
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.eggType.ordinal());
        buffer.writeInt(this.age);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.eggType = ItemWeatherEgg.TYPE.values()[additionalData.readInt()];
        this.age = additionalData.readInt();
    }

    public ItemWeatherEgg.TYPE getEggType() {
        return this.eggType;
    }
}

