/*
 * Decompiled with CFR 0.152.
 */
package nc.worldgen.ore;

import com.google.common.base.Predicate;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Random;
import nc.block.BlockMeta;
import nc.config.NCConfig;
import nc.enumm.MetaEnums;
import nc.init.NCBlocks;
import nc.worldgen.ore.UniversalOrePredicate;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;

public class OreGenerator
implements IWorldGenerator {
    protected static IntSet ore_dim_set;
    protected final WorldGenOre[] ores;

    public OreGenerator() {
        if (ore_dim_set == null) {
            ore_dim_set = new IntOpenHashSet(NCConfig.ore_dims);
        }
        this.ores = new WorldGenOre[8];
        for (int i = 0; i < MetaEnums.OreType.values().length; ++i) {
            this.ores[i] = new WorldGenOre(i);
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (ore_dim_set.contains(world.field_73011_w.getDimension()) != NCConfig.ore_dims_list_type) {
            this.generateOres(random, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
        }
    }

    protected void generateOres(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        for (int i = 0; i < MetaEnums.OreType.values().length; ++i) {
            if (!NCConfig.ore_gen[i]) continue;
            OreGenerator.generateOre(this.ores[i], world, random, chunkX, chunkZ, NCConfig.ore_rate[i], NCConfig.ore_min_height[i], NCConfig.ore_max_height[i]);
        }
    }

    public static void generateOre(WorldGenOre generator, World world, Random rand, int chunk_X, int chunk_Z, int chancesToSpawn, int minHeight, int maxHeight) {
        if (minHeight < 0 || maxHeight >= world.func_72800_K() || minHeight > maxHeight) {
            throw new IllegalArgumentException("Illegal height arguments!");
        }
        int heightDiff = maxHeight - minHeight + 1;
        for (int i = 0; i < chancesToSpawn; ++i) {
            int x = chunk_X * 16 + rand.nextInt(16);
            int y = minHeight + rand.nextInt(heightDiff);
            int z = chunk_Z * 16 + rand.nextInt(16);
            generator.func_180709_b(world, rand, new BlockPos(x, y, z));
        }
    }

    protected static class WorldGenOre
    extends WorldGenMinable {
        public WorldGenOre(int meta) {
            super(((BlockMeta)NCBlocks.ore).func_176203_a(meta), NCConfig.ore_size[meta] + 2, (Predicate)new UniversalOrePredicate());
        }
    }
}

