/*
 * Decompiled with CFR 0.152.
 */
package nc.util;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Vertex<T> {
    public T data;
    public Vertex<T> parent;
    public final List<Vertex<T>> children = new ArrayList<Vertex<T>>();

    protected Vertex(T data, Vertex<T> parent) {
        this.data = data;
        this.parent = parent;
    }

    public Vertex(T data) {
        this(data, null);
    }

    public void addChild(T childData) {
        this.children.add(new Vertex<T>(childData, this));
    }

    public void addChildren(List<T> childrenData) {
        for (T childData : childrenData) {
            this.addChild(childData);
        }
    }

    public Vertex<T> getRoot() {
        Vertex<T> v = this;
        while (v.parent != null) {
            v = v.parent;
        }
        return v;
    }

    public List<T> getPath(boolean rootStart) {
        ObjectOpenHashSet set = new ObjectOpenHashSet();
        ArrayList<T> list = new ArrayList<T>();
        Vertex<T> v = this;
        while (v != null && !set.contains((Object)v)) {
            set.add((Object)v);
            list.add(v.data);
            v = v.parent;
        }
        if (rootStart) {
            Collections.reverse(list);
        }
        return list;
    }

    public boolean partOfCycle() {
        ObjectOpenHashSet set = new ObjectOpenHashSet();
        Vertex<T> v = this;
        while (v != null) {
            if (set.contains((Object)v)) {
                return true;
            }
            set.add((Object)v);
            v = v.parent;
        }
        return false;
    }

    public String toString() {
        return "(" + this.parent.data + " -> " + this.data + " -> " + this.children + ")";
    }
}

