/*
 * Decompiled with CFR 0.152.
 */
package nc.util;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class StackHelper {
    public static ItemStack fixItemStack(Object object) {
        if (object instanceof ItemStack) {
            ItemStack stack = ((ItemStack)object).func_77946_l();
            if (stack.func_190916_E() == 0) {
                stack.func_190920_e(1);
            }
            return stack;
        }
        if (object instanceof Item) {
            return new ItemStack((Item)object, 1);
        }
        if (!(object instanceof Block)) {
            throw new RuntimeException(String.format("Invalid ItemStack: %s", object));
        }
        return new ItemStack((Block)object, 1);
    }

    public static ItemStack blockStateToStack(IBlockState state) {
        if (state == null) {
            return ItemStack.field_190927_a;
        }
        Block block = state.func_177230_c();
        if (block == null) {
            return ItemStack.field_190927_a;
        }
        int meta = block.func_176201_c(state);
        return new ItemStack(block, 1, meta);
    }

    public static IBlockState getBlockStateFromStack(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        if (stack.func_77973_b() == Items.field_190931_a) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (stack.func_190926_b()) {
            return null;
        }
        int meta = StackHelper.getMetadata(stack);
        Item item = stack.func_77973_b();
        if (!(item instanceof ItemBlock)) {
            return null;
        }
        ItemBlock itemBlock = (ItemBlock)item;
        return itemBlock.func_179223_d().func_176203_a(meta);
    }

    public static int getMetadata(ItemStack stack) {
        return Items.field_151045_i.getMetadata(stack);
    }

    public static ItemStack changeStackSize(ItemStack stack, int size) {
        ItemStack newStack = stack.func_77946_l();
        newStack.func_190920_e(size);
        return newStack;
    }

    public static String stackPath(ItemStack stack) {
        ResourceLocation loc = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)stack.func_77973_b());
        if (loc == null) {
            return null;
        }
        return loc.func_110623_a();
    }

    public static String stackName(ItemStack stack) {
        ResourceLocation resourcelocation = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)stack.func_77973_b());
        return resourcelocation == null ? "null" : resourcelocation.toString() + ":" + StackHelper.getMetadata(stack);
    }

    public static String stackListNames(List<ItemStack> list) {
        String names = "";
        for (ItemStack stack : list) {
            names = names + ", " + StackHelper.stackName(stack);
        }
        return names.substring(2);
    }

    public static boolean areItemStackTagsEqual(ItemStack stackA, ItemStack stackB) {
        boolean isAEmpty = stackA.func_190926_b();
        boolean isBEmpty = stackB.func_190926_b();
        if (isAEmpty && isBEmpty) {
            return true;
        }
        if (!isAEmpty && !isBEmpty) {
            NBTTagCompound stackANBT = stackA.func_77978_p();
            NBTTagCompound stackBNBT = stackB.func_77978_p();
            if (stackANBT == null) {
                return stackBNBT == null;
            }
            return stackANBT.equals((Object)stackBNBT);
        }
        return false;
    }

    public static ItemStack getBucket(@Nonnull FluidStack fluidStack) {
        return FluidUtil.getFilledBucket((FluidStack)fluidStack);
    }

    public static ItemStack getBucket(String fluidName) {
        return StackHelper.getBucket(new FluidStack(FluidRegistry.getFluid((String)fluidName), 1000));
    }
}

