/*
 * Decompiled with CFR 0.152.
 */
package nc.util;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nc.config.NCConfig;
import nc.util.CollectionHelper;
import nc.util.RegistryHelper;
import nc.util.StackHelper;
import nc.util.StringHelper;
import net.minecraft.block.Block;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class OreDictHelper {
    public static final List<String> INGOT_VOLUME_TYPES = Lists.newArrayList((Object[])new String[]{"ingot", "dust"});
    public static final List<String> NUGGET_VOLUME_TYPES = Lists.newArrayList((Object[])new String[]{"nugget", "tinyDust"});
    public static final List<String> GEM_VOLUME_TYPES = Lists.newArrayList((Object[])new String[]{"gem", "dust"});
    public static final List<String> GEM_NUGGET_VOLUME_TYPES = Lists.newArrayList((Object[])new String[]{"nugget", "tinyDust"});
    public static final List<String> COAL_TYPES = Lists.newArrayList((Object[])new String[]{"coal", "dustCoal"});
    public static final List<String> DUST_VOLUME_TYPES = Lists.newArrayList((Object[])new String[]{"dust"});
    public static final List<String> TINYDUST_VOLUME_TYPES = Lists.newArrayList((Object[])new String[]{"tinyDust"});
    public static final List<String> FUEL_VOLUME_TYPES = Lists.newArrayList((Object[])new String[]{"fuel", "dust"});
    public static final List<String> BLOCK_VOLUME_TYPES = Lists.newArrayList((Object[])new String[]{"block"});
    public static final List<String> FUEL_BLOCK_VOLUME_TYPES = Lists.newArrayList((Object[])new String[]{"block", "blockFuel"});
    private static final Int2ObjectMap<Set<String>> ORE_DICT_CACHE = new Int2ObjectOpenHashMap();

    public static boolean isOreMatching(ItemStack stack, ItemStack target) {
        for (String oreName : OreDictHelper.getOreNames(target)) {
            for (ItemStack ore : OreDictionary.getOres((String)oreName, (boolean)false)) {
                if (!ItemStack.func_179545_c((ItemStack)ore, (ItemStack)stack)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isOreMember(ItemStack stack, String oreName) {
        for (ItemStack ore : OreDictionary.getOres((String)oreName, (boolean)false)) {
            if (!ItemStack.func_179545_c((ItemStack)ore, (ItemStack)stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean oreExists(String ore) {
        return !OreDictionary.getOres((String)ore, (boolean)false).isEmpty();
    }

    public static boolean oresExist(String ... ores) {
        for (String ore : ores) {
            if (OreDictHelper.oreExists(ore)) continue;
            return false;
        }
        return true;
    }

    public static String getOreNameFromStacks(List<ItemStack> stackList) {
        List<Object> oreNameList = new ArrayList<String>();
        if (stackList == null || stackList.isEmpty()) {
            return "Unknown";
        }
        oreNameList.addAll(OreDictHelper.getOreNames(stackList.get(0)));
        for (ItemStack stack : stackList) {
            if (stack == null || stack.func_190926_b()) {
                return "Unknown";
            }
            if (!(oreNameList = CollectionHelper.intersect(oreNameList, OreDictHelper.getOreNames(stack))).isEmpty()) continue;
            return "Unknown";
        }
        return (String)oreNameList.get(0);
    }

    public static boolean getBlockMatchesOre(World world, BlockPos pos, String ... names) {
        ArrayList stackList = new ArrayList();
        for (String name : names) {
            NonNullList stacks = OreDictionary.getOres((String)name, (boolean)false);
            stackList.addAll(stacks);
        }
        ItemStack stack = StackHelper.blockStateToStack(world.func_180495_p(pos));
        for (ItemStack oreStack : stackList) {
            if (!oreStack.func_77969_a(stack)) continue;
            return true;
        }
        return false;
    }

    public static List<ItemStack> getPrioritisedStackList(String ore) {
        ArrayList<ItemStack> defaultStackList = new ArrayList<ItemStack>((Collection<ItemStack>)OreDictionary.getOres((String)ore, (boolean)false));
        if (!NCConfig.ore_dict_priority_bool || NCConfig.ore_dict_priority.length < 1) {
            return defaultStackList;
        }
        ArrayList<ItemStack> prioritisedStackList = new ArrayList<ItemStack>();
        for (String element : NCConfig.ore_dict_priority) {
            for (ItemStack stack : defaultStackList) {
                if (!RegistryHelper.getModID(stack).equals(element) || prioritisedStackList.contains(stack)) continue;
                prioritisedStackList.add(stack);
            }
        }
        if (prioritisedStackList.isEmpty()) {
            return defaultStackList;
        }
        for (ItemStack stack : defaultStackList) {
            if (prioritisedStackList.contains(stack)) continue;
            prioritisedStackList.add(stack);
        }
        return prioritisedStackList;
    }

    public static ItemStack getPrioritisedCraftingStack(ItemStack backup, String ore) {
        if (ore == null) {
            return backup;
        }
        List<ItemStack> stackList = OreDictHelper.getPrioritisedStackList(ore);
        if (stackList == null || stackList.isEmpty()) {
            if (backup == null || backup.func_190926_b()) {
                return null;
            }
            return backup;
        }
        ItemStack stack = stackList.get(0).func_77946_l();
        stack.func_190920_e(backup == null || backup.func_190926_b() ? 1 : backup.func_190916_E());
        return stack;
    }

    public static ItemStack getPrioritisedCraftingStack(Item backup, String ore) {
        return OreDictHelper.getPrioritisedCraftingStack(backup == null ? ItemStack.field_190927_a : new ItemStack(backup), ore);
    }

    public static ItemStack getPrioritisedCraftingStack(Block backup, String ore) {
        return OreDictHelper.getPrioritisedCraftingStack(backup == null ? ItemStack.field_190927_a : new ItemStack(backup), ore);
    }

    public static void addWildcard(Collection<String> collection, String ore) {
        ore = StringHelper.regex(ore);
        for (String o : OreDictionary.getOreNames()) {
            if (!o.matches(ore)) continue;
            collection.add(o);
        }
    }

    public static <T> void putWildcard(Map<String, T> map, String ore, T value) {
        ore = StringHelper.regex(ore);
        for (String o : OreDictionary.getOreNames()) {
            if (!o.matches(ore)) continue;
            map.put(o, value);
        }
    }

    private static Set<String> getOreNames(ItemStack stack, boolean useCache) {
        if (stack == null || stack.func_190926_b()) {
            return Collections.emptySet();
        }
        int packed = RecipeItemHelper.func_194113_b((ItemStack)stack);
        if (!useCache || !ORE_DICT_CACHE.containsKey(packed)) {
            ObjectOpenHashSet names = new ObjectOpenHashSet();
            for (int oreID : OreDictionary.getOreIDs((ItemStack)stack)) {
                names.add(OreDictionary.getOreName((int)oreID));
            }
            if (useCache) {
                ORE_DICT_CACHE.put(packed, (Object)names);
            }
            return names;
        }
        return (Set)ORE_DICT_CACHE.get(packed);
    }

    public static Set<String> getOreNames(ItemStack stack) {
        return OreDictHelper.getOreNames(stack, true);
    }

    public static boolean hasOrePrefix(ItemStack stack, String ... prefixes) {
        for (String name : OreDictHelper.getOreNames(stack, false)) {
            for (String prefix : prefixes) {
                if (!name.startsWith(prefix)) continue;
                return true;
            }
        }
        return false;
    }

    public static void refreshOreDictCache() {
        ORE_DICT_CACHE.clear();
    }
}

