/*
 * Decompiled with CFR 0.152.
 */
package nc.util;

import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class NCInventoryHelper {
    private static final Random RAND = new Random();

    public static void dropInventoryItems(World world, BlockPos pos, IInventory inventory, int ... slots) {
        NCInventoryHelper.dropInventoryItems(world, pos.func_177958_n(), pos.func_177956_o(), (double)pos.func_177952_p(), inventory, slots);
    }

    public static void dropInventoryItems(World world, Entity entityAt, IInventory inventory, int ... slots) {
        NCInventoryHelper.dropInventoryItems(world, entityAt.field_70165_t, entityAt.field_70163_u, entityAt.field_70161_v, inventory, slots);
    }

    private static void dropInventoryItems(World world, double x, double y, double z, IInventory inventory, int ... slots) {
        if (slots.length == 0) {
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack itemstack = inventory.func_70301_a(i);
                if (itemstack.func_190926_b()) continue;
                NCInventoryHelper.spawnItemStack(world, x, y, z, itemstack);
            }
        } else {
            for (int i : slots) {
                ItemStack itemstack = inventory.func_70301_a(i);
                if (itemstack.func_190926_b()) continue;
                NCInventoryHelper.spawnItemStack(world, x, y, z, itemstack);
            }
        }
    }

    public static void dropInventoryItems(World worldIn, BlockPos pos, List<ItemStack> stacks) {
        NCInventoryHelper.dropInventoryItems(worldIn, pos.func_177958_n(), pos.func_177956_o(), (double)pos.func_177952_p(), stacks);
    }

    public static void dropInventoryItems(World worldIn, Entity entityAt, List<ItemStack> stacks) {
        NCInventoryHelper.dropInventoryItems(worldIn, entityAt.field_70165_t, entityAt.field_70163_u, entityAt.field_70161_v, stacks);
    }

    private static void dropInventoryItems(World worldIn, double x, double y, double z, List<ItemStack> stacks) {
        for (int i = 0; i < stacks.size(); ++i) {
            ItemStack itemstack = stacks.get(i);
            if (itemstack.func_190926_b()) continue;
            NCInventoryHelper.spawnItemStack(worldIn, x, y, z, itemstack);
        }
    }

    private static void spawnItemStack(World world, double x, double y, double z, ItemStack stack) {
        float fx = RAND.nextFloat() * 0.8f + 0.1f;
        float fy = RAND.nextFloat() * 0.8f + 0.1f;
        float fz = RAND.nextFloat() * 0.8f + 0.1f;
        while (!stack.func_190926_b()) {
            int split = RAND.nextInt(21) + 10;
            EntityItem entityitem = new EntityItem(world, x + (double)fx, y + (double)fy, z + (double)fz, stack.func_77979_a(split));
            entityitem.field_70159_w = RAND.nextGaussian() * 0.05;
            entityitem.field_70181_x = RAND.nextGaussian() * 0.05 + 0.2;
            entityitem.field_70179_y = RAND.nextGaussian() * 0.05;
            world.func_72838_d((Entity)entityitem);
        }
    }

    public static ItemStack addStackToInventory(IItemHandler inv, ItemStack stack) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        stack = ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)stack, (boolean)false);
        return stack;
    }
}

