/*
 * Decompiled with CFR 0.152.
 */
package nc.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import nc.util.NCUtil;

public class IOHelper {
    public static final String NEW_LINE = System.lineSeparator();
    public static final int MAX_ZIP_SIZE = 50000000;
    public static final int ZIP_READ_SIZE = 8192;

    public static void appendFile(File target, File source, String separator) throws IOException {
        try (FileWriter writer = new FileWriter(target, true);
             FileReader reader = new FileReader(source);){
            writer.write(separator);
            int c = reader.read();
            while (c != -1) {
                writer.write(c);
                c = reader.read();
            }
        }
    }

    public static boolean isZip(File file) {
        int signature = 0;
        try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
            signature = raf.readInt();
        }
        catch (IOException e) {
            NCUtil.getLogger().catching((Throwable)e);
        }
        return signature == 1347093252 || signature == 1347093766 || signature == 1347094280;
    }

    public static void unzip(File zipFile, String dest) throws IOException {
        Path destDir = Paths.get(dest, new String[0]).toAbsolutePath().normalize();
        Files.createDirectories(destDir, new FileAttribute[0]);
        int bytes = 0;
        try (ZipInputStream zipStream = new ZipInputStream(new FileInputStream(zipFile));){
            ZipEntry entry;
            while ((entry = zipStream.getNextEntry()) != null) {
                Path out = destDir.resolve(entry.getName()).normalize();
                if (!out.startsWith(destDir)) {
                    throw new IOException("Entry is outside of the target directory \"" + entry.getName() + "\"");
                }
                if (!entry.isDirectory()) {
                    bytes = IOHelper.extract(zipStream, out, bytes);
                    continue;
                }
                Files.createDirectories(out, new FileAttribute[0]);
            }
        }
    }

    private static int extract(ZipInputStream zipStream, Path fileDest, int currentBytes) throws IOException {
        Files.createDirectories(fileDest.getParent(), new FileAttribute[0]);
        try (OutputStream outStream = Files.newOutputStream(fileDest, new OpenOption[0]);){
            byte[] bytesIn = new byte[8192];
            int read = 0;
            while ((read = zipStream.read(bytesIn)) >= 0) {
                if ((currentBytes += read) > 50000000) {
                    throw new IOException("Zip file being extracted to \"" + fileDest + "\" is too big!");
                }
                outStream.write(bytesIn, 0, read);
            }
        }
        return currentBytes;
    }
}

