/*
 * Decompiled with CFR 0.152.
 */
package nc.util;

import crafttweaker.annotations.ZenRegister;
import java.awt.Color;
import net.minecraft.util.math.MathHelper;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.nuclearcraft.ColorHelper")
@ZenRegister
public class ColorHelper {
    public static Color getColor(int color) {
        return new Color(color);
    }

    @ZenMethod
    public static int getAlpha(int color) {
        return color >> 24 & 0xFF;
    }

    @ZenMethod
    public static int getRed(int color) {
        return (color & 0xFF0000) >> 16;
    }

    @ZenMethod
    public static int getGreen(int color) {
        return (color & 0xFF00) >> 8;
    }

    @ZenMethod
    public static int getBlue(int color) {
        return color & 0xFF;
    }

    @ZenMethod
    public static int blend(int color1, int color2, float blendRatio) {
        blendRatio = MathHelper.func_76131_a((float)blendRatio, (float)0.0f, (float)1.0f);
        int alpha1 = ColorHelper.getAlpha(color1);
        int red1 = ColorHelper.getRed(color1);
        int green1 = ColorHelper.getGreen(color1);
        int blue1 = ColorHelper.getBlue(color1);
        int alpha2 = ColorHelper.getAlpha(color2);
        int red2 = ColorHelper.getRed(color2);
        int green2 = ColorHelper.getGreen(color2);
        int blue2 = ColorHelper.getBlue(color2);
        int alpha = Math.max(alpha1, alpha2);
        int red = (int)((float)red1 + (float)(red2 - red1) * blendRatio);
        int green = (int)((float)green1 + (float)(green2 - green1) * blendRatio);
        int blue = (int)((float)blue1 + (float)(blue2 - blue1) * blendRatio);
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    @ZenMethod
    public static int glow(int color1, int color2, float glowFactor) {
        int alpha1 = ColorHelper.getAlpha(color1);
        int red1 = ColorHelper.getRed(color1);
        int green1 = ColorHelper.getGreen(color1);
        int blue1 = ColorHelper.getBlue(color1);
        int alpha2 = ColorHelper.getAlpha(color2);
        int red2 = ColorHelper.getRed(color2);
        int green2 = ColorHelper.getGreen(color2);
        int blue2 = ColorHelper.getBlue(color2);
        glowFactor = MathHelper.func_76131_a((float)glowFactor, (float)0.0f, (float)1.0f) * 255.0f / (float)Math.max(red1, Math.max(green1, blue1));
        int alpha = Math.max(alpha1, alpha2);
        int red = (int)((float)red1 + (float)(red2 - red1) * glowFactor * (float)red1 / 255.0f);
        int green = (int)((float)green1 + (float)(green2 - green1) * glowFactor * (float)green1 / 255.0f);
        int blue = (int)((float)blue1 + (float)(blue2 - blue1) * glowFactor * (float)blue1 / 255.0f);
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    @ZenMethod
    public static int waterBlend(int soluteColor, float blendRatio) {
        return ColorHelper.blend(3097588, soluteColor, blendRatio);
    }

    @ZenMethod
    public static int getNAKColor(int color) {
        return ColorHelper.blend(color, 16770492, 0.375f);
    }

    @ZenMethod
    public static int getFluorideColor(int color) {
        return ColorHelper.blend(color, 13879389, 0.125f);
    }

    @ZenMethod
    public static int getFLIBEColor(int color) {
        return ColorHelper.blend(color, 12699824, 0.4f);
    }

    @ZenMethod
    public static int getZAColor(int color) {
        return ColorHelper.glow(color, 0xDBDBAD, 0.4f);
    }
}

