/*
 * Decompiled with CFR 0.152.
 */
package nc.util;

import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Map;

public abstract class Cache<K, V, M extends Map<K, V>> {
    protected final M internalMap = this.initInternalMap();

    protected Cache() {
    }

    protected abstract M initInternalMap();

    public static class DoubleCache<K>
    extends Cache<K, Double, Object2DoubleMap<K>> {
        @Override
        public Object2DoubleMap<K> initInternalMap() {
            return new Object2DoubleOpenHashMap();
        }

        public double get(K key) {
            if (!((Object2DoubleMap)this.internalMap).containsKey(key)) {
                this.put(key, ((Object2DoubleMap)this.internalMap).defaultReturnValue());
            }
            return ((Object2DoubleMap)this.internalMap).getDouble(key);
        }

        public double put(K key, double value) {
            return ((Object2DoubleMap)this.internalMap).put(key, value);
        }
    }

    public static class FloatCache<K>
    extends Cache<K, Float, Object2FloatMap<K>> {
        @Override
        public Object2FloatMap<K> initInternalMap() {
            return new Object2FloatOpenHashMap();
        }

        public float get(K key) {
            if (!((Object2FloatMap)this.internalMap).containsKey(key)) {
                this.put(key, ((Object2FloatMap)this.internalMap).defaultReturnValue());
            }
            return ((Object2FloatMap)this.internalMap).getFloat(key);
        }

        public float put(K key, float value) {
            return ((Object2FloatMap)this.internalMap).put(key, value);
        }
    }

    public static class LongCache<K>
    extends Cache<K, Long, Object2LongMap<K>> {
        @Override
        public Object2LongMap<K> initInternalMap() {
            return new Object2LongOpenHashMap();
        }

        public long get(K key) {
            if (!((Object2LongMap)this.internalMap).containsKey(key)) {
                this.put(key, ((Object2LongMap)this.internalMap).defaultReturnValue());
            }
            return ((Object2LongMap)this.internalMap).getLong(key);
        }

        public long put(K key, long value) {
            return ((Object2LongMap)this.internalMap).put(key, value);
        }
    }

    public static class IntCache<K>
    extends Cache<K, Integer, Object2IntMap<K>> {
        @Override
        public Object2IntMap<K> initInternalMap() {
            return new Object2IntOpenHashMap();
        }

        public int get(K key) {
            if (!((Object2IntMap)this.internalMap).containsKey(key)) {
                this.put(key, ((Object2IntMap)this.internalMap).defaultReturnValue());
            }
            return ((Object2IntMap)this.internalMap).getInt(key);
        }

        public int put(K key, int value) {
            return ((Object2IntMap)this.internalMap).put(key, value);
        }
    }

    public static class BooleanCache<K>
    extends Cache<K, Boolean, Object2BooleanMap<K>> {
        @Override
        public Object2BooleanMap<K> initInternalMap() {
            return new Object2BooleanOpenHashMap();
        }

        public boolean get(K key) {
            if (!((Object2BooleanMap)this.internalMap).containsKey(key)) {
                this.put(key, ((Object2BooleanMap)this.internalMap).defaultReturnValue());
            }
            return ((Object2BooleanMap)this.internalMap).getBoolean(key);
        }

        public boolean put(K key, boolean value) {
            return ((Object2BooleanMap)this.internalMap).put(key, value);
        }
    }
}

