/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.radiation;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import nc.capability.radiation.source.IRadiationSource;
import nc.config.NCConfig;
import nc.radiation.RadiationHelper;
import nc.radiation.environment.RadiationEnvironmentHandler;
import nc.radiation.environment.RadiationEnvironmentInfo;
import nc.recipe.BasicRecipe;
import nc.recipe.NCRecipes;
import nc.recipe.RecipeStats;
import nc.tile.generator.TileItemFluidGenerator;
import nc.tile.internal.energy.EnergyConnection;
import nc.tile.internal.inventory.ItemSorption;
import nc.tile.radiation.ITileRadiationEnvironment;
import nc.util.FourPos;
import nc.util.MaterialHelper;
import nc.util.NBTHelper;
import nc.util.NCMath;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="opencomputers")
public class TileRadiationScrubber
extends TileItemFluidGenerator
implements ITileRadiationEnvironment,
SimpleComponent {
    private double efficiency = 0.0;
    private double scrubberFraction = 0.0;
    private double currentChunkLevel = 0.0;
    private double currentChunkBuffer = 0.0;
    public final ConcurrentMap<BlockPos, Integer> occlusionMap = new ConcurrentHashMap<BlockPos, Integer>();
    private int radCheckCount = 0;

    public TileRadiationScrubber() {
        super("radiation_scrubber", 1, 1, 1, 1, 0, TileRadiationScrubber.defaultItemSorptions(1, 1, new ItemSorption[0]), TileRadiationScrubber.defaultTankCapacities(32000, 1, 1), TileRadiationScrubber.defaultTankSorptions(1, 1), NCRecipes.radiation_scrubber_valid_fluids, NCMath.toInt(20 * RecipeStats.getScrubberMaxProcessPower()), NCRecipes.radiation_scrubber);
        this.setEnergyConnectionAll(EnergyConnection.IN);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.field_145850_b.field_72995_K) {
            for (int x = -NCConfig.radiation_scrubber_radius; x <= NCConfig.radiation_scrubber_radius; ++x) {
                for (int y = -NCConfig.radiation_scrubber_radius; y <= NCConfig.radiation_scrubber_radius; ++y) {
                    for (int z = -NCConfig.radiation_scrubber_radius; z <= NCConfig.radiation_scrubber_radius; ++z) {
                        RadiationEnvironmentHandler.addTile(this.getFourPos().add(x, y, z), this);
                    }
                }
            }
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            boolean wasProcessing = this.isProcessing;
            boolean shouldUpdate = false;
            this.isProcessing = this.isProcessing();
            if (this.isProcessing) {
                this.process();
            }
            if (wasProcessing != this.isProcessing) {
                shouldUpdate = true;
                this.setActivity(this.isProcessing);
            }
            this.tickRadCount();
            if (shouldUpdate || this.shouldRadCheck()) {
                this.checkRadiationEnvironmentInfo();
            }
            if (shouldUpdate) {
                this.func_70296_d();
            }
        }
    }

    @Override
    public boolean setRecipeStats() {
        if (this.recipeInfo == null) {
            this.baseProcessTime = 1.0;
            this.baseProcessPower = 0.0;
            this.efficiency = 0.0;
            return false;
        }
        BasicRecipe recipe = (BasicRecipe)this.recipeInfo.getRecipe();
        this.baseProcessTime = recipe.getScrubberProcessTime();
        this.baseProcessPower = recipe.getScrubberProcessPower();
        this.efficiency = recipe.getScrubberProcessEfficiency();
        return true;
    }

    public double getRawScrubberRate() {
        if (!this.isProcessing) {
            return 0.0;
        }
        double rateMult = this.currentChunkBuffer + NCConfig.radiation_spread_rate * Math.max(0.0, this.currentChunkLevel - this.currentChunkBuffer);
        if (NCConfig.radiation_scrubber_non_linear) {
            IRadiationSource chunkSource = RadiationHelper.getRadiationSource((ICapabilityProvider)this.field_145850_b.func_175726_f(this.field_174879_c));
            if (chunkSource == null || chunkSource.getEffectiveScrubberCount() == 0.0) {
                return 0.0;
            }
            return -rateMult * this.scrubberFraction * chunkSource.getScrubbingFraction() / chunkSource.getEffectiveScrubberCount();
        }
        return -rateMult * this.scrubberFraction;
    }

    public void tickRadCount() {
        ++this.radCheckCount;
        this.radCheckCount %= NCConfig.machine_update_rate * 20;
    }

    public boolean shouldRadCheck() {
        return this.radCheckCount == 0;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        RadiationEnvironmentHandler.removeTile(this);
    }

    @Override
    public boolean isProcessing() {
        return this.readyToProcess();
    }

    @Override
    public boolean readyToProcess() {
        return this.canProcessInputs && this.hasConsumed && this.hasSufficientEnergy();
    }

    public boolean hasSufficientEnergy() {
        return this.getEnergyStored() >= (int)this.baseProcessPower;
    }

    @Override
    public void process() {
        this.time += 1.0;
        this.getEnergyStorage().changeEnergyStored((int)(-this.baseProcessPower));
        if (this.time >= this.baseProcessTime) {
            this.finishProcess();
        }
    }

    @Override
    public int getSinkTier() {
        return 10;
    }

    @Override
    public int getSourceTier() {
        return 1;
    }

    @Override
    public void checkRadiationEnvironmentInfo() {
        double newScrubberFraction = TileRadiationScrubber.getMaxScrubberFraction();
        Iterator occlusionIterator = this.occlusionMap.entrySet().iterator();
        int occlusionCount = 0;
        double tileCount = 0.0;
        while (occlusionIterator.hasNext()) {
            Map.Entry occlusion = occlusionIterator.next();
            if (TileRadiationScrubber.isOcclusive(this.field_174879_c, this.field_145850_b, (BlockPos)occlusion.getKey())) {
                newScrubberFraction -= TileRadiationScrubber.getOcclusionPenalty() / this.field_174879_c.func_177951_i((Vec3i)occlusion.getKey());
                ++occlusionCount;
                tileCount += Math.max(1.0, Math.sqrt(((Integer)occlusion.getValue()).intValue()));
                continue;
            }
            occlusionIterator.remove();
        }
        this.scrubberFraction = this.efficiency * (occlusionCount == 0 ? TileRadiationScrubber.getMaxScrubberFraction() : Math.max(0.0, newScrubberFraction * (double)occlusionCount / tileCount));
    }

    @Override
    public void handleRadiationEnvironmentInfo(RadiationEnvironmentInfo info) {
        FourPos fourPos = this.getFourPos();
        FourPos infoPos = info.pos;
        if (fourPos.getDimension() == infoPos.getDimension() && !fourPos.equals(infoPos) && !info.tileMap.isEmpty()) {
            this.occlusionMap.put(infoPos.getBlockPos(), Math.max(1, info.tileMap.size()));
        }
    }

    @Override
    public double getRadiationContributionFraction() {
        return this.isProcessing ? -this.scrubberFraction : 0.0;
    }

    @Override
    public double getCurrentChunkRadiationLevel() {
        return this.currentChunkLevel;
    }

    @Override
    public void setCurrentChunkRadiationLevel(double level) {
        this.currentChunkLevel = level;
    }

    @Override
    public double getCurrentChunkRadiationBuffer() {
        return this.currentChunkBuffer;
    }

    @Override
    public void setCurrentChunkRadiationBuffer(double buffer) {
        this.currentChunkBuffer = buffer;
    }

    public static double getMaxScrubberFraction() {
        return NCConfig.radiation_scrubber_non_linear ? 1.0 : NCConfig.radiation_scrubber_fraction;
    }

    private static double getOcclusionPenalty() {
        return TileRadiationScrubber.getMaxScrubberFraction() / 52.0;
    }

    private static boolean isOcclusive(BlockPos pos, World world, BlockPos otherPos) {
        IBlockState state = world.func_180495_p(otherPos);
        return pos.func_177951_i((Vec3i)otherPos) < (double)NCMath.sq(NCConfig.radiation_scrubber_radius) && !MaterialHelper.isEmpty(state.func_185904_a()) && (state.func_185914_p() || !state.func_185904_a().func_76218_k());
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TileRadiationScrubber)) {
            return false;
        }
        return this.getFourPos().equals(((TileRadiationScrubber)obj).getFourPos());
    }

    @Override
    public boolean shouldSaveRadiation() {
        return false;
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        nbt.func_74780_a("baseProcessTime", this.baseProcessTime);
        nbt.func_74780_a("baseProcessPower", this.baseProcessPower);
        nbt.func_74780_a("efficiency", this.efficiency);
        nbt.func_74780_a("scrubberFraction", this.scrubberFraction);
        nbt.func_74780_a("currentChunkLevel", this.currentChunkLevel);
        nbt.func_74780_a("currentChunkBuffer", this.currentChunkBuffer);
        NBTHelper.writeBlockPosToIntegerMap(nbt, this.occlusionMap, "occlusionMap");
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.baseProcessTime = nbt.func_74769_h("baseProcessTime");
        this.baseProcessPower = nbt.func_74769_h("baseProcessPower");
        this.efficiency = nbt.func_74769_h("efficiency");
        this.scrubberFraction = nbt.func_74769_h("scrubberFraction");
        this.currentChunkLevel = nbt.func_74769_h("currentChunkLevel");
        this.currentChunkBuffer = nbt.func_74769_h("currentChunkBuffer");
        NBTHelper.readBlockPosToIntegerMap(nbt, this.occlusionMap, "occlusionMap");
    }

    @Optional.Method(modid="opencomputers")
    public String getComponentName() {
        return "nc_radiation_scrubber";
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getRadiationRemovalRate(Context context, Arguments args) {
        return new Object[]{this.getRawScrubberRate()};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getEfficiency(Context context, Arguments args) {
        return new Object[]{Math.abs(100.0 * this.getRadiationContributionFraction() / TileRadiationScrubber.getMaxScrubberFraction())};
    }
}

