/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.processor;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import nc.recipe.ingredient.IFluidIngredient;
import nc.tile.fluid.ITileFluid;
import nc.tile.internal.fluid.Tank;
import nc.tile.internal.fluid.TankSorption;
import nc.tile.processor.IProcessor;

public interface IFluidProcessor
extends IProcessor,
ITileFluid {
    public int getFluidInputSize();

    public int getFluidOutputputSize();

    public List<Tank> getFluidInputs();

    public List<IFluidIngredient> getFluidIngredients();

    public List<IFluidIngredient> getFluidProducts();

    public static IntList defaultTankCapacities(int capacity, int inSize, int outSize) {
        IntArrayList tankCapacities = new IntArrayList();
        for (int i = 0; i < inSize + outSize; ++i) {
            tankCapacities.add(capacity);
        }
        return tankCapacities;
    }

    public static List<TankSorption> defaultTankSorptions(int inSize, int outSize) {
        int i;
        ArrayList<TankSorption> tankSorptions = new ArrayList<TankSorption>();
        for (i = 0; i < inSize; ++i) {
            tankSorptions.add(TankSorption.IN);
        }
        for (i = 0; i < outSize; ++i) {
            tankSorptions.add(TankSorption.OUT);
        }
        return tankSorptions;
    }
}

