/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.internal.inventory;

import javax.annotation.Nonnull;
import nc.tile.inventory.ITileInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemHandler<T extends ITileInventory>
implements IItemHandlerModifiable {
    protected final T tile;
    protected final EnumFacing side;

    public ItemHandler(T tile, EnumFacing side) {
        this.tile = tile;
        this.side = side;
    }

    public int getSlots() {
        return this.side == null ? this.tile.func_70302_i_() : this.tile.func_180463_a(this.side).length;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        int i = this.getSlot(slot);
        return i == -1 ? ItemStack.field_190927_a : this.tile.func_70301_a(i);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int slot1 = this.getSlot(slot);
        if (slot1 == -1) {
            return stack;
        }
        ItemStack stackInSlot = this.tile.func_70301_a(slot1);
        if (!stackInSlot.func_190926_b()) {
            if (stackInSlot.func_190916_E() >= this.getSlotStackLimit(stackInSlot, slot)) {
                return stack;
            }
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)stackInSlot)) {
                return stack;
            }
            if (this.side != null && !this.tile.func_180462_a(slot1, stack, this.side) || !this.tile.func_94041_b(slot1, stack)) {
                return stack;
            }
            int m = this.getStackSplitSize(stack, stackInSlot.func_190916_E(), slot);
            if (stack.func_190916_E() <= m) {
                if (!simulate) {
                    ItemStack copy = stack.func_77946_l();
                    copy.func_190917_f(stackInSlot.func_190916_E());
                    this.setInventorySlotContents(slot1, copy);
                }
                return ItemStack.field_190927_a;
            }
            stack = stack.func_77946_l();
            if (!simulate) {
                ItemStack copy = stack.func_77979_a(m);
                copy.func_190917_f(stackInSlot.func_190916_E());
                this.setInventorySlotContents(slot1, copy);
                return stack;
            }
            stack.func_190918_g(m);
            return stack;
        }
        if (this.side != null && !this.tile.func_180462_a(slot1, stack, this.side) || !this.tile.func_94041_b(slot1, stack)) {
            return stack;
        }
        int m = this.getStackSplitSize(stack, 0, slot);
        if (m < stack.func_190916_E()) {
            stack = stack.func_77946_l();
            if (!simulate) {
                this.setInventorySlotContents(slot1, stack.func_77979_a(m));
                return stack;
            }
            stack.func_190918_g(m);
            return stack;
        }
        if (!simulate) {
            this.setInventorySlotContents(slot1, stack);
        }
        return ItemStack.field_190927_a;
    }

    protected int getStackSplitSize(ItemStack stack, int slotStackCount, int slot) {
        return Math.min(stack.func_77976_d(), this.getSlotLimit(slot)) - slotStackCount;
    }

    protected int getSlotStackLimit(ItemStack stackInSlot, int slot) {
        return Math.min(stackInSlot.func_77976_d(), this.getSlotLimit(slot));
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        int slot1 = this.getSlot(slot);
        if (slot1 == -1) {
            return ItemStack.field_190927_a;
        }
        ItemStack stackInSlot = this.tile.func_70301_a(slot1);
        if (stackInSlot.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (this.side != null && !this.tile.func_180461_b(slot1, stackInSlot, this.side)) {
            return ItemStack.field_190927_a;
        }
        if (simulate) {
            if (stackInSlot.func_190916_E() < amount) {
                return stackInSlot.func_77946_l();
            }
            ItemStack copy = stackInSlot.func_77946_l();
            copy.func_190920_e(amount);
            return copy;
        }
        int m = Math.min(stackInSlot.func_190916_E(), amount);
        ItemStack ret = this.tile.func_70298_a(slot1, m);
        this.tile.func_70296_d();
        return ret;
    }

    public int getSlotLimit(int slot) {
        return this.tile.func_70297_j_();
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        int i = this.getSlot(slot);
        if (i != -1) {
            this.setInventorySlotContents(i, stack);
        }
    }

    protected void setInventorySlotContents(int slot, ItemStack stack) {
        this.tile.func_70296_d();
        this.tile.func_70299_a(slot, stack);
    }

    public int getSlot(int slot) {
        return this.side == null ? (slot < this.getSlots() ? slot : -1) : (slot < this.getSlots() ? this.tile.func_180463_a(this.side)[slot] : -1);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ItemHandler) {
            ItemHandler handler = (ItemHandler)obj;
            return this.tile.equals(handler.tile) && this.side == handler.side;
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.tile.hashCode() + (this.side == null ? 0 : this.side.hashCode());
    }
}

