/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.internal.heat;

import nc.util.NCMath;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class HeatBuffer {
    private long heatStored;
    private long heatCapacity;

    public HeatBuffer(long capacity) {
        this.heatCapacity = capacity;
    }

    public long removeHeat(long heat, boolean simulated) {
        long heatRemoved = Math.min(this.heatStored, heat);
        if (!simulated) {
            this.heatStored -= heatRemoved;
        }
        return heatRemoved;
    }

    public long addHeat(long heat, boolean simulated) {
        long heatAdded = Math.min(this.heatCapacity - this.heatStored, heat);
        if (!simulated) {
            this.heatStored += heatAdded;
        }
        return heatAdded;
    }

    public long getHeatStored() {
        return this.heatStored;
    }

    public long getHeatCapacity() {
        return this.heatCapacity;
    }

    public void changeHeatStored(long heat) {
        this.heatStored = NCMath.clamp(this.heatStored + heat, 0L, this.heatCapacity);
    }

    public void setHeatStored(long heat) {
        this.heatStored = Math.max(0L, heat);
    }

    public void setHeatCapacity(long newCapacity) {
        this.heatCapacity = Math.max(0L, newCapacity);
    }

    public boolean isFull() {
        return this.heatStored >= this.heatCapacity;
    }

    public boolean isEmpty() {
        return this.heatStored == 0L;
    }

    public void mergeHeatBuffers(HeatBuffer other) {
        this.setHeatStored(this.heatStored + other.heatStored);
        this.setHeatCapacity(this.heatCapacity + other.heatCapacity);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt, String name) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74772_a("heatStored", this.heatStored);
        tag.func_74772_a("heatCapacity", this.heatCapacity);
        nbt.func_74782_a(name, (NBTBase)tag);
        return nbt;
    }

    public HeatBuffer readFromNBT(NBTTagCompound nbt, String name) {
        if (nbt.func_150297_b(name, 10)) {
            NBTTagCompound tag = nbt.func_74775_l(name);
            this.heatStored = tag.func_74763_f("heatStored");
            this.heatCapacity = tag.func_74763_f("heatCapacity");
        }
        return this;
    }
}

