/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.internal.fluid;

import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.ITubeConnection;
import nc.tile.fluid.ITileFluid;
import nc.tile.internal.fluid.Tank;
import nc.util.GasHelper;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="mekanism.api.gas.ITubeConnection", modid="mekanism"), @Optional.Interface(iface="mekanism.api.gas.IGasHandler", modid="mekanism")})
public class GasTileWrapper
implements ITubeConnection,
IGasHandler {
    public final ITileFluid tile;

    public GasTileWrapper(ITileFluid tile) {
        this.tile = tile;
    }

    @Optional.Method(modid="mekanism")
    public boolean canTubeConnect(EnumFacing side) {
        return this.tile.canConnectFluid(side);
    }

    @Optional.Method(modid="mekanism")
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        int amount = this.tile.fill(side, GasHelper.getFluidFromGas(stack), doTransfer);
        this.tile.onWrapperReceiveGas(amount, doTransfer);
        return amount;
    }

    @Optional.Method(modid="mekanism")
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        GasStack stack = GasHelper.getGasFromFluid(this.tile.drain(side, amount, doTransfer));
        this.tile.onWrapperDrawGas(stack, doTransfer);
        return stack;
    }

    @Optional.Method(modid="mekanism")
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        Fluid fluid = type.getFluid();
        if (fluid == null) {
            return false;
        }
        for (Tank tank : this.tile.getTanks()) {
            if (!tank.canFillFluidType(fluid)) continue;
            return true;
        }
        return false;
    }

    @Optional.Method(modid="mekanism")
    public boolean canDrawGas(EnumFacing side, Gas type) {
        return type.getFluid() != null && FluidRegistry.getFluid((String)type.getFluid().getName()) != null;
    }
}

