/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.internal.energy;

import nc.config.NCConfig;
import nc.util.NCMath;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyStorage
implements IEnergyStorage {
    private long energyStored;
    private long energyCapacity;
    private int maxTransfer;

    public EnergyStorage(long capacity) {
        this(capacity, NCMath.toInt(capacity));
    }

    public EnergyStorage(long capacity, int maxTransfer) {
        this.setStorageCapacity(capacity);
        this.setMaxTransfer(maxTransfer);
    }

    public EnergyStorage(long capacity, int maxTransfer, long energy) {
        this(capacity, maxTransfer);
        this.setEnergyStored(energy);
    }

    public final int getEnergyStored() {
        return NCMath.toInt(this.getEnergyStoredLong());
    }

    public final int getMaxEnergyStored() {
        return NCMath.toInt(this.getMaxEnergyStoredLong());
    }

    public int getMaxTransfer() {
        return this.maxTransfer;
    }

    public long getEnergyStoredLong() {
        return Math.min(this.energyStored, this.energyCapacity);
    }

    public long getMaxEnergyStoredLong() {
        return this.energyCapacity;
    }

    public boolean canReceive() {
        return true;
    }

    public boolean canExtract() {
        return true;
    }

    public int receiveEnergy(int receive, boolean simulated) {
        int energyReceived = Math.min(NCMath.toInt(this.energyCapacity - this.energyStored), Math.min(this.maxTransfer, receive));
        if (energyReceived <= 0) {
            return 0;
        }
        if (!simulated) {
            this.changeEnergyStored(energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(int extract, boolean simulated) {
        int energyExtracted = Math.min(NCMath.toInt(this.energyStored), Math.min(this.maxTransfer, extract));
        if (energyExtracted <= 0) {
            return 0;
        }
        if (!simulated) {
            this.changeEnergyStored(-energyExtracted);
        }
        return energyExtracted;
    }

    public void changeEnergyStored(long energy) {
        this.energyStored = NCMath.clamp(this.energyStored + energy, 0L, this.energyCapacity);
    }

    public void setEnergyStored(long energy) {
        this.energyStored = Math.max(0L, energy);
    }

    public void setStorageCapacity(long newCapacity) {
        this.energyCapacity = Math.max(newCapacity, (long)NCConfig.rf_per_eu);
    }

    public void setMaxTransfer(int newMaxTransfer) {
        this.maxTransfer = Math.max(newMaxTransfer, NCConfig.rf_per_eu);
    }

    public void cullEnergyStored() {
        if (this.energyStored > this.energyCapacity) {
            this.setEnergyStored(this.energyCapacity);
        }
    }

    public boolean isFull() {
        return this.energyStored >= this.energyCapacity;
    }

    public boolean isEmpty() {
        return this.energyStored == 0L;
    }

    public void mergeEnergyStorage(EnergyStorage other) {
        this.setStorageCapacity(this.getMaxEnergyStoredLong() + other.getMaxEnergyStoredLong());
        this.setEnergyStored(this.getEnergyStoredLong() + other.getEnergyStoredLong());
        other.setEnergyStored(0L);
    }

    public final NBTTagCompound writeToNBT(NBTTagCompound nbt, String name) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74772_a("energy", this.energyStored);
        tag.func_74772_a("capacity", this.energyCapacity);
        nbt.func_74782_a(name, (NBTBase)tag);
        return nbt;
    }

    public final EnergyStorage readFromNBT(NBTTagCompound nbt, String name) {
        if (nbt.func_150297_b(name, 10)) {
            NBTTagCompound tag = nbt.func_74775_l(name);
            this.energyStored = tag.func_74763_f("energy");
            if (tag.func_150297_b("capacity", 99)) {
                this.energyCapacity = tag.func_74763_f("capacity");
            }
        }
        return this;
    }
}

