/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.processor;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import nc.recipe.BasicRecipeHandler;
import nc.util.FissionHelper;

public class SeparatorRecipes
extends BasicRecipeHandler {
    public SeparatorRecipes() {
        super("separator", 1, 0, 2, 0);
    }

    @Override
    public void addRecipes() {
        for (String type : new String[]{"", "Carbide", "Oxide", "Nitride", "ZA"}) {
            this.addRecipe(SeparatorRecipes.oreStackList(Lists.newArrayList((Object[])new String[]{"ingotUranium" + type, "dustUranium" + type}), 10), SeparatorRecipes.oreStack("ingotUranium238" + type, 9), SeparatorRecipes.oreStack("ingotUranium235" + type, 1), 5.0, 1.0);
        }
        this.addRecipe(SeparatorRecipes.oreStackList(Lists.newArrayList((Object[])new String[]{"ingotBoron", "dustBoron"}), 12), SeparatorRecipes.oreStack("ingotBoron11", 9), SeparatorRecipes.oreStack("ingotBoron10", 3), 6.0, 1.0);
        this.addRecipe(SeparatorRecipes.oreStackList(Lists.newArrayList((Object[])new String[]{"ingotLithium", "dustLithium"}), 10), SeparatorRecipes.oreStack("ingotLithium7", 9), SeparatorRecipes.oreStack("ingotLithium6", 1), 5.0, 1.0);
        this.addFuelSeparationRecipes("U", "Uranium", 238, 233, 235);
        this.addFuelSeparationRecipes("N", "Neptunium", 237, 236);
        this.addFuelSeparationRecipes("P", "Plutonium", 242, 239, 241);
        for (int fissile : new int[]{239, 241}) {
            for (String type : new String[]{"", "Carbide", "Oxide", "Nitride", "ZA"}) {
                this.addRecipe(SeparatorRecipes.oreStack("ingotMIX" + fissile + type, 9), SeparatorRecipes.oreStack("ingotUranium238" + type, 8), SeparatorRecipes.oreStack("ingotPlutonium" + fissile + type, 1), 1.0, 1.0);
            }
        }
        this.addFuelSeparationRecipes("A", "Americium", 243, 242);
        this.addFuelSeparationRecipes("Cm", "Curium", 246, 243, 245, 247);
        this.addFuelSeparationRecipes("B", "Berkelium", 247, 248);
        this.addFuelSeparationRecipes("Cf", "Californium", 252, 249, 251);
        this.addFissionAlloyRecipes();
    }

    public void addFuelSeparationRecipes(String fuel, String element, int fertile, int ... fissiles) {
        for (int fissile : fissiles) {
            for (String type : new String[]{"", "Oxide", "Nitride"}) {
                this.addRecipe(SeparatorRecipes.oreStack("ingotLE" + fuel + fissile + type, 9), SeparatorRecipes.oreStack("ingot" + element + fertile + type, 8), SeparatorRecipes.oreStack("ingot" + element + fissile + type, 1), 1.0, 1.0);
                this.addRecipe(SeparatorRecipes.oreStack("ingotHE" + fuel + fissile + type, 9), SeparatorRecipes.oreStack("ingot" + element + fertile + type, 6), SeparatorRecipes.oreStack("ingot" + element + fissile + type, 3), 1.0, 1.0);
            }
        }
    }

    public void addFissionAlloyRecipes() {
        for (String element : FissionHelper.FISSION_ORE_DICT) {
            this.addRecipe("ingot" + element + "ZA", "ingot" + element, "dustZirconium", 1.0, 1.0);
            this.addRecipe("ingot" + element + "Carbide", "ingot" + element, "dustGraphite", 1.0, 1.0);
        }
    }

    @Override
    public List<Object> fixExtras(List<Object> extras) {
        ArrayList<Object> fixed = new ArrayList<Object>(3);
        fixed.add(extras.size() > 0 && extras.get(0) instanceof Double ? (Double)extras.get(0) : 1.0);
        fixed.add(extras.size() > 1 && extras.get(1) instanceof Double ? (Double)extras.get(1) : 1.0);
        fixed.add(extras.size() > 2 && extras.get(2) instanceof Double ? (Double)extras.get(2) : 0.0);
        return fixed;
    }
}

