/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.processor;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import nc.init.NCItems;
import nc.recipe.BasicRecipeHandler;
import nc.util.FissionHelper;
import nc.util.OreDictHelper;
import nc.util.StringHelper;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraftforge.fluids.FluidRegistry;

public class IngotFormerRecipes
extends BasicRecipeHandler {
    private static final Set<String> CASTING_BLACKLIST = Sets.newHashSet((Object[])new String[]{"glass", "coal", "redstone", "glowstone", "prismarine", "obsidian", "silicon", "marshmallow"});

    public IngotFormerRecipes() {
        super("ingot_former", 0, 1, 1, 0);
    }

    @Override
    public void addRecipes() {
        this.addIngotFormingRecipes();
        this.addIngotFormingRecipe("boron_10", "Boron10");
        this.addIngotFormingRecipe("boron_11", "Boron11");
        this.addIngotFormingRecipe("lithium_6", "Lithium6");
        this.addIngotFormingRecipe("lithium_7", "Lithium7");
        this.addIngotFormingRecipe("hard_carbon", "HardCarbon");
        this.addIngotFormingRecipe("manganese_dioxide", "ManganeseDioxide");
        this.addIngotFormingRecipe("lead_platinum", "LeadPlatinum");
        this.addRecipe(IngotFormerRecipes.fluidStack("bas", 666), "gemBoronArsenide", 2.0, 2.0);
        this.addRecipe(IngotFormerRecipes.fluidStack("redstone", 100), "ingotRedstone", 0.25, 1.0);
        this.addRecipe(IngotFormerRecipes.fluidStack("glowstone", 250), "ingotGlowstone", 0.25, 1.0);
        this.addRecipe(IngotFormerRecipes.fluidStack("coal", 100), "ingotGraphite", 0.5, 1.0);
        this.addRecipe(IngotFormerRecipes.fluidStack("prismarine", 144), "gemPrismarine", 1.0, 1.0);
        this.addRecipe(IngotFormerRecipes.fluidStack("slime", 144), Items.field_151123_aH, 1.0, 1.0);
        if (OreDictHelper.oreExists("ingotSilicon")) {
            this.addRecipe(IngotFormerRecipes.fluidStack("silicon", 144), "ingotSilicon", 1.0, 1.0);
        } else {
            this.addRecipe(IngotFormerRecipes.fluidStack("silicon", 144), "itemSilicon", 1.0, 1.0);
        }
        if (OreDictHelper.oreExists("ingotObsidian")) {
            this.addRecipe(IngotFormerRecipes.fluidStack("obsidian", 72), "ingotObsidian", 0.5, 1.0);
        } else {
            this.addRecipe(IngotFormerRecipes.fluidStack("obsidian", 288), "obsidian", 2.0, 1.0);
        }
        this.addRecipe(IngotFormerRecipes.fluidStack("nether_brick", 72), "ingotBrickNether", 0.5, 1.0);
        this.addRecipe(IngotFormerRecipes.fluidStack("end_stone", 288), "endstone", 2.0, 1.0);
        this.addRecipe(IngotFormerRecipes.fluidStack("purpur", 288), Blocks.field_185767_cT, 2.0, 1.0);
        this.addIngotFormingRecipe("electrical_steel", "ElectricalSteel");
        this.addIngotFormingRecipe("energetic_alloy", "EnergeticAlloy");
        this.addIngotFormingRecipe("vibrant_alloy", "VibrantAlloy");
        this.addIngotFormingRecipe("redstone_alloy", "RedstoneAlloy");
        this.addIngotFormingRecipe("conductive_iron", "ConductiveIron");
        this.addIngotFormingRecipe("pulsating_iron", "PulsatingIron");
        this.addIngotFormingRecipe("dark_steel", "DarkSteel");
        this.addIngotFormingRecipe("soularium", "Soularium");
        this.addIngotFormingRecipe("end_steel", "EndSteel");
        this.addIngotFormingRecipe("construction_alloy", "ConstructionAlloy");
        this.addIngotFormingRecipe("crude_steel", "CrudeSteel");
        this.addIngotFormingRecipe("crystalline_alloy", "CrystallineAlloy");
        this.addIngotFormingRecipe("melodic_alloy", "MelodicAlloy");
        this.addIngotFormingRecipe("stellar_alloy", "StellarAlloy");
        this.addIngotFormingRecipe("crystalline_pink_slime", "CrystallinePinkSlime");
        this.addIngotFormingRecipe("energetic_silver", "EnergeticSilver");
        this.addIngotFormingRecipe("vivid_alloy", "VividAlloy");
        this.addRecipe(IngotFormerRecipes.fluidStack("brine", 15), "dustSalt", 0.25, 0.5);
        this.addRecipe(IngotFormerRecipes.fluidStack("cocoa_butter", 144), "ingotCocoaButter", 0.5, 0.5);
        this.addRecipe(IngotFormerRecipes.fluidStack("unsweetened_chocolate", 144), "ingotUnsweetenedChocolate", 0.5, 0.5);
        this.addRecipe(IngotFormerRecipes.fluidStack("dark_chocolate", 144), "ingotDarkChocolate", 0.5, 0.5);
        this.addRecipe(IngotFormerRecipes.fluidStack("milk_chocolate", 144), "ingotChocolate", 0.5, 0.5);
        this.addRecipe(IngotFormerRecipes.fluidStack("sugar", 144), Items.field_151102_aT, 0.5, 0.5);
        this.addRecipe(IngotFormerRecipes.fluidStack("gelatin", 144), NCItems.gelatin, 0.5, 0.5);
        this.addRecipe(IngotFormerRecipes.fluidStack("marshmallow", 144), "ingotMarshmallow", 0.5, 0.5);
        this.addFissionFormingRecipes();
    }

    public void addIngotFormingRecipe(String fluid, String metal) {
        this.addRecipe(IngotFormerRecipes.fluidStack(fluid, 144), "ingot" + metal, 1.0, 1.0);
    }

    public void addIngotFormingRecipe(String metal) {
        this.addIngotFormingRecipe(metal, StringHelper.capitalize(metal));
    }

    public void addFissionFormingRecipes() {
        for (int i = 0; i < FissionHelper.FISSION_ORE_DICT.length; ++i) {
            this.addRecipe(IngotFormerRecipes.fluidStack(FissionHelper.FISSION_FLUID[i], 144), "ingot" + FissionHelper.FISSION_ORE_DICT[i], 1.0, 1.0);
        }
    }

    public void addIngotFormingRecipes() {
        ArrayList fluidList = new ArrayList(FluidRegistry.getRegisteredFluids().keySet());
        for (String fluidName : fluidList) {
            if (CASTING_BLACKLIST.contains(fluidName)) continue;
            String oreSuffix = StringHelper.capitalize(fluidName);
            String ingot = "ingot" + oreSuffix;
            String gem = "gem" + oreSuffix;
            if (OreDictHelper.oreExists(ingot)) {
                this.addRecipe(IngotFormerRecipes.fluidStack(fluidName, 144), ingot, 1.0, 1.0);
                continue;
            }
            if (!OreDictHelper.oreExists(gem)) continue;
            this.addRecipe(IngotFormerRecipes.fluidStack(fluidName, 666), gem, 1.0, 1.0);
        }
    }

    @Override
    public List<Object> fixExtras(List<Object> extras) {
        ArrayList<Object> fixed = new ArrayList<Object>(3);
        fixed.add(extras.size() > 0 && extras.get(0) instanceof Double ? (Double)extras.get(0) : 1.0);
        fixed.add(extras.size() > 1 && extras.get(1) instanceof Double ? (Double)extras.get(1) : 1.0);
        fixed.add(extras.size() > 2 && extras.get(2) instanceof Double ? (Double)extras.get(2) : 0.0);
        return fixed;
    }
}

