/*
 * Decompiled with CFR 0.152.
 */
package nc.radiation;

import it.unimi.dsi.fastutil.ints.Int2DoubleMap;
import it.unimi.dsi.fastutil.ints.Int2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.List;
import nc.ModCheck;
import nc.config.NCConfig;
import nc.init.NCBlocks;
import nc.init.NCItems;
import nc.util.OreDictHelper;
import nc.util.RegistryHelper;
import nc.util.StringHelper;
import net.minecraft.block.Block;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class RadSources {
    public static final ObjectSet<String> ORE_BLACKLIST = new ObjectOpenHashSet();
    public static final IntSet STACK_BLACKLIST = new IntOpenHashSet();
    public static final ObjectSet<String> FLUID_BLACKLIST = new ObjectOpenHashSet();
    public static final Object2DoubleMap<String> ORE_MAP = new Object2DoubleOpenHashMap();
    public static final Int2DoubleMap STACK_MAP = new Int2DoubleOpenHashMap();
    public static final Object2DoubleMap<String> FLUID_MAP = new Object2DoubleOpenHashMap();
    public static final Int2DoubleMap FOOD_RAD_MAP = new Int2DoubleOpenHashMap();
    public static final Int2DoubleMap FOOD_RESISTANCE_MAP = new Int2DoubleOpenHashMap();
    public static final List<Runnable> RUNNABLES = new ArrayList<Runnable>();
    private static final Object2DoubleMap<String> PREFIX_MULTIPLIER_MAP = new Object2DoubleOpenHashMap();
    private static final double FLUID_MULTIPLIER = 6.944444444444445;
    public static final double FUSION = 3.15E-7;
    public static final double NEUTRON = 0.00505;
    public static final double TRITIUM = 0.0115;
    public static final double CORIUM = 1.65E-5;
    public static final double THORIUM = 7.15E-11;
    public static final double URANIUM = 3.85E-10;
    public static final double PLUTONIUM = 4.2E-5;
    public static final double BISMUTH = 4.975E-20;
    public static final double RADIUM = 6.25E-4;
    public static final double POLONIUM = 0.29333333333333333;
    public static final double PROTACTINIUM_233 = 1.5044444444444443;
    public static final double TBP;
    public static final double STRONTIUM_90 = 0.0345;
    public static final double RUTHENIUM_106 = 0.98;
    public static final double CAESIUM_137 = 0.033;
    public static final double PROMETHIUM_147 = 0.38;
    public static final double EUROPIUM_155 = 0.21;
    public static final double URANIUM_233 = 6.3E-6;
    public static final double URANIUM_235 = 1.45E-9;
    public static final double URANIUM_238 = 2.25E-10;
    public static final double NEPTUNIUM_236 = 6.5E-6;
    public static final double NEPTUNIUM_237 = 4.7E-7;
    public static final double PLUTONIUM_238 = 0.0115;
    public static final double PLUTONIUM_239 = 4.15E-5;
    public static final double PLUTONIUM_241 = 0.0715;
    public static final double PLUTONIUM_242 = 2.7E-6;
    public static final double AMERICIUM_241 = 0.00235;
    public static final double AMERICIUM_242 = 0.0071;
    public static final double AMERICIUM_243 = 1.4E-4;
    public static final double CURIUM_243 = 0.0345;
    public static final double CURIUM_245 = 1.2E-4;
    public static final double CURIUM_246 = 2.15E-4;
    public static final double CURIUM_247 = 6.45E-8;
    public static final double BERKELIUM_247 = 7.25E-4;
    public static final double BERKELIUM_248 = 0.00325;
    public static final double CALIFORNIUM_249 = 0.00285;
    public static final double CALIFORNIUM_250 = 0.0765;
    public static final double CALIFORNIUM_251 = 0.00115;
    public static final double CALIFORNIUM_252 = 0.38;
    public static final double TBU;
    public static final double LEU_233;
    public static final double HEU_233;
    public static final double LEU_235;
    public static final double HEU_235;
    public static final double LEN_236;
    public static final double HEN_236;
    public static final double LEP_239;
    public static final double HEP_239;
    public static final double LEP_241;
    public static final double HEP_241;
    public static final double MIX_239;
    public static final double MIX_241;
    public static final double LEA_242;
    public static final double HEA_242;
    public static final double LECm_243;
    public static final double HECm_243;
    public static final double LECm_245;
    public static final double HECm_245;
    public static final double LECm_247;
    public static final double HECm_247;
    public static final double LEB_248;
    public static final double HEB_248;
    public static final double LECf_249;
    public static final double HECf_249;
    public static final double LECf_251;
    public static final double HECf_251;
    public static final double DEPLETED_TBU;
    public static final double DEPLETED_LEU_233;
    public static final double DEPLETED_HEU_233;
    public static final double DEPLETED_LEU_235;
    public static final double DEPLETED_HEU_235;
    public static final double DEPLETED_LEN_236;
    public static final double DEPLETED_HEN_236;
    public static final double DEPLETED_LEP_239;
    public static final double DEPLETED_HEP_239;
    public static final double DEPLETED_LEP_241;
    public static final double DEPLETED_HEP_241;
    public static final double DEPLETED_MIX_239;
    public static final double DEPLETED_MIX_241;
    public static final double DEPLETED_LEA_242;
    public static final double DEPLETED_HEA_242;
    public static final double DEPLETED_LECm_243;
    public static final double DEPLETED_HECm_243;
    public static final double DEPLETED_LECm_245;
    public static final double DEPLETED_HECm_245;
    public static final double DEPLETED_LECm_247;
    public static final double DEPLETED_HECm_247;
    public static final double DEPLETED_LEB_248;
    public static final double DEPLETED_HEB_248;
    public static final double DEPLETED_LECf_249;
    public static final double DEPLETED_HECf_249;
    public static final double DEPLETED_LECf_251;
    public static final double DEPLETED_HECf_251;
    public static final double TBU_FISSION;
    public static final double LEU_233_FISSION;
    public static final double HEU_233_FISSION;
    public static final double LEU_235_FISSION;
    public static final double HEU_235_FISSION;
    public static final double LEN_236_FISSION;
    public static final double HEN_236_FISSION;
    public static final double LEP_239_FISSION;
    public static final double HEP_239_FISSION;
    public static final double LEP_241_FISSION;
    public static final double HEP_241_FISSION;
    public static final double MIX_239_FISSION;
    public static final double MIX_241_FISSION;
    public static final double LEA_242_FISSION;
    public static final double HEA_242_FISSION;
    public static final double LECm_243_FISSION;
    public static final double HECm_243_FISSION;
    public static final double LECm_245_FISSION;
    public static final double HECm_245_FISSION;
    public static final double LECm_247_FISSION;
    public static final double HECm_247_FISSION;
    public static final double LEB_248_FISSION;
    public static final double HEB_248_FISSION;
    public static final double LECf_249_FISSION;
    public static final double HECf_249_FISSION;
    public static final double LECf_251_FISSION;
    public static final double HECf_251_FISSION;

    public static void addToOreBlacklist(String ore) {
        if (StringHelper.isGlob(ore)) {
            OreDictHelper.addWildcard(ORE_BLACKLIST, ore);
        } else {
            ORE_BLACKLIST.add((Object)ore);
        }
    }

    public static void addToStackBlacklist(ItemStack stack) {
        if (stack != null) {
            STACK_BLACKLIST.add(RecipeItemHelper.func_194113_b((ItemStack)stack));
        }
    }

    public static void addToFluidBlacklist(String fluidName) {
        FLUID_BLACKLIST.add((Object)fluidName);
    }

    public static void addToOreMap(String ore, double radiation) {
        if (ORE_BLACKLIST.contains((Object)ore)) {
            return;
        }
        if (StringHelper.isGlob(ore)) {
            OreDictHelper.putWildcard(ORE_MAP, ore, radiation);
        } else {
            ORE_MAP.put((Object)ore, radiation);
        }
    }

    public static void addToStackMap(ItemStack stack, double radiation) {
        int packed = RecipeItemHelper.func_194113_b((ItemStack)stack);
        if (packed == 0 || STACK_BLACKLIST.contains(packed)) {
            return;
        }
        STACK_MAP.put(packed, radiation);
    }

    public static void addToFluidMap(String fluidName, double radiation) {
        Block fluidBlock;
        if (FLUID_BLACKLIST.contains((Object)fluidName)) {
            return;
        }
        FLUID_MAP.put((Object)fluidName, radiation);
        Fluid fluid = FluidRegistry.getFluid((String)fluidName);
        if (fluid != null && (fluidBlock = fluid.getBlock()) != null) {
            RadSources.addToStackMap(new ItemStack(fluidBlock), radiation);
        }
    }

    public static void addToFoodMaps(ItemStack stack, double radiation, double resistance) {
        int packed = RecipeItemHelper.func_194113_b((ItemStack)stack);
        if (packed == 0) {
            return;
        }
        FOOD_RAD_MAP.put(packed, radiation);
        FOOD_RESISTANCE_MAP.put(packed, resistance);
    }

    public static void addMaterialPrefixMultiplier(String prefix, double multiplier) {
        PREFIX_MULTIPLIER_MAP.put((Object)prefix, multiplier);
    }

    public static void init() {
        ItemStack stack;
        int scorePos;
        for (String ore : NCConfig.radiation_ores_blacklist) {
            RadSources.addToOreBlacklist(ore);
        }
        for (String item : NCConfig.radiation_items_blacklist) {
            RadSources.addToStackBlacklist(RegistryHelper.itemStackFromRegistry(item));
        }
        for (String block : NCConfig.radiation_blocks_blacklist) {
            RadSources.addToStackBlacklist(RegistryHelper.blockStackFromRegistry(block));
        }
        for (String fluid : NCConfig.radiation_fluids_blacklist) {
            RadSources.addToFluidBlacklist(fluid);
        }
        if (ModCheck.gregtechLoaded()) {
            for (String prefix : new String[]{"crushedPurified", "crushedCentrifuged", "toolHeadShovel"}) {
                RadSources.addMaterialPrefixMultiplier(prefix, 1.0);
            }
            for (String prefix : new String[]{"bolt", "screw", "oreNetherrack", "oreEndstone", "oreSand", "oreBlackgranite", "oreRedgranite", "oreMarble", "oreBasalt"}) {
                RadSources.addMaterialPrefixMultiplier(prefix, 0.25);
            }
            for (String prefix : new String[]{"toolHeadSword", "toolHeadHoe", "toolHeadFile", "toolHeadSaw", "toolHeadChainsaw"}) {
                RadSources.addMaterialPrefixMultiplier(prefix, 2.0);
            }
            for (String prefix : new String[]{"toolHeadPickaxe", "toolHeadAxe", "toolHeadSense"}) {
                RadSources.addMaterialPrefixMultiplier(prefix, 3.0);
            }
            for (String prefix : new String[]{"toolHeadDrill", "toolHeadWrench", "toolHeadPlow", "toolHeadBuzzSaw"}) {
                RadSources.addMaterialPrefixMultiplier(prefix, 4.0);
            }
            for (String prefix : new String[]{"turbineBlade"}) {
                RadSources.addMaterialPrefixMultiplier(prefix, 5.0);
            }
            for (String prefix : new String[]{"toolHeadHammer", "toolHeadUniversalSpade"}) {
                RadSources.addMaterialPrefixMultiplier(prefix, 6.0);
            }
        }
        RadSources.putMaterial(4.975E-20, "Bismuth");
        RadSources.putMaterial(6.25E-4, "Radium");
        RadSources.putMaterial(0.29333333333333333, "Polonium");
        RadSources.putMaterial(TBP, "TBP");
        RadSources.putMaterial(1.5044444444444443, "Protactinium233");
        RadSources.putMaterial(0.0345, "Strontium90");
        RadSources.putMaterial(0.98, "Ruthenium106");
        RadSources.putMaterial(0.033, "Cesium137");
        RadSources.putMaterial(0.033, "Caesium137");
        RadSources.putMaterial(0.38, "Promethium147");
        RadSources.putMaterial(0.21, "Europium155");
        RadSources.putMaterial(7.15E-11, "Thorium");
        RadSources.putMaterial(3.85E-10, "Uranium", "Yellorium");
        RadSources.putMaterial(4.2E-5, "Plutonium", "Blutonium");
        RadSources.putMaterial(2.25E-10, "Cyanite");
        RadSources.putIsotope(6.3E-6, "Uranium233", "uranium_233");
        RadSources.putIsotope(1.45E-9, "Uranium235", "uranium_235");
        RadSources.putIsotope(2.25E-10, "Uranium238", "uranium_238");
        RadSources.putIsotope(6.5E-6, "Neptunium236", "neptunium_236");
        RadSources.putIsotope(4.7E-7, "Neptunium237", "neptunium_237");
        RadSources.putIsotope(0.0115, "Plutonium238", "plutonium_238");
        RadSources.putIsotope(4.15E-5, "Plutonium239", "plutonium_239");
        RadSources.putIsotope(0.0715, "Plutonium241", "plutonium_241");
        RadSources.putIsotope(2.7E-6, "Plutonium242", "plutonium_242");
        RadSources.putIsotope(0.00235, "Americium241", "americium_241");
        RadSources.putIsotope(0.0071, "Americium242", "americium_242");
        RadSources.putIsotope(1.4E-4, "Americium243", "americium_243");
        RadSources.putIsotope(0.0345, "Curium243", "curium_243");
        RadSources.putIsotope(1.2E-4, "Curium245", "curium_245");
        RadSources.putIsotope(2.15E-4, "Curium246", "curium_246");
        RadSources.putIsotope(6.45E-8, "Curium247", "curium_247");
        RadSources.putIsotope(7.25E-4, "Berkelium247", "berkelium_247");
        RadSources.putIsotope(0.00325, "Berkelium248", "berkelium_248");
        RadSources.putIsotope(0.00285, "Californium249", "californium_249");
        RadSources.putIsotope(0.0765, "Californium250", "californium_250");
        RadSources.putIsotope(0.00115, "Californium251", "californium_251");
        RadSources.putIsotope(0.38, "Californium252", "californium_252");
        RadSources.putFuel(TBU, DEPLETED_TBU, "TBU", "tbu");
        RadSources.putFuel(LEU_233, DEPLETED_LEU_233, "LEU233", "leu_233");
        RadSources.putFuel(HEU_233, DEPLETED_HEU_233, "HEU233", "heu_233");
        RadSources.putFuel(LEU_235, DEPLETED_LEU_235, "LEU235", "leu_235");
        RadSources.putFuel(HEU_235, DEPLETED_HEU_235, "HEU235", "heu_235");
        RadSources.putFuel(LEN_236, DEPLETED_LEN_236, "LEN236", "len_236");
        RadSources.putFuel(HEN_236, DEPLETED_HEN_236, "HEN236", "hen_236");
        RadSources.putFuel(LEP_239, DEPLETED_LEP_239, "LEP239", "lep_239");
        RadSources.putFuel(HEP_239, DEPLETED_HEP_239, "HEP239", "hep_239");
        RadSources.putFuel(LEP_241, DEPLETED_LEP_241, "LEP241", "lep_241");
        RadSources.putFuel(HEP_241, DEPLETED_HEP_241, "HEP241", "hep_241");
        RadSources.putFuel(MIX_239, DEPLETED_MIX_239, "MIX239", "mix_239");
        RadSources.putFuel(MIX_241, DEPLETED_MIX_241, "MIX241", "mix_241");
        RadSources.putFuel(LEA_242, DEPLETED_LEA_242, "LEA242", "lea_242");
        RadSources.putFuel(HEA_242, DEPLETED_HEA_242, "HEA242", "hea_242");
        RadSources.putFuel(LECm_243, DEPLETED_LECm_243, "LECm243", "lecm_243");
        RadSources.putFuel(HECm_243, DEPLETED_HECm_243, "HECm243", "hecm_243");
        RadSources.putFuel(LECm_245, DEPLETED_LECm_245, "LECm245", "lecm_245");
        RadSources.putFuel(HECm_245, DEPLETED_HECm_245, "HECm245", "hecm_245");
        RadSources.putFuel(LECm_247, DEPLETED_LECm_247, "LECm247", "lecm_247");
        RadSources.putFuel(HECm_247, DEPLETED_HECm_247, "HECm247", "hecm_247");
        RadSources.putFuel(LEB_248, DEPLETED_LEB_248, "LEB248", "leb_248");
        RadSources.putFuel(HEB_248, DEPLETED_HEB_248, "HEB248", "heb_248");
        RadSources.putFuel(LECf_249, DEPLETED_LECf_249, "LECf249", "lecf_249");
        RadSources.putFuel(HECf_249, DEPLETED_HECf_249, "HECf249", "hecf_249");
        RadSources.putFuel(LECf_251, DEPLETED_LECf_251, "LECf251", "lecf_251");
        RadSources.putFuel(HECf_251, DEPLETED_HECf_251, "HECf251", "hecf_251");
        RadSources.putOre(9.0E-10, "plateDU");
        RadSources.put(3.6E-9, NCBlocks.solar_panel_du, NCBlocks.voltaic_pile_du, NCBlocks.lithium_ion_battery_du);
        RadSources.put(2.7E-9, new ItemStack(NCItems.rad_shielding, 1, 2));
        RadSources.put(5.625E-11, NCBlocks.rtg_uranium);
        RadSources.put(0.002875, NCBlocks.rtg_plutonium);
        RadSources.put(5.875E-4, NCBlocks.rtg_americium);
        RadSources.put(0.019125, NCBlocks.rtg_californium);
        RadSources.put(1.5625E-4, new ItemStack(NCBlocks.fission_source, 1, 0));
        RadSources.put(0.07333333333333333, new ItemStack(NCBlocks.fission_source, 1, 1));
        RadSources.put(0.095, new ItemStack(NCBlocks.fission_source, 1, 2));
        RadSources.put(4.4921875E-5, NCBlocks.tritium_lamp);
        RadSources.put(1.1458333333333334E-4, NCBlocks.solidified_corium);
        RadSources.putOre(0.00825, "dustIrradiatedBorax");
        if (ModCheck.gregtechLoaded()) {
            RadSources.putMaterial(1.2155E-9, "Monazite");
        }
        RadSources.putFluid(3.15E-7, "plasma");
        RadSources.putFluid(0.0115, "tritium");
        RadSources.putFluid(1.65E-5, "corium");
        RadSources.putFluid(7.15E-11, "thorium");
        RadSources.putFluid(3.85E-10, "uranium", "yellorium");
        RadSources.putFluid(4.2E-5, "plutonium", "blutonium");
        RadSources.putFluid(2.25E-10, "cyanite");
        RadSources.putFluid(4.975E-20, "bismuth");
        RadSources.putFluid(6.25E-4, "radium");
        RadSources.putFluid(0.29333333333333333, "polonium");
        RadSources.putFluid(1.5044444444444443, "protactinium_233");
        RadSources.putFluid(TBP, "tbp");
        RadSources.putFluid(0.0345, "strontium_90");
        RadSources.putFluid(0.98, "ruthenium_106");
        RadSources.putFluid(0.033, "cesium_137");
        RadSources.putFluid(0.033, "caesium_137");
        RadSources.putFluid(0.38, "promethium_147");
        RadSources.putFluid(0.21, "europium_155");
        RadSources.putFluid(0.00825, "irradiated_borax_solution");
        for (String oreInfo : NCConfig.radiation_ores) {
            scorePos = oreInfo.lastIndexOf(95);
            if (scorePos == -1) continue;
            RadSources.addToOreMap(oreInfo.substring(0, scorePos), Double.parseDouble(oreInfo.substring(scorePos + 1)));
        }
        for (String itemInfo : NCConfig.radiation_items) {
            scorePos = itemInfo.lastIndexOf(95);
            if (scorePos == -1 || (stack = RegistryHelper.itemStackFromRegistry(itemInfo.substring(0, scorePos))) == null) continue;
            RadSources.addToStackMap(stack, Double.parseDouble(itemInfo.substring(scorePos + 1)));
        }
        for (String blockInfo : NCConfig.radiation_blocks) {
            scorePos = blockInfo.lastIndexOf(95);
            if (scorePos == -1 || (stack = RegistryHelper.blockStackFromRegistry(blockInfo.substring(0, scorePos))) == null) continue;
            RadSources.addToStackMap(stack, Double.parseDouble(blockInfo.substring(scorePos + 1)));
        }
        for (String fluidInfo : NCConfig.radiation_fluids) {
            scorePos = fluidInfo.lastIndexOf(95);
            if (scorePos == -1) continue;
            RadSources.addToFluidMap(fluidInfo.substring(0, scorePos), Double.parseDouble(fluidInfo.substring(scorePos + 1)));
        }
        for (String itemInfo : NCConfig.radiation_foods) {
            scorePos = itemInfo.lastIndexOf(95);
            if (scorePos == -1) continue;
            double resistance = Double.parseDouble(itemInfo.substring(scorePos + 1));
            if ((scorePos = (itemInfo = itemInfo.substring(0, scorePos)).lastIndexOf(95)) == -1) continue;
            ItemStack stack2 = RegistryHelper.itemStackFromRegistry(itemInfo.substring(0, scorePos));
            double rads = Double.parseDouble(itemInfo.substring(scorePos + 1));
            if (stack2 == null || rads == 0.0 && resistance == 0.0 || !(stack2.func_77973_b() instanceof ItemFood)) continue;
            RadSources.addToFoodMaps(stack2, rads, resistance);
        }
        for (Runnable runnable : RUNNABLES) {
            runnable.run();
        }
    }

    public static void postInit() {
        ORE_MAP.entrySet().forEach(ent -> OreDictionary.getOres((String)((String)ent.getKey()), (boolean)false).forEach(s -> RadSources.addToStackMap(s, (Double)ent.getValue())));
    }

    public static void refreshRadSources(boolean postInit) {
        STACK_BLACKLIST.clear();
        STACK_MAP.clear();
        FOOD_RAD_MAP.clear();
        FOOD_RESISTANCE_MAP.clear();
        RadSources.init();
        if (postInit) {
            RadSources.postInit();
        }
    }

    public static void putMaterial(double radiation, String ... ores) {
        for (String ore : ores) {
            for (Object2DoubleMap.Entry entry : PREFIX_MULTIPLIER_MAP.object2DoubleEntrySet()) {
                RadSources.addToOreMap((String)entry.getKey() + ore, radiation * entry.getDoubleValue());
            }
        }
    }

    public static void putIsotope(double radiation, String ore, String fluid) {
        for (String suffix : new String[]{"", "Carbide", "Oxide", "Nitride", "ZA"}) {
            RadSources.putMaterial(radiation, ore + suffix);
        }
        if (fluid != null) {
            for (String suffix : new String[]{"", "_za", "_fluoride", "_fluoride_flibe"}) {
                RadSources.addToFluidMap(fluid + suffix, radiation * 6.944444444444445);
            }
        }
    }

    public static void putFuel(double fuelRadiation, double depletedRadiation, String ore, String fluid) {
        for (String suffix : new String[]{"", "TRISO", "Carbide", "Oxide", "Nitride", "ZA"}) {
            RadSources.addToOreMap("ingot" + ore + suffix, fuelRadiation);
            RadSources.addToOreMap("ingotDepleted" + ore + suffix, depletedRadiation);
        }
        if (fluid != null) {
            for (String suffix : new String[]{"", "_za", "_fluoride", "_fluoride_flibe"}) {
                RadSources.addToFluidMap(fluid + suffix, fuelRadiation * 6.944444444444445);
                RadSources.addToFluidMap("depleted_" + fluid + suffix, depletedRadiation * 6.944444444444445);
            }
        }
    }

    public static void putOre(double radiation, String ... ores) {
        for (String ore : ores) {
            RadSources.addToOreMap(ore, radiation);
        }
    }

    public static void put(double radiation, ItemStack ... stacks) {
        for (ItemStack stack : stacks) {
            RadSources.addToStackMap(stack, radiation);
        }
    }

    public static void put(double radiation, Item ... items) {
        for (Item item : items) {
            RadSources.addToStackMap(new ItemStack(item), radiation);
        }
    }

    public static void put(double radiation, Block ... blocks) {
        for (Block block : blocks) {
            RadSources.addToStackMap(new ItemStack(block), radiation);
        }
    }

    public static void putFluid(double radiation, String ... fluids) {
        for (String fluid : fluids) {
            RadSources.addToFluidMap(fluid, radiation * 6.944444444444445);
        }
    }

    public static double getFuelRadiation(double rad1, double amount1, double rad2, double amount2) {
        return (rad1 * amount1 + rad2 * amount2) / 9.0;
    }

    @Deprecated
    public static double getDepletedFuelRadiation(double rad1, int amount1, double rad2, int amount2, double rad3, int amount3, double rad4, int amount4) {
        return (rad1 * (double)amount1 + rad2 * (double)amount2 + rad3 * (double)amount3 + rad4 * (double)amount4) / 9.0;
    }

    public static double getDepletedFuelRadiation(double rad1, int amount1, double rad2, int amount2, double rad3, int amount3, double rad4, int amount4, double waste1, double waste2, double m, double r) {
        return (rad1 * (double)amount1 + rad2 * (double)amount2 + rad3 * (double)amount3 + rad4 * (double)amount4 + waste1 * m * r + waste2 * m * (1.0 - r)) / 9.0;
    }

    static {
        for (String prefix : new String[]{"ingot", "dust", "dustDirty", "clump", "shard", "crystal", "crushed", "dustImpure", "dustPure", "plate", "blockSheetmetal"}) {
            RadSources.addMaterialPrefixMultiplier(prefix, 1.0);
        }
        for (String prefix : new String[]{"tinyDust", "dustTiny", "nugget"}) {
            RadSources.addMaterialPrefixMultiplier(prefix, 0.1111111111111111);
        }
        for (String prefix : new String[]{"rod", "stick", "slabSheetmetal"}) {
            RadSources.addMaterialPrefixMultiplier(prefix, 0.5);
        }
        for (String prefix : new String[]{"coin"}) {
            RadSources.addMaterialPrefixMultiplier(prefix, 0.3333333333333333);
        }
        for (String prefix : new String[]{"smallDust", "dustSmall", "ore", "oreGravel"}) {
            RadSources.addMaterialPrefixMultiplier(prefix, 0.25);
        }
        for (String prefix : new String[]{"gear"}) {
            RadSources.addMaterialPrefixMultiplier(prefix, 4.0);
        }
        for (String prefix : new String[]{"block", "plateDense"}) {
            RadSources.addMaterialPrefixMultiplier(prefix, 9.0);
        }
        for (String prefix : new String[]{"slab"}) {
            RadSources.addMaterialPrefixMultiplier(prefix, 4.5);
        }
        TBP = RadSources.getFuelRadiation(7.15E-11, 8.5, 1.5044444444444443, 0.5);
        TBU = RadSources.getFuelRadiation(7.15E-11, 8.5, 6.3E-6, 0.5);
        LEU_233 = RadSources.getFuelRadiation(2.25E-10, 8.0, 6.3E-6, 1.0);
        HEU_233 = RadSources.getFuelRadiation(2.25E-10, 6.0, 6.3E-6, 3.0);
        LEU_235 = RadSources.getFuelRadiation(2.25E-10, 8.0, 1.45E-9, 1.0);
        HEU_235 = RadSources.getFuelRadiation(2.25E-10, 6.0, 1.45E-9, 3.0);
        LEN_236 = RadSources.getFuelRadiation(4.7E-7, 8.0, 6.5E-6, 1.0);
        HEN_236 = RadSources.getFuelRadiation(4.7E-7, 6.0, 6.5E-6, 3.0);
        LEP_239 = RadSources.getFuelRadiation(2.7E-6, 8.0, 4.15E-5, 1.0);
        HEP_239 = RadSources.getFuelRadiation(2.7E-6, 6.0, 4.15E-5, 3.0);
        LEP_241 = RadSources.getFuelRadiation(2.7E-6, 8.0, 0.0715, 1.0);
        HEP_241 = RadSources.getFuelRadiation(2.7E-6, 6.0, 0.0715, 3.0);
        MIX_239 = RadSources.getFuelRadiation(2.25E-10, 8.0, 4.15E-5, 1.0);
        MIX_241 = RadSources.getFuelRadiation(2.25E-10, 8.0, 0.0715, 1.0);
        LEA_242 = RadSources.getFuelRadiation(1.4E-4, 8.0, 0.0071, 1.0);
        HEA_242 = RadSources.getFuelRadiation(1.4E-4, 6.0, 0.0071, 3.0);
        LECm_243 = RadSources.getFuelRadiation(2.15E-4, 8.0, 0.0345, 1.0);
        HECm_243 = RadSources.getFuelRadiation(2.15E-4, 6.0, 0.0345, 3.0);
        LECm_245 = RadSources.getFuelRadiation(2.15E-4, 8.0, 1.2E-4, 1.0);
        HECm_245 = RadSources.getFuelRadiation(2.15E-4, 6.0, 1.2E-4, 3.0);
        LECm_247 = RadSources.getFuelRadiation(2.15E-4, 8.0, 6.45E-8, 1.0);
        HECm_247 = RadSources.getFuelRadiation(2.15E-4, 6.0, 6.45E-8, 3.0);
        LEB_248 = RadSources.getFuelRadiation(7.25E-4, 8.0, 0.00325, 1.0);
        HEB_248 = RadSources.getFuelRadiation(7.25E-4, 6.0, 0.00325, 3.0);
        LECf_249 = RadSources.getFuelRadiation(0.38, 8.0, 0.00285, 1.0);
        HECf_249 = RadSources.getFuelRadiation(0.38, 6.0, 0.00285, 3.0);
        LECf_251 = RadSources.getFuelRadiation(0.38, 8.0, 0.00115, 1.0);
        HECf_251 = RadSources.getFuelRadiation(0.38, 6.0, 0.00115, 3.0);
        DEPLETED_TBU = RadSources.getDepletedFuelRadiation(6.3E-6, 1, 2.25E-10, 5, 6.5E-6, 1, 4.7E-7, 1, 0.0345, 0.033, 0.5, 0.5);
        DEPLETED_LEU_233 = RadSources.getDepletedFuelRadiation(2.25E-10, 5, 0.0715, 1, 2.7E-6, 1, 1.4E-4, 1, 0.0345, 0.033, 0.5, 0.5);
        DEPLETED_HEU_233 = RadSources.getDepletedFuelRadiation(1.45E-9, 1, 2.25E-10, 2, 2.7E-6, 3, 1.4E-4, 1, 0.0345, 0.033, 1.5, 0.5);
        DEPLETED_LEU_235 = RadSources.getDepletedFuelRadiation(2.25E-10, 4, 4.15E-5, 1, 2.7E-6, 2, 1.4E-4, 1, 0.0, 0.033, 0.5, 0.5);
        DEPLETED_HEU_235 = RadSources.getDepletedFuelRadiation(2.25E-10, 3, 6.5E-6, 1, 2.7E-6, 2, 1.4E-4, 1, 0.0, 0.033, 1.5, 0.5);
        DEPLETED_LEN_236 = RadSources.getDepletedFuelRadiation(2.25E-10, 4, 4.7E-7, 1, 0.0715, 1, 2.7E-6, 2, 0.0, 0.033, 0.5, 0.5);
        DEPLETED_HEN_236 = RadSources.getDepletedFuelRadiation(2.25E-10, 4, 0.0115, 1, 0.0715, 1, 2.7E-6, 1, 0.0, 0.033, 1.5, 0.5);
        DEPLETED_LEP_239 = RadSources.getDepletedFuelRadiation(2.7E-6, 5, 0.0071, 1, 1.4E-4, 1, 2.15E-4, 1, 0.0345, 0.38, 0.5, 0.5);
        DEPLETED_HEP_239 = RadSources.getDepletedFuelRadiation(0.0715, 1, 0.0071, 1, 1.4E-4, 4, 0.0345, 1, 0.0345, 0.38, 1.5, 0.5);
        DEPLETED_LEP_241 = RadSources.getDepletedFuelRadiation(2.7E-6, 5, 1.4E-4, 1, 2.15E-4, 1, 7.25E-4, 1, 0.0345, 0.38, 0.5, 0.5);
        DEPLETED_HEP_241 = RadSources.getDepletedFuelRadiation(0.0715, 1, 0.0071, 1, 1.4E-4, 3, 2.15E-4, 2, 0.0345, 0.38, 1.5, 0.5);
        DEPLETED_MIX_239 = RadSources.getDepletedFuelRadiation(2.25E-10, 4, 0.0715, 1, 2.7E-6, 2, 1.4E-4, 1, 0.0345, 0.38, 0.5, 0.5);
        DEPLETED_MIX_241 = RadSources.getDepletedFuelRadiation(2.25E-10, 3, 0.0715, 1, 2.7E-6, 3, 1.4E-4, 1, 0.0345, 0.38, 0.5, 0.5);
        DEPLETED_LEA_242 = RadSources.getDepletedFuelRadiation(1.4E-4, 3, 1.2E-4, 1, 2.15E-4, 3, 0.00325, 1, 0.0, 0.38, 0.5, 0.5);
        DEPLETED_HEA_242 = RadSources.getDepletedFuelRadiation(1.4E-4, 3, 0.0345, 1, 2.15E-4, 2, 7.25E-4, 1, 0.0, 0.38, 1.5, 0.5);
        DEPLETED_LECm_243 = RadSources.getDepletedFuelRadiation(2.15E-4, 4, 6.45E-8, 1, 7.25E-4, 2, 0.00325, 1, 0.0, 0.38, 0.5, 0.5);
        DEPLETED_HECm_243 = RadSources.getDepletedFuelRadiation(1.2E-4, 1, 2.15E-4, 3, 7.25E-4, 2, 0.00325, 1, 0.0, 0.38, 1.5, 0.5);
        DEPLETED_LECm_245 = RadSources.getDepletedFuelRadiation(2.15E-4, 4, 6.45E-8, 1, 7.25E-4, 2, 0.00285, 1, 0.0, 0.21, 0.5, 0.6);
        DEPLETED_HECm_245 = RadSources.getDepletedFuelRadiation(2.15E-4, 3, 6.45E-8, 1, 7.25E-4, 2, 0.00285, 1, 0.0, 0.21, 1.5, 0.6);
        DEPLETED_LECm_247 = RadSources.getDepletedFuelRadiation(2.15E-4, 5, 7.25E-4, 1, 0.00325, 1, 0.00285, 1, 0.0, 0.21, 0.5, 0.6);
        DEPLETED_HECm_247 = RadSources.getDepletedFuelRadiation(7.25E-4, 4, 0.00325, 1, 0.00285, 1, 0.00115, 1, 0.0, 0.21, 1.5, 0.6);
        DEPLETED_LEB_248 = RadSources.getDepletedFuelRadiation(7.25E-4, 5, 0.00325, 1, 0.00285, 1, 0.00115, 1, 0.98, 0.38, 0.5, 0.6);
        DEPLETED_HEB_248 = RadSources.getDepletedFuelRadiation(0.00325, 1, 0.00285, 1, 0.00115, 2, 0.38, 3, 0.98, 0.38, 1.5, 0.6);
        DEPLETED_LECf_249 = RadSources.getDepletedFuelRadiation(0.38, 2, 0.38, 2, 0.38, 2, 0.38, 2, 0.98, 0.38, 0.5, 0.6);
        DEPLETED_HECf_249 = RadSources.getDepletedFuelRadiation(0.0765, 1, 0.38, 2, 0.38, 2, 0.38, 2, 0.98, 0.38, 1.5, 0.6);
        DEPLETED_LECf_251 = RadSources.getDepletedFuelRadiation(0.38, 2, 0.38, 2, 0.38, 2, 0.38, 2, 0.98, 0.21, 0.5, 0.6);
        DEPLETED_HECf_251 = RadSources.getDepletedFuelRadiation(0.38, 2, 0.38, 2, 0.38, 2, 0.38, 1, 0.98, 0.21, 1.5, 0.6);
        TBU_FISSION = (TBU + DEPLETED_TBU + 0.033) / 64.0;
        LEU_233_FISSION = (LEU_233 + DEPLETED_LEU_233) / 64.0;
        HEU_233_FISSION = (HEU_233 + DEPLETED_HEU_233) / 64.0;
        LEU_235_FISSION = (LEU_235 + DEPLETED_LEU_235) / 64.0;
        HEU_235_FISSION = (HEU_235 + DEPLETED_HEU_235) / 64.0;
        LEN_236_FISSION = (LEN_236 + DEPLETED_LEN_236) / 64.0;
        HEN_236_FISSION = (HEN_236 + DEPLETED_HEN_236) / 64.0;
        LEP_239_FISSION = (LEP_239 + DEPLETED_LEP_239) / 64.0;
        HEP_239_FISSION = (HEP_239 + DEPLETED_HEP_239) / 64.0;
        LEP_241_FISSION = (LEP_241 + DEPLETED_LEP_241) / 64.0;
        HEP_241_FISSION = (HEP_241 + DEPLETED_HEP_241) / 64.0;
        MIX_239_FISSION = (MIX_239 + DEPLETED_MIX_239) / 64.0;
        MIX_241_FISSION = (MIX_241 + DEPLETED_MIX_241) / 64.0;
        LEA_242_FISSION = (LEA_242 + DEPLETED_LEA_242) / 64.0;
        HEA_242_FISSION = (HEA_242 + DEPLETED_HEA_242) / 64.0;
        LECm_243_FISSION = (LECm_243 + DEPLETED_LECm_243) / 64.0;
        HECm_243_FISSION = (HECm_243 + DEPLETED_HECm_243) / 64.0;
        LECm_245_FISSION = (LECm_245 + DEPLETED_LECm_245) / 64.0;
        HECm_245_FISSION = (HECm_245 + DEPLETED_HECm_245) / 64.0;
        LECm_247_FISSION = (LECm_247 + DEPLETED_LECm_247) / 64.0;
        HECm_247_FISSION = (HECm_247 + DEPLETED_HECm_247) / 64.0;
        LEB_248_FISSION = (LEB_248 + DEPLETED_LEB_248) / 64.0;
        HEB_248_FISSION = (HEB_248 + DEPLETED_HEB_248) / 64.0;
        LECf_249_FISSION = (LECf_249 + DEPLETED_LECf_249) / 64.0;
        HECf_249_FISSION = (HECf_249 + DEPLETED_HECf_249) / 64.0;
        LECf_251_FISSION = (LECf_251 + DEPLETED_LECf_251) / 64.0;
        HECf_251_FISSION = (HECf_251 + DEPLETED_HECf_251) / 64.0;
    }
}

