/*
 * Decompiled with CFR 0.152.
 */
package nc.network.render;

import io.netty.buffer.ByteBuf;
import nc.NuclearCraft;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class BlockHighlightUpdatePacket
implements IMessage {
    protected long posLong;
    protected long highlightTimeMillis;

    public BlockHighlightUpdatePacket() {
    }

    public BlockHighlightUpdatePacket(BlockPos pos, long highlightTimeMillis) {
        this.posLong = pos.func_177986_g();
        this.highlightTimeMillis = highlightTimeMillis;
    }

    public void fromBytes(ByteBuf buf) {
        this.posLong = buf.readLong();
        this.highlightTimeMillis = buf.readLong();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.posLong);
        buf.writeLong(this.highlightTimeMillis);
    }

    public static class Handler
    implements IMessageHandler<BlockHighlightUpdatePacket, IMessage> {
        public IMessage onMessage(BlockHighlightUpdatePacket message, MessageContext ctx) {
            if (ctx.side == Side.CLIENT) {
                Minecraft.func_71410_x().func_152344_a(() -> this.processMessage(message));
            }
            return null;
        }

        protected void processMessage(BlockHighlightUpdatePacket message) {
            NuclearCraft.instance.blockOverlayTracker.highlightBlock(message.posLong, message.highlightTimeMillis);
        }
    }
}

