/*
 * Decompiled with CFR 0.152.
 */
package nc.network.radiation;

import io.netty.buffer.ByteBuf;
import nc.capability.radiation.entity.IEntityRads;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PlayerRadsUpdatePacket
implements IMessage {
    protected double totalRads;
    protected double radiationLevel;
    protected double internalRadiationResistance;
    protected double externalRadiationResistance;
    protected boolean radXUsed;
    protected boolean radXWoreOff;
    protected double radawayBuffer;
    protected double radawayBufferSlow;
    protected double poisonBuffer;
    protected boolean consumed;
    protected double radawayCooldown;
    protected double recentRadawayAddition;
    protected double radXCooldown;
    protected double recentRadXAddition;
    protected int messageCooldownTime;
    protected double recentPoisonAddition;
    protected double radiationImmunityTime;
    protected boolean radiationImmunityStage;
    protected boolean shouldWarn;
    protected boolean giveGuidebook;

    public PlayerRadsUpdatePacket() {
    }

    public PlayerRadsUpdatePacket(IEntityRads playerRads) {
        this.totalRads = playerRads.getTotalRads();
        this.radiationLevel = playerRads.getRadiationLevel();
        this.internalRadiationResistance = playerRads.getInternalRadiationResistance();
        this.externalRadiationResistance = playerRads.getExternalRadiationResistance();
        this.radXUsed = playerRads.getRadXUsed();
        this.radXWoreOff = playerRads.getRadXWoreOff();
        this.radawayBuffer = playerRads.getRadawayBuffer(false);
        this.radawayBufferSlow = playerRads.getRadawayBuffer(true);
        this.poisonBuffer = playerRads.getPoisonBuffer();
        this.consumed = playerRads.getConsumedMedicine();
        this.radawayCooldown = playerRads.getRadawayCooldown();
        this.recentRadawayAddition = playerRads.getRecentRadawayAddition();
        this.radXCooldown = playerRads.getRadXCooldown();
        this.recentRadXAddition = playerRads.getRecentRadXAddition();
        this.messageCooldownTime = playerRads.getMessageCooldownTime();
        this.recentPoisonAddition = playerRads.getRecentPoisonAddition();
        this.radiationImmunityTime = playerRads.getRadiationImmunityTime();
        this.radiationImmunityStage = playerRads.getRadiationImmunityStage();
        this.shouldWarn = playerRads.getShouldWarn();
        this.giveGuidebook = playerRads.getGiveGuidebook();
    }

    public void fromBytes(ByteBuf buf) {
        this.totalRads = buf.readDouble();
        this.radiationLevel = buf.readDouble();
        this.internalRadiationResistance = buf.readDouble();
        this.externalRadiationResistance = buf.readDouble();
        this.radXUsed = buf.readBoolean();
        this.radXWoreOff = buf.readBoolean();
        this.radawayBuffer = buf.readDouble();
        this.radawayBufferSlow = buf.readDouble();
        this.poisonBuffer = buf.readDouble();
        this.consumed = buf.readBoolean();
        this.radawayCooldown = buf.readDouble();
        this.recentRadawayAddition = buf.readDouble();
        this.radXCooldown = buf.readDouble();
        this.recentRadXAddition = buf.readDouble();
        this.messageCooldownTime = buf.readInt();
        this.recentPoisonAddition = buf.readDouble();
        this.radiationImmunityTime = buf.readDouble();
        this.radiationImmunityStage = buf.readBoolean();
        this.shouldWarn = buf.readBoolean();
        this.giveGuidebook = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.totalRads);
        buf.writeDouble(this.radiationLevel);
        buf.writeDouble(this.internalRadiationResistance);
        buf.writeDouble(this.externalRadiationResistance);
        buf.writeBoolean(this.radXUsed);
        buf.writeBoolean(this.radXWoreOff);
        buf.writeDouble(this.radawayBuffer);
        buf.writeDouble(this.radawayBufferSlow);
        buf.writeDouble(this.poisonBuffer);
        buf.writeBoolean(this.consumed);
        buf.writeDouble(this.radawayCooldown);
        buf.writeDouble(this.recentRadawayAddition);
        buf.writeDouble(this.radXCooldown);
        buf.writeDouble(this.recentRadXAddition);
        buf.writeInt(this.messageCooldownTime);
        buf.writeDouble(this.recentPoisonAddition);
        buf.writeDouble(this.radiationImmunityTime);
        buf.writeBoolean(this.radiationImmunityStage);
        buf.writeBoolean(this.shouldWarn);
        buf.writeBoolean(this.giveGuidebook);
    }

    public static class Handler
    implements IMessageHandler<PlayerRadsUpdatePacket, IMessage> {
        public IMessage onMessage(PlayerRadsUpdatePacket message, MessageContext ctx) {
            if (ctx.side == Side.CLIENT) {
                Minecraft.func_71410_x().func_152344_a(() -> this.processMessage(message));
            }
            return null;
        }

        void processMessage(PlayerRadsUpdatePacket message) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (player == null || !player.hasCapability(IEntityRads.CAPABILITY_ENTITY_RADS, null)) {
                return;
            }
            IEntityRads playerRads = (IEntityRads)player.getCapability(IEntityRads.CAPABILITY_ENTITY_RADS, null);
            if (playerRads == null) {
                return;
            }
            playerRads.setTotalRads(message.totalRads, false);
            playerRads.setRadiationLevel(message.radiationLevel);
            playerRads.setInternalRadiationResistance(message.internalRadiationResistance);
            playerRads.setExternalRadiationResistance(message.externalRadiationResistance);
            playerRads.setRadXUsed(message.radXUsed);
            playerRads.setRadXWoreOff(message.radXWoreOff);
            playerRads.setRadawayBuffer(false, message.radawayBuffer);
            playerRads.setRadawayBuffer(true, message.radawayBufferSlow);
            playerRads.setPoisonBuffer(message.poisonBuffer);
            playerRads.setConsumedMedicine(message.consumed);
            playerRads.setRadawayCooldown(message.radawayCooldown);
            playerRads.setRecentRadawayAddition(message.recentRadawayAddition);
            playerRads.setRadXCooldown(message.radXCooldown);
            playerRads.setRecentRadXAddition(message.recentRadXAddition);
            playerRads.setMessageCooldownTime(message.messageCooldownTime);
            playerRads.setRecentPoisonAddition(message.recentPoisonAddition);
            playerRads.setRadiationImmunityTime(message.radiationImmunityTime);
            playerRads.setRadiationImmunityStage(message.radiationImmunityStage);
            playerRads.setShouldWarn(message.shouldWarn);
            playerRads.setGiveGuidebook(message.giveGuidebook);
        }
    }
}

