/*
 * Decompiled with CFR 0.152.
 */
package nc.network.multiblock;

import io.netty.buffer.ByteBuf;
import nc.multiblock.turbine.Turbine;
import nc.multiblock.turbine.tile.ITurbinePart;
import nc.multiblock.turbine.tile.TileTurbineController;
import nc.network.multiblock.MultiblockUpdatePacket;
import nc.tile.internal.energy.EnergyStorage;
import net.minecraft.util.math.BlockPos;

public class TurbineUpdatePacket
extends MultiblockUpdatePacket {
    public boolean isTurbineOn;
    public double power;
    public double rawPower;
    public double conductivity;
    public double rotorEfficiency;
    public double powerBonus;
    public double totalExpansionLevel;
    public double idealTotalExpansionLevel;
    public double bearingTension;
    public int energy;
    public int capacity;
    public int shaftWidth;
    public int bladeLength;
    public int noBladeSets;
    public int dynamoCoilCount;
    public int dynamoCoilCountOpposite;

    public TurbineUpdatePacket() {
    }

    public TurbineUpdatePacket(BlockPos pos, boolean isTurbineOn, EnergyStorage energyStorage, double power, double rawPower, double conductivity, double rotorEfficiency, double powerBonus, double totalExpansionLevel, double idealTotalExpansionLevel, int shaftWidth, int bladeLength, int noBladeSets, int dynamoCoilCount, int dynamoCoilCountOpposite, double bearingTension) {
        this.pos = pos;
        this.isTurbineOn = isTurbineOn;
        this.energy = energyStorage.getEnergyStored();
        this.capacity = energyStorage.getMaxEnergyStored();
        this.power = power;
        this.rawPower = rawPower;
        this.conductivity = conductivity;
        this.rotorEfficiency = rotorEfficiency;
        this.powerBonus = powerBonus;
        this.totalExpansionLevel = totalExpansionLevel;
        this.idealTotalExpansionLevel = idealTotalExpansionLevel;
        this.shaftWidth = shaftWidth;
        this.bladeLength = bladeLength;
        this.noBladeSets = noBladeSets;
        this.dynamoCoilCount = dynamoCoilCount;
        this.dynamoCoilCountOpposite = dynamoCoilCountOpposite;
        this.bearingTension = bearingTension;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.isTurbineOn = buf.readBoolean();
        this.energy = buf.readInt();
        this.capacity = buf.readInt();
        this.power = buf.readDouble();
        this.rawPower = buf.readDouble();
        this.conductivity = buf.readDouble();
        this.rotorEfficiency = buf.readDouble();
        this.powerBonus = buf.readDouble();
        this.totalExpansionLevel = buf.readDouble();
        this.idealTotalExpansionLevel = buf.readDouble();
        this.shaftWidth = buf.readInt();
        this.bladeLength = buf.readInt();
        this.noBladeSets = buf.readInt();
        this.dynamoCoilCount = buf.readInt();
        this.dynamoCoilCountOpposite = buf.readInt();
        this.bearingTension = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeBoolean(this.isTurbineOn);
        buf.writeInt(this.energy);
        buf.writeInt(this.capacity);
        buf.writeDouble(this.power);
        buf.writeDouble(this.rawPower);
        buf.writeDouble(this.conductivity);
        buf.writeDouble(this.rotorEfficiency);
        buf.writeDouble(this.powerBonus);
        buf.writeDouble(this.totalExpansionLevel);
        buf.writeDouble(this.idealTotalExpansionLevel);
        buf.writeInt(this.shaftWidth);
        buf.writeInt(this.bladeLength);
        buf.writeInt(this.noBladeSets);
        buf.writeInt(this.dynamoCoilCount);
        buf.writeInt(this.dynamoCoilCountOpposite);
        buf.writeDouble(this.bearingTension);
    }

    public static class Handler
    extends MultiblockUpdatePacket.Handler<Turbine, ITurbinePart, TurbineUpdatePacket, TileTurbineController, TurbineUpdatePacket> {
        public Handler() {
            super(TileTurbineController.class);
        }

        @Override
        protected void onPacket(TurbineUpdatePacket message, Turbine multiblock) {
            multiblock.onMultiblockUpdatePacket(message);
        }
    }
}

