/*
 * Decompiled with CFR 0.152.
 */
package nc.network.multiblock;

import io.netty.buffer.ByteBuf;
import nc.multiblock.fission.FissionCluster;
import nc.network.tile.TileUpdatePacket;
import nc.tile.ITileGui;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class SolidFissionCellUpdatePacket
extends TileUpdatePacket {
    public BlockPos masterPortPos;
    public ItemStack filterStack;
    public long clusterHeatStored;
    public long clusterHeatCapacity;
    public boolean isProcessing;
    public double time;
    public double baseProcessTime;

    public SolidFissionCellUpdatePacket() {
    }

    public SolidFissionCellUpdatePacket(BlockPos pos, BlockPos masterPortPos, NonNullList<ItemStack> filterStacks, FissionCluster cluster, boolean isProcessing, double time, double baseProcessTime) {
        this.pos = pos;
        this.masterPortPos = masterPortPos;
        this.filterStack = (ItemStack)filterStacks.get(0);
        this.clusterHeatStored = cluster == null ? -1L : cluster.heatBuffer.getHeatStored();
        this.clusterHeatCapacity = cluster == null ? -1L : cluster.heatBuffer.getHeatCapacity();
        this.isProcessing = isProcessing;
        this.time = time;
        this.baseProcessTime = baseProcessTime;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.masterPortPos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.filterStack = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.clusterHeatStored = buf.readLong();
        this.clusterHeatCapacity = buf.readLong();
        this.isProcessing = buf.readBoolean();
        this.time = buf.readDouble();
        this.baseProcessTime = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeInt(this.masterPortPos.func_177958_n());
        buf.writeInt(this.masterPortPos.func_177956_o());
        buf.writeInt(this.masterPortPos.func_177952_p());
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.filterStack);
        buf.writeLong(this.clusterHeatStored);
        buf.writeLong(this.clusterHeatCapacity);
        buf.writeBoolean(this.isProcessing);
        buf.writeDouble(this.time);
        buf.writeDouble(this.baseProcessTime);
    }

    public static class Handler
    extends TileUpdatePacket.Handler<SolidFissionCellUpdatePacket, ITileGui<SolidFissionCellUpdatePacket>> {
        @Override
        protected void onTileUpdatePacket(SolidFissionCellUpdatePacket message, ITileGui<SolidFissionCellUpdatePacket> processor) {
            processor.onTileUpdatePacket(message);
        }
    }
}

