/*
 * Decompiled with CFR 0.152.
 */
package nc.network.multiblock;

import io.netty.buffer.ByteBuf;
import nc.network.multiblock.MultiblockUpdatePacket;
import nc.tile.internal.heat.HeatBuffer;
import net.minecraft.util.math.BlockPos;

public abstract class FissionUpdatePacket
extends MultiblockUpdatePacket {
    public boolean isReactorOn;
    public long cooling;
    public long rawHeating;
    public long totalHeatMult;
    public long usefulPartCount;
    public long heatStored;
    public long heatCapacity;
    public int clusterCount;
    public int fuelComponentCount;
    public double meanHeatMult;
    public double totalEfficiency;
    public double meanEfficiency;
    public double sparsityEfficiencyMult;

    public FissionUpdatePacket() {
    }

    public FissionUpdatePacket(BlockPos pos, boolean isReactorOn, HeatBuffer heatBuffer, int clusterCount, long cooling, long rawHeating, long totalHeatMult, double meanHeatMult, int fuelComponentCount, long usefulPartCount, double totalEfficiency, double meanEfficiency, double sparsityEfficiencyMult) {
        this.pos = pos;
        this.isReactorOn = isReactorOn;
        this.heatStored = heatBuffer.getHeatStored();
        this.heatCapacity = heatBuffer.getHeatCapacity();
        this.clusterCount = clusterCount;
        this.cooling = cooling;
        this.rawHeating = rawHeating;
        this.totalHeatMult = totalHeatMult;
        this.meanHeatMult = meanHeatMult;
        this.fuelComponentCount = fuelComponentCount;
        this.usefulPartCount = usefulPartCount;
        this.totalEfficiency = totalEfficiency;
        this.meanEfficiency = meanEfficiency;
        this.sparsityEfficiencyMult = sparsityEfficiencyMult;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.isReactorOn = buf.readBoolean();
        this.heatStored = buf.readLong();
        this.heatCapacity = buf.readLong();
        this.clusterCount = buf.readInt();
        this.cooling = buf.readLong();
        this.rawHeating = buf.readLong();
        this.totalHeatMult = buf.readLong();
        this.meanHeatMult = buf.readDouble();
        this.fuelComponentCount = buf.readInt();
        this.usefulPartCount = buf.readLong();
        this.totalEfficiency = buf.readDouble();
        this.meanEfficiency = buf.readDouble();
        this.sparsityEfficiencyMult = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeBoolean(this.isReactorOn);
        buf.writeLong(this.heatStored);
        buf.writeLong(this.heatCapacity);
        buf.writeInt(this.clusterCount);
        buf.writeLong(this.cooling);
        buf.writeLong(this.rawHeating);
        buf.writeLong(this.totalHeatMult);
        buf.writeDouble(this.meanHeatMult);
        buf.writeInt(this.fuelComponentCount);
        buf.writeLong(this.usefulPartCount);
        buf.writeDouble(this.totalEfficiency);
        buf.writeDouble(this.meanEfficiency);
        buf.writeDouble(this.sparsityEfficiencyMult);
    }
}

