/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.rtg.tile;

import gregtech.api.capability.GregtechCapabilities;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergySource;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nc.ModCheck;
import nc.config.NCConfig;
import nc.multiblock.rtg.RTGMultiblock;
import nc.multiblock.rtg.RTGType;
import nc.multiblock.tile.TileMultiblockPart;
import nc.tile.energy.ITileEnergy;
import nc.tile.internal.energy.EnergyConnection;
import nc.tile.internal.energy.EnergyStorage;
import nc.tile.internal.energy.EnergyTileWrapper;
import nc.tile.internal.energy.EnergyTileWrapperGT;
import nc.util.EnergyHelper;
import nc.util.NCMath;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="ic2.api.energy.tile.IEnergySource", modid="ic2")
public class TileRTG
extends TileMultiblockPart<RTGMultiblock, TileRTG>
implements ITickable,
ITileEnergy,
IEnergySource {
    private final EnergyStorage backupStorage = new EnergyStorage(1L);
    @Nonnull
    private final EnergyConnection[] energyConnections;
    private boolean[] ignoreSide = new boolean[]{false, false, false, false, false, false};
    @Nonnull
    private final EnergyTileWrapper[] energySides;
    @Nonnull
    private final EnergyTileWrapperGT[] energySidesGT;
    private boolean ic2reg = false;
    public long power;

    public TileRTG() {
        super(RTGMultiblock.class, TileRTG.class);
        this.energyConnections = ITileEnergy.energyConnectionAll(EnergyConnection.OUT);
        this.energySides = ITileEnergy.getDefaultEnergySides(this);
        this.energySidesGT = ITileEnergy.getDefaultEnergySidesGT(this);
    }

    public TileRTG(long power, double radiation) {
        this();
        this.power = power;
        this.getRadiationSource().setRadiationLevel(radiation);
    }

    protected TileRTG(RTGType type) {
        this(type.getPower(), type.getRadiation());
    }

    private boolean ignoreSide(EnumFacing side) {
        return side == null ? false : this.ignoreSide[side.func_176745_a()];
    }

    @Override
    public void onMachineAssembled(RTGMultiblock controller) {
        this.doStandardNullControllerResponse(controller);
    }

    @Override
    public void onMachineBroken() {
    }

    @Override
    public RTGMultiblock createNewMultiblock() {
        return new RTGMultiblock(this.field_145850_b);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (ModCheck.ic2Loaded()) {
            this.addTileToENet();
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.pushEnergy();
        }
    }

    @Override
    public void pushEnergyToSide(@Nonnull EnumFacing side) {
        if (!this.ignoreSide(side)) {
            ITileEnergy.super.pushEnergyToSide(side);
        }
    }

    public void onMultiblockRefresh() {
        for (EnumFacing side : EnumFacing.field_82609_l) {
            this.ignoreSide[side.func_176745_a()] = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side)) instanceof TileRTG;
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (ModCheck.ic2Loaded()) {
            this.removeTileFromENet();
        }
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        if (ModCheck.ic2Loaded()) {
            this.removeTileFromENet();
        }
    }

    @Override
    public EnergyStorage getEnergyStorage() {
        return this.getMultiblock() != null ? ((RTGMultiblock)this.getMultiblock()).getEnergyStorage() : this.backupStorage;
    }

    @Override
    public EnergyConnection[] getEnergyConnections() {
        return this.energyConnections;
    }

    @Override
    @Nonnull
    public EnergyTileWrapper[] getEnergySides() {
        return this.energySides;
    }

    @Override
    @Nonnull
    public EnergyTileWrapperGT[] getEnergySidesGT() {
        return this.energySidesGT;
    }

    @Override
    public boolean getIC2Reg() {
        return this.ic2reg;
    }

    @Override
    public void setIC2Reg(boolean ic2reg) {
        this.ic2reg = ic2reg;
    }

    @Override
    public int getSinkTier() {
        return 10;
    }

    @Override
    public int getSourceTier() {
        return EnergyHelper.getEUTier(this.power);
    }

    @Override
    @Optional.Method(modid="ic2")
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
        return ITileEnergy.super.emitsEnergyTo(receiver, side);
    }

    @Override
    @Optional.Method(modid="ic2")
    public double getOfferedEnergy() {
        return ITileEnergy.super.getOfferedEnergy();
    }

    @Override
    @Optional.Method(modid="ic2")
    public void drawEnergy(double amount) {
        ITileEnergy.super.drawEnergy(amount);
    }

    @Override
    public boolean hasConfigurableEnergyConnections() {
        return true;
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        this.writeEnergyConnections(nbt);
        nbt.func_74773_a("ignoreSide", NCMath.booleansToBytes(this.ignoreSide));
        nbt.func_74772_a("power", this.power);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.readEnergyConnections(nbt);
        boolean[] arr = NCMath.bytesToBooleans(nbt.func_74770_j("ignoreSide"));
        if (arr.length == 6) {
            this.ignoreSide = arr;
        }
        if (nbt.func_74764_b("power")) {
            this.power = nbt.func_74763_f("power");
        }
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (!this.ignoreSide(side) && (capability == CapabilityEnergy.ENERGY || ModCheck.gregtechLoaded() && NCConfig.enable_gtce_eu && capability == GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER)) {
            return this.hasEnergySideCapability(side);
        }
        return super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (!this.ignoreSide(side)) {
            if (capability == CapabilityEnergy.ENERGY) {
                if (this.hasEnergySideCapability(side)) {
                    return (T)CapabilityEnergy.ENERGY.cast((Object)this.getEnergySide(this.nonNullSide(side)));
                }
                return null;
            }
            if (ModCheck.gregtechLoaded() && capability == GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER) {
                if (NCConfig.enable_gtce_eu && this.hasEnergySideCapability(side)) {
                    return (T)GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER.cast((Object)this.getEnergySideGT(this.nonNullSide(side)));
                }
                return null;
            }
        }
        return super.getCapability(capability, side);
    }

    public static class Californium
    extends TileRTG {
        public Californium() {
            super(RTGType.CALIFORNIUM);
        }
    }

    public static class Americium
    extends TileRTG {
        public Americium() {
            super(RTGType.AMERICIUM);
        }
    }

    public static class Plutonium
    extends TileRTG {
        public Plutonium() {
            super(RTGType.PLUTONIUM);
        }
    }

    public static class Uranium
    extends TileRTG {
        public Uranium() {
            super(RTGType.URANIUM);
        }
    }
}

