/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.qComputer;

import it.unimi.dsi.fastutil.ints.Int2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import nc.config.NCConfig;
import nc.multiblock.Multiblock;
import nc.multiblock.qComputer.QuantumGate;
import nc.multiblock.qComputer.tile.IQuantumComputerPart;
import nc.multiblock.qComputer.tile.TileQuantumComputerController;
import nc.multiblock.qComputer.tile.TileQuantumComputerQubit;
import nc.multiblock.tile.TileBeefAbstract;
import nc.util.CollectionHelper;
import nc.util.Complex;
import nc.util.ComplexMatrix;
import nc.util.ComplexVector;
import nc.util.IOHelper;
import nc.util.Lang;
import nc.util.NCMath;
import nc.util.NCUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.commons.io.FileUtils;

public class QuantumComputer
extends Multiblock<QuantumComputer, IQuantumComputerPart> {
    public static final ObjectSet<Class<? extends IQuantumComputerPart>> PART_CLASSES = new ObjectOpenHashSet();
    protected final Multiblock.PartSuperMap<QuantumComputer, IQuantumComputerPart> partSuperMap = new Multiblock.PartSuperMap();
    protected TileQuantumComputerController controller;
    protected ComplexVector state;
    protected ComplexVector cache = null;
    protected Queue<QuantumGate<?>> queue = new ConcurrentLinkedQueue();
    public int codeStart = -1;
    public int codeType = -1;
    protected StringBuilder codeBuilder;

    public QuantumComputer(World world) {
        super(world, QuantumComputer.class, IQuantumComputerPart.class);
        for (Class clazz : PART_CLASSES) {
            this.partSuperMap.equip(clazz);
        }
        this.state = new ComplexVector(1);
    }

    @Override
    public Multiblock.PartSuperMap<QuantumComputer, IQuantumComputerPart> getPartSuperMap() {
        return this.partSuperMap;
    }

    @Override
    public void onAttachedPartWithMultiblockData(IQuantumComputerPart part, NBTTagCompound data) {
        this.syncDataFrom(data, TileBeefAbstract.SyncReason.FullSync);
    }

    @Override
    protected void onBlockAdded(IQuantumComputerPart newPart) {
        this.onPartAdded(newPart);
        this.refreshState(false);
    }

    @Override
    protected void onBlockRemoved(IQuantumComputerPart oldPart) {
        this.onPartRemoved(oldPart);
        this.refreshState(false);
    }

    @Override
    protected void onMachineAssembled() {
        this.onQuantumComputerFormed();
    }

    @Override
    protected void onMachineRestored() {
        this.onQuantumComputerFormed();
    }

    public static int getMaxQubits() {
        return Math.max(NCConfig.quantum_max_qubits_live, NCConfig.quantum_max_qubits_code);
    }

    protected void onQuantumComputerFormed() {
        if (!this.WORLD.field_72995_K) {
            IntOpenHashSet set = new IntOpenHashSet();
            for (TileQuantumComputerQubit qubit : this.getQubits()) {
                if (set.contains(qubit.id)) {
                    qubit.id = -1;
                    continue;
                }
                if (qubit.id < 0) continue;
                set.add(qubit.id);
            }
            int i = 0;
            for (TileQuantumComputerQubit qubit : this.getQubits()) {
                while (set.contains(i)) {
                    ++i;
                }
                if (qubit.id >= 0) continue;
                qubit.id = i++;
            }
        }
    }

    @Override
    protected void onMachinePaused() {
    }

    @Override
    protected void onMachineDisassembled() {
    }

    @Override
    protected int getMinimumNumberOfBlocksForAssembledMachine() {
        return 1;
    }

    @Override
    protected int getMaximumXSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected int getMaximumZSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected int getMaximumYSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected boolean isMachineWhole() {
        int max;
        if (!NCConfig.quantum_dedicated_server && FMLCommonHandler.instance().getSide().isServer()) {
            this.setLastError("nuclearcraft.multiblock_validation.quantum_computer.server_disabled", null, new Object[0]);
            return false;
        }
        if (this.getPartMap(TileQuantumComputerController.class).isEmpty()) {
            this.setLastError("nuclearcraft.multiblock_validation.no_controller", null, new Object[0]);
            return false;
        }
        if (this.getPartCount(TileQuantumComputerController.class) > 1) {
            this.setLastError("nuclearcraft.multiblock_validation.too_many_controllers", null, new Object[0]);
            return false;
        }
        int q = this.qubitCount();
        if (q > (max = QuantumComputer.getMaxQubits())) {
            this.setLastError("nuclearcraft.multiblock_validation.quantum_computer.too_many_qubits", null, q, max);
            return false;
        }
        Iterator<TileQuantumComputerController> iterator = this.getParts(TileQuantumComputerController.class).iterator();
        while (iterator.hasNext()) {
            TileQuantumComputerController contr;
            this.controller = contr = iterator.next();
        }
        return true;
    }

    @Override
    protected void onAssimilate(QuantumComputer assimilated) {
    }

    @Override
    protected void onAssimilated(QuantumComputer assimilator) {
    }

    @Override
    protected boolean updateServer() {
        QuantumGate<?> gate;
        boolean refresh = false;
        int q = this.qubitCount();
        if (this.codeStart >= 0) {
            this.codeType = this.codeStart;
            this.codeStart = -1;
            this.codeBuilder = new StringBuilder();
        }
        if ((gate = this.queue.poll()) != null) {
            try {
                QuantumGate<?> next;
                this.tryLoadStateCache(QuantumGate.dim(q));
                QuantumGate<?> merger = gate;
                while (merger != null && (next = this.queue.peek()) != null) {
                    if ((merger = merger.merge(next)) == null) continue;
                    this.queue.poll();
                    gate = merger;
                }
                if (this.codeType >= 0) {
                    if (q <= NCConfig.quantum_max_qubits_code) {
                        List<String> code = gate.getCode(this.codeType);
                        if (!code.isEmpty()) {
                            this.codeBuilder.append(IOHelper.NEW_LINE);
                        }
                        for (String line : code) {
                            this.codeBuilder.append(line);
                            this.codeBuilder.append(IOHelper.NEW_LINE);
                        }
                    }
                } else if (q <= NCConfig.quantum_max_qubits_live) {
                    gate.run();
                    refresh = gate.shouldMarkDirty();
                }
            }
            catch (OutOfMemoryError e) {
                if (this.controller != null) {
                    this.WORLD.func_175713_t(this.controller.func_174877_v());
                    this.WORLD.func_175698_g(this.controller.func_174877_v());
                }
                NCUtil.getLogger().fatal("The quantum computer with " + q + " qubits at " + this.getMiddleCoord().toString() + " has caused the game to run out of heap memory! The controller has been destroyed and so the multiblock has been disabled. It is HIGHLY recommended that the maximum qubit limits are lowered in the configs!");
                e.printStackTrace();
                return false;
            }
        }
        return refresh;
    }

    @Override
    protected void updateClient() {
    }

    @Override
    protected boolean isBlockGoodForInterior(World world, BlockPos pos) {
        return true;
    }

    @Override
    public void syncDataFrom(NBTTagCompound data, TileBeefAbstract.SyncReason syncReason) {
        this.cache = ComplexVector.readFromNBT(data, "state");
    }

    @Override
    public void syncDataTo(NBTTagCompound data, TileBeefAbstract.SyncReason syncReason) {
        if (this.qubitCount() <= NCConfig.quantum_max_qubits_live) {
            this.state.writeToNBT(data, "state");
        }
    }

    protected boolean tryLoadStateCache(int dim) {
        if (this.cache != null && this.cache.dim == dim) {
            this.state = this.cache.normalize();
            this.cache = null;
            this.markQubitsDirty();
            return true;
        }
        return false;
    }

    public Collection<TileQuantumComputerQubit> getQubits() {
        return this.getParts(TileQuantumComputerQubit.class);
    }

    public int qubitCount() {
        return this.getPartCount(TileQuantumComputerQubit.class);
    }

    protected void setQubitsRedstone(int o, IntList n) {
        if (this.cache == null) {
            for (TileQuantumComputerQubit qubit : this.getQubits()) {
                boolean result;
                if (!n.contains(qubit.id)) continue;
                qubit.redstone = result = NCMath.getBit(o, this.qubitCount() - qubit.id - 1) == 1;
                qubit.measureColor = result ? 1.0f : -1.0f;
                qubit.sendTileUpdatePacketToAll();
            }
        }
    }

    protected void markQubitsDirty() {
        for (TileQuantumComputerQubit qubit : this.getQubits()) {
            qubit.func_70296_d();
            qubit.updateComparatorOutputLevel();
        }
    }

    protected void checkStateDim(int dim) {
        if (this.state.dim != dim && this.qubitCount() <= NCConfig.quantum_max_qubits_live) {
            this.state = new ComplexVector(dim);
        }
    }

    protected void collapse(int dim, int o, IntSet i, IntSet n) {
        if (i.size() <= 1) {
            this.state.zero();
            int j = 0;
            IntIterator intIterator = i.iterator();
            while (intIterator.hasNext()) {
                int k;
                j = k = ((Integer)intIterator.next()).intValue();
            }
            this.state.re[j] = 1.0;
            this.state.im[j] = 0.0;
        } else {
            for (int j = 0; j < dim; ++j) {
                if (i.contains(j)) continue;
                this.state.im[j] = 0.0;
                this.state.re[j] = 0.0;
            }
        }
        this.state.normalize();
        this.setQubitsRedstone(o, QuantumGate.list(n));
        this.markQubitsDirty();
    }

    protected void refreshState(boolean collapse) {
        int q = this.qubitCount();
        if (q > QuantumComputer.getMaxQubits()) {
            return;
        }
        int dim = QuantumGate.dim(q);
        this.checkStateDim(dim);
        if (collapse) {
            this.collapse(dim, 0, QuantumGate.set(0), QuantumGate.set(CollectionHelper.increasingArray(q)));
        }
        this.markQubitsDirty();
    }

    public void measure(IntSet n) {
        int o;
        IntList _n = QuantumGate.list(n);
        int q = this.qubitCount();
        int dim = QuantumGate.dim(q);
        this.checkStateDim(dim);
        int[] z = new int[_n.size()];
        for (int j = 0; j < _n.size(); ++j) {
            z[j] = q - _n.getInt(j) - 1;
        }
        Int2DoubleOpenHashMap w = new Int2DoubleOpenHashMap();
        Int2ObjectOpenHashMap s = new Int2ObjectOpenHashMap();
        IntArrayList l = new IntArrayList();
        IntSet i = null;
        double sum = 0.0;
        for (int j = 0; j < dim; ++j) {
            double a = Complex.absSq(this.state.re[j], this.state.im[j]);
            sum += a;
            o = NCMath.onlyBits(j, z);
            if (w.containsKey(o)) {
                w.put(o, w.get(o) + a);
                ((IntSet)s.get(o)).add(j);
                continue;
            }
            l.add(o);
            w.put(o, a);
            s.put(o, (Object)QuantumGate.set(j));
        }
        o = dim - 1;
        sum *= this.rand.nextDouble();
        IntListIterator intListIterator = l.iterator();
        while (intListIterator.hasNext()) {
            int j = (Integer)intListIterator.next();
            if (!((sum -= w.get(j)) < 0.0)) continue;
            o = j;
            i = (IntSet)s.get(j);
            break;
        }
        this.collapse(dim, o, i == null ? QuantumGate.set(dim - 1) : i, n);
    }

    public Queue<QuantumGate<?>> getGateQueue() {
        return this.queue;
    }

    protected boolean invalid(IntList n) {
        int q = this.qubitCount();
        IntListIterator intListIterator = n.iterator();
        while (intListIterator.hasNext()) {
            int i = (Integer)intListIterator.next();
            if (i >= 0 && i < q) continue;
            return true;
        }
        return false;
    }

    protected ComplexMatrix fallback() {
        return QuantumGate.id(this.qubitCount());
    }

    protected void gate(ComplexMatrix m) {
        this.checkStateDim(QuantumGate.dim(this.qubitCount()));
        this.state.map(m);
    }

    protected ComplexMatrix single(ComplexMatrix m, IntList n) {
        int q = this.qubitCount();
        if (n.isEmpty()) {
            return QuantumGate.id(q);
        }
        if (this.invalid(n)) {
            return this.fallback();
        }
        ComplexMatrix[] t = new ComplexMatrix[q];
        for (int j = 0; j < q; ++j) {
            t[j] = n.contains(j) ? m : QuantumGate.I;
        }
        return ComplexMatrix.tensorProduct(t);
    }

    public void x(IntSet n) {
        this.gate(this.single(QuantumGate.X, QuantumGate.list(n)));
    }

    public void y(IntSet n) {
        this.gate(this.single(QuantumGate.Y, QuantumGate.list(n)));
    }

    public void z(IntSet n) {
        this.gate(this.single(QuantumGate.Z, QuantumGate.list(n)));
    }

    public void h(IntSet n) {
        this.gate(this.single(QuantumGate.H, QuantumGate.list(n)));
    }

    public void s(IntSet n) {
        this.gate(this.single(QuantumGate.S, QuantumGate.list(n)));
    }

    public void sdg(IntSet n) {
        this.gate(this.single(QuantumGate.Sdg, QuantumGate.list(n)));
    }

    public void t(IntSet n) {
        this.gate(this.single(QuantumGate.T, QuantumGate.list(n)));
    }

    public void tdg(IntSet n) {
        this.gate(this.single(QuantumGate.Tdg, QuantumGate.list(n)));
    }

    public void p(double angle, IntSet n) {
        this.gate(this.single(QuantumGate.p(angle), QuantumGate.list(n)));
    }

    public void rx(double angle, IntSet n) {
        this.gate(this.single(QuantumGate.rx(angle), QuantumGate.list(n)));
    }

    public void ry(double angle, IntSet n) {
        this.gate(this.single(QuantumGate.ry(angle), QuantumGate.list(n)));
    }

    public void rz(double angle, IntSet n) {
        this.gate(this.single(QuantumGate.rz(angle), QuantumGate.list(n)));
    }

    public void swap(IntList i_, IntList j_) {
        if (i_.size() != j_.size()) {
            return;
        }
        if (this.invalid(i_) || this.invalid(j_)) {
            return;
        }
        int q = this.qubitCount();
        int dim = QuantumGate.dim(q);
        this.checkStateDim(dim);
        for (int k = 0; k < dim; ++k) {
            for (int a = 0; a < i_.size(); ++a) {
                int j;
                int i = i_.getInt(a);
                if (i == (j = j_.getInt(a))) continue;
                i = q - i - 1;
                j = q - j - 1;
                if (NCMath.getBit(k, i) != 0 || NCMath.getBit(k, j) != 1) continue;
                int s = NCMath.swap(k, i, j);
                double re = this.state.re[k];
                double im = this.state.im[k];
                this.state.re[k] = this.state.re[s];
                this.state.im[k] = this.state.im[s];
                this.state.re[s] = re;
                this.state.im[s] = im;
            }
        }
    }

    public ComplexMatrix control(ComplexMatrix g, IntList c, IntList t) {
        int q = this.qubitCount();
        if (t.isEmpty()) {
            return QuantumGate.id(q);
        }
        if (c.isEmpty()) {
            return this.single(g, t);
        }
        if (this.invalid(c)) {
            return this.fallback();
        }
        IntListIterator intListIterator = c.iterator();
        while (intListIterator.hasNext()) {
            int i = (Integer)intListIterator.next();
            if (!t.contains(i)) continue;
            return QuantumGate.id(q);
        }
        int s = QuantumGate.dim(c.size());
        ComplexMatrix m = new ComplexMatrix(QuantumGate.dim(q));
        ComplexMatrix[] e = new ComplexMatrix[q];
        for (int i = 0; i < s; ++i) {
            int k = 0;
            for (int j = 0; j < q; ++j) {
                boolean b = c.contains(j);
                ComplexMatrix complexMatrix = b ? (NCMath.getBit(i, c.size() - k - 1) == 1 ? QuantumGate.P_1 : QuantumGate.P_0) : (e[j] = t.contains(j) && i == s - 1 ? g : QuantumGate.I);
                if (!b) continue;
                ++k;
            }
            m.add(ComplexMatrix.tensorProduct(e));
        }
        return m;
    }

    public void cx(IntSet c, IntSet t) {
        this.gate(this.control(QuantumGate.X, QuantumGate.list(c), QuantumGate.list(t)));
    }

    public void cy(IntSet c, IntSet t) {
        this.gate(this.control(QuantumGate.Y, QuantumGate.list(c), QuantumGate.list(t)));
    }

    public void cz(IntSet c, IntSet t) {
        this.gate(this.control(QuantumGate.Z, QuantumGate.list(c), QuantumGate.list(t)));
    }

    public void ch(IntSet c, IntSet t) {
        this.gate(this.control(QuantumGate.H, QuantumGate.list(c), QuantumGate.list(t)));
    }

    public void cs(IntSet c, IntSet t) {
        this.gate(this.control(QuantumGate.S, QuantumGate.list(c), QuantumGate.list(t)));
    }

    public void csdg(IntSet c, IntSet t) {
        this.gate(this.control(QuantumGate.Sdg, QuantumGate.list(c), QuantumGate.list(t)));
    }

    public void ct(IntSet c, IntSet t) {
        this.gate(this.control(QuantumGate.T, QuantumGate.list(c), QuantumGate.list(t)));
    }

    public void ctdg(IntSet c, IntSet t) {
        this.gate(this.control(QuantumGate.Tdg, QuantumGate.list(c), QuantumGate.list(t)));
    }

    public void cp(double angle, IntSet c, IntSet t) {
        this.gate(this.control(QuantumGate.p(angle), QuantumGate.list(c), QuantumGate.list(t)));
    }

    public void crx(double angle, IntSet c, IntSet t) {
        this.gate(this.control(QuantumGate.rx(angle), QuantumGate.list(c), QuantumGate.list(t)));
    }

    public void cry(double angle, IntSet c, IntSet t) {
        this.gate(this.control(QuantumGate.ry(angle), QuantumGate.list(c), QuantumGate.list(t)));
    }

    public void crz(double angle, IntSet c, IntSet t) {
        this.gate(this.control(QuantumGate.rz(angle), QuantumGate.list(c), QuantumGate.list(t)));
    }

    public void cswap(IntSet c_, IntList i_, IntList j_) {
        if (c_.isEmpty()) {
            this.swap(i_, j_);
            return;
        }
        if (i_.size() != j_.size()) {
            return;
        }
        if (this.invalid(i_) || this.invalid(j_)) {
            return;
        }
        IntIterator intIterator = c_.iterator();
        while (intIterator.hasNext()) {
            int i = (Integer)intIterator.next();
            if (!i_.contains(i) && !j_.contains(i)) continue;
            return;
        }
        IntList c = QuantumGate.list(c_);
        int s = QuantumGate.dim(c.size());
        int q = this.qubitCount();
        int dim = QuantumGate.dim(q);
        this.checkStateDim(dim);
        ComplexMatrix m = new ComplexMatrix(dim);
        ComplexMatrix[] e = new ComplexMatrix[q];
        for (int u = 0; u < s; ++u) {
            int k = 0;
            for (int v = 0; v < q; ++v) {
                boolean b = c.contains(v);
                ComplexMatrix complexMatrix = b ? (NCMath.getBit(u, c.size() - k - 1) == 1 ? QuantumGate.P_1 : QuantumGate.P_0) : (e[v] = QuantumGate.I);
                if (!b) continue;
                ++k;
            }
            ComplexMatrix p = ComplexMatrix.tensorProduct(e);
            if (u == s - 1) {
                for (int l = 0; l < dim; ++l) {
                    for (int a = 0; a < i_.size(); ++a) {
                        int j;
                        int i = i_.getInt(a);
                        if (i == (j = j_.getInt(a))) continue;
                        i = q - i - 1;
                        j = q - j - 1;
                        if (NCMath.getBit(l, i) != 0 || NCMath.getBit(l, j) != 1) continue;
                        int w = NCMath.swap(l, i, j);
                        p.swap(l, l, w, l);
                        p.swap(w, w, l, w);
                    }
                }
            }
            m.add(p);
        }
        this.gate(m);
    }

    public void printCode(EntityPlayer player) {
        if (this.codeType < 0) {
            return;
        }
        int cachedCodeType = this.codeType;
        this.codeType = -1;
        int q = this.qubitCount();
        if (q > NCConfig.quantum_max_qubits_code) {
            player.func_145747_a((ITextComponent)new TextComponentString(Lang.localise("info.nuclearcraft.multitool.quantum_computer.controller.code_exit_too_many_qubits")));
            return;
        }
        String codeString = this.codeBuilder.toString();
        String s = IOHelper.NEW_LINE;
        String d = s + s;
        String time = Long.toString(System.currentTimeMillis() / 100L);
        if (cachedCodeType == 0) {
            if (codeString.isEmpty()) {
                player.func_145747_a((ITextComponent)new TextComponentString(Lang.localise("info.nuclearcraft.multitool.quantum_computer.controller.qasm_exit_empty")));
                return;
            }
            File out = new File("nc_quantum/qasm/" + q + "_qubit_" + time + ".qasm");
            codeString = "OPENQASM 2.0;" + s + "include \"qelib1.inc\";" + d + "qreg q[" + q + "];" + s + "creg c[" + q + "];" + d + codeString;
            try {
                FileUtils.writeStringToFile((File)out, (String)codeString);
                TextComponentString link = new TextComponentString(out.getName());
                link.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, out.getAbsolutePath())).func_150227_a(Boolean.valueOf(true)).func_150228_d(Boolean.valueOf(true));
                player.func_145747_a((ITextComponent)new TextComponentTranslation("info.nuclearcraft.multitool.quantum_computer.controller.qasm_print", new Object[]{link}));
            }
            catch (IOException e) {
                NCUtil.getLogger().catching((Throwable)e);
                player.func_145747_a((ITextComponent)new TextComponentTranslation("info.nuclearcraft.multitool.quantum_computer.controller.qasm_error", new Object[]{out.getAbsolutePath()}));
            }
        } else if (cachedCodeType == 1) {
            if (codeString.isEmpty()) {
                player.func_145747_a((ITextComponent)new TextComponentString(Lang.localise("info.nuclearcraft.multitool.quantum_computer.controller.qiskit_exit_empty")));
                return;
            }
            File out = new File("nc_quantum/qiskit/" + q + "_qubit_" + time + ".ipynb");
            codeString = "# Jupyter plot output mode" + s + "# %matplotlib inline" + d + "# Imports" + s + "import qiskit" + s + "from qiskit import IBMQ, QuantumCircuit, visualization" + s + "from qiskit.providers import ibmq" + s + "from qiskit.tools import monitor" + d + "# Number of qubits" + s + "qubits = " + q + d + "# Load IBMQ account" + s + "provider = IBMQ.load_account()" + d + "# Get backends" + s + "simulator = provider.get_backend('simulator_statevector')" + s + "device = provider.get_backend('ibmq_manila')" + s + "filtered = provider.backends(" + s + "    filters=lambda x:" + s + "    int(x.configuration().num_qubits) >= qubits" + s + "    and not x.configuration().simulator" + s + "    and x.status().operational" + s + ")" + s + "leastbusy = ibmq.least_busy(filtered) if len(filtered) > 0 else device" + d + "# Choice of backend" + s + "qc_backend = " + (q > 5 ? "simulator" : "device") + d + "# Construct circuit" + s + "qc = QuantumCircuit(qubits, qubits)" + d + "# Generated code" + codeString + d + "# Helper function" + s + "def run_job(circuit, backend, shots=4096, optimization_level=3):" + s + "    print(f'Using backend {backend}...')" + s + "    job = qiskit.execute(circuit, backend=backend, shots=shots, optimization_level=optimization_level)" + s + "    qiskit.tools.job_monitor(job)" + s + "    return job.result()" + s + d + "# Run circuit" + s + "result = run_job(qc, qc_backend, 4096, 3)" + s + "counts = result.get_counts(qc)" + s + "hist = visualization.plot_histogram(counts)" + s + "print('\\nCounts: ', counts)" + d + "# Save circuit diagram to file" + s + "qc.draw(output='mpl', filename='circuit.png')" + d + "# Save plot to file" + s + "hist.savefig('counts.png')" + d + "# Plot results in output - only works in Jupyter" + s + "# hist" + s;
            try {
                FileUtils.writeStringToFile((File)out, (String)codeString);
                TextComponentString link = new TextComponentString(out.getName());
                link.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, out.getAbsolutePath())).func_150227_a(Boolean.valueOf(true)).func_150228_d(Boolean.valueOf(true));
                player.func_145747_a((ITextComponent)new TextComponentTranslation("info.nuclearcraft.multitool.quantum_computer.controller.qiskit_print", new Object[]{link}));
            }
            catch (IOException e) {
                NCUtil.getLogger().catching((Throwable)e);
                player.func_145747_a((ITextComponent)new TextComponentTranslation("info.nuclearcraft.multitool.quantum_computer.controller.qiskit_error", new Object[]{out.getAbsolutePath()}));
            }
        } else {
            player.func_145747_a((ITextComponent)new TextComponentString(Lang.localise("info.nuclearcraft.multitool.quantum_computer.controller.code_exit_empty")));
            return;
        }
        codeString = null;
    }
}

