/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.heatExchanger.tile;

import java.util.ArrayList;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import nc.multiblock.cuboidal.CuboidalPartPositionType;
import nc.multiblock.heatExchanger.HeatExchanger;
import nc.multiblock.heatExchanger.tile.TileCondenserTube;
import nc.multiblock.heatExchanger.tile.TileHeatExchangerPart;
import nc.multiblock.heatExchanger.tile.TileHeatExchangerTube;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="opencomputers")
public class TileHeatExchangerComputerPort
extends TileHeatExchangerPart
implements SimpleComponent {
    public TileHeatExchangerComputerPort() {
        super(CuboidalPartPositionType.WALL);
    }

    @Override
    public void onMachineAssembled(HeatExchanger controller) {
        this.doStandardNullControllerResponse(controller);
        super.onMachineAssembled(controller);
    }

    @Override
    public void onMachineBroken() {
        super.onMachineBroken();
    }

    @Optional.Method(modid="opencomputers")
    public String getComponentName() {
        return "nc_heat_exchanger";
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] isComplete(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled()};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] isHeatExchangerOn(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((HeatExchanger)this.getMultiblock()).isHeatExchangerOn : false};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getLengthX(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((HeatExchanger)this.getMultiblock()).getInteriorLengthX() : 0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getLengthY(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((HeatExchanger)this.getMultiblock()).getInteriorLengthY() : 0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getLengthZ(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((HeatExchanger)this.getMultiblock()).getInteriorLengthZ() : 0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getFractionOfTubesActive(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((HeatExchanger)this.getMultiblock()).fractionOfTubesActive : 0.0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getMeanEfficiency(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((HeatExchanger)this.getMultiblock()).efficiency : 0.0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getNumberOfExchangerTubes(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((HeatExchanger)this.getMultiblock()).getTubes().size() : 0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getNumberOfCondensationTubes(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((HeatExchanger)this.getMultiblock()).getCondenserTubes().size() : 0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getExchangerTubeStats(Context context, Arguments args) {
        if (this.isMultiblockAssembled()) {
            ArrayList<Object[]> stats = new ArrayList<Object[]>();
            for (TileHeatExchangerTube tube : ((HeatExchanger)this.getMultiblock()).getTubes()) {
                stats.add(new Object[]{new Object[]{tube.func_174877_v().func_177958_n(), tube.func_174877_v().func_177956_o(), tube.func_174877_v().func_177952_p()}, tube.conductivity, tube.isProcessing, tube.time, tube.recipeInfo != null ? tube.baseProcessTime / tube.getSpeedMultiplier() : 0.0, tube.getSpeedMultiplier(), tube.inputTemperature, tube.outputTemperature, tube.flowDir == null ? "null" : tube.flowDir.func_176610_l()});
            }
            return new Object[]{stats.toArray()};
        }
        return new Object[0];
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getCondensationTubeStats(Context context, Arguments args) {
        if (this.isMultiblockAssembled()) {
            ArrayList<Object[]> stats = new ArrayList<Object[]>();
            for (TileCondenserTube condenserTube : ((HeatExchanger)this.getMultiblock()).getCondenserTubes()) {
                stats.add(new Object[]{new Object[]{condenserTube.func_174877_v().func_177958_n(), condenserTube.func_174877_v().func_177956_o(), condenserTube.func_174877_v().func_177952_p()}, condenserTube.conductivity, condenserTube.isProcessing, condenserTube.time, condenserTube.recipeInfo != null ? condenserTube.baseProcessTime / condenserTube.getSpeedMultiplier() : 0.0, condenserTube.getSpeedMultiplier(), condenserTube.condensingTemperature, condenserTube.adjacentTemperatures});
            }
            return new Object[]{stats.toArray()};
        }
        return new Object[0];
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] activate(Context context, Arguments args) {
        if (this.isMultiblockAssembled()) {
            ((HeatExchanger)this.getMultiblock()).computerActivated = true;
            ((HeatExchanger)this.getMultiblock()).setIsHeatExchangerOn();
        }
        return new Object[0];
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] deactivate(Context context, Arguments args) {
        if (this.isMultiblockAssembled()) {
            ((HeatExchanger)this.getMultiblock()).computerActivated = false;
            ((HeatExchanger)this.getMultiblock()).setIsHeatExchangerOn();
        }
        return new Object[0];
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] clearAllMaterial(Context context, Arguments args) {
        if (this.isMultiblockAssembled()) {
            ((HeatExchanger)this.getMultiblock()).clearAllMaterial();
        }
        return new Object[0];
    }
}

