/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.gui;

import com.google.common.collect.Lists;
import java.util.List;
import nc.gui.NCGui;
import nc.gui.element.GuiItemRenderer;
import nc.multiblock.container.ContainerFissionIrradiator;
import nc.multiblock.fission.FissionReactor;
import nc.multiblock.fission.tile.TileFissionIrradiator;
import nc.util.Lang;
import nc.util.UnitHelper;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class GuiFissionIrradiator
extends NCGui {
    protected final TileFissionIrradiator irradiator;
    protected final ResourceLocation gui_textures;

    public GuiFissionIrradiator(EntityPlayer player, TileFissionIrradiator irradiator) {
        super(new ContainerFissionIrradiator(player, irradiator));
        this.irradiator = irradiator;
        this.gui_textures = new ResourceLocation("nuclearcraft:textures/gui/container/fission_irradiator.png");
    }

    @Override
    public void renderTooltips(int mouseX, int mouseY) {
        this.drawTooltip(this.irradiator.clusterHeatCapacity >= 0L ? this.heatInfo() : this.noClusterInfo(), mouseX, mouseY, 8, 6, 16, 74);
    }

    public List<String> heatInfo() {
        String heat = UnitHelper.prefix(this.irradiator.clusterHeatStored, this.irradiator.clusterHeatCapacity, 5, "H");
        return Lists.newArrayList((Object[])new String[]{TextFormatting.YELLOW + Lang.localise("gui.nc.container.fission_irradiator.heat_stored") + TextFormatting.WHITE + " " + heat});
    }

    public List<String> noClusterInfo() {
        return Lists.newArrayList((Object[])new String[]{TextFormatting.RED + Lang.localise("gui.nc.container.no_cluster")});
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int fontColor = this.irradiator.getMultiblock() != null && ((FissionReactor)this.irradiator.getMultiblock()).isReactorOn ? -1 : 0xEEAA00;
        String s = Lang.localise("gui.nc.container.fission_irradiator.irradiator");
        this.field_146289_q.func_78276_b(s, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(s) / 2, 6, fontColor);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.gui_textures);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        new GuiItemRenderer((ItemStack)this.irradiator.getFilterStacks().get(0), this.field_147003_i + 56, this.field_147009_r + 35, 0.5f).draw();
        this.field_146297_k.func_110434_K().func_110577_a(this.gui_textures);
        if (this.irradiator.clusterHeatCapacity >= 0L) {
            int e = (int)Math.round(74.0 * (double)this.irradiator.clusterHeatStored / (double)this.irradiator.clusterHeatCapacity);
            this.func_73729_b(this.field_147003_i + 8, this.field_147009_r + 6 + 74 - e, 176, 164 - e, 16, e);
        } else {
            this.func_73733_a(this.field_147003_i + 8, this.field_147009_r + 6, this.field_147003_i + 8 + 16, this.field_147009_r + 6 + 74, -8947849, -11316397);
        }
        this.func_73729_b(this.field_147003_i + 74, this.field_147009_r + 35, 176, 3, this.getCookProgressScaled(37), 16);
    }

    protected int getCookProgressScaled(int pixels) {
        if (this.irradiator.baseProcessTime / this.irradiator.getSpeedMultiplier() < 4.0) {
            return this.irradiator.isProcessing ? pixels : 0;
        }
        double i = this.irradiator.time;
        double j = this.irradiator.baseProcessTime;
        return j != 0.0 ? (int)Math.round(i * (double)pixels / j) : 0;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.initButtons();
    }

    public void initButtons() {
    }
}

