/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.fission.tile.manager;

import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import javax.annotation.Nullable;
import nc.block.property.BlockProperties;
import nc.multiblock.cuboidal.CuboidalPartPositionType;
import nc.multiblock.fission.FissionReactor;
import nc.multiblock.fission.tile.TileFissionPart;
import nc.multiblock.fission.tile.manager.IFissionManager;
import nc.multiblock.fission.tile.manager.IFissionManagerListener;
import nc.util.NBTHelper;
import net.minecraft.block.properties.IProperty;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;

public abstract class TileFissionManager<MANAGER extends TileFissionManager<MANAGER, LISTENER>, LISTENER extends IFissionManagerListener<MANAGER, LISTENER>>
extends TileFissionPart
implements ITickable,
IFissionManager<MANAGER, LISTENER> {
    protected final Class<MANAGER> managerClass;
    protected LongSet listenerPosSet = new LongOpenHashSet();
    public boolean refreshListenersFlag = false;

    public TileFissionManager(Class<MANAGER> managerClass) {
        super(CuboidalPartPositionType.WALL);
        this.managerClass = managerClass;
    }

    @Override
    public void onMachineAssembled(FissionReactor controller) {
        this.doStandardNullControllerResponse(controller);
        super.onMachineAssembled(controller);
        if (!this.func_145831_w().field_72995_K && this.getPartPosition().getFacing() != null) {
            this.func_145831_w().func_180501_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()).func_177226_a((IProperty)BlockProperties.FACING_ALL, (Comparable)this.getPartPosition().getFacing()), 2);
        }
    }

    @Override
    public void onMachineBroken() {
        super.onMachineBroken();
    }

    @Override
    public LongSet getListenerPosSet() {
        return this.listenerPosSet;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.refreshListenersFlag) {
            this.refreshListeners(false);
        }
    }

    @Override
    public void func_70296_d() {
        this.refreshListenersFlag = true;
        super.func_70296_d();
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        NBTHelper.writeLongCollection(nbt, (LongCollection)this.listenerPosSet, "listenerPosSet");
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        NBTHelper.readLongCollection(nbt, (LongCollection)this.listenerPosSet, "listenerPosSet");
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        return super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        return super.getCapability(capability, side);
    }
}

