/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.fission.tile;

import javax.annotation.Nonnull;
import nc.config.NCConfig;
import nc.enumm.MetaEnums;
import nc.multiblock.cuboidal.CuboidalPartPositionType;
import nc.multiblock.cuboidal.PartPosition;
import nc.multiblock.fission.FissionReactor;
import nc.multiblock.fission.FissionReactorLogic;
import nc.multiblock.fission.tile.IFissionComponent;
import nc.multiblock.fission.tile.IFissionFuelComponent;
import nc.multiblock.fission.tile.TileFissionPart;
import nc.recipe.BasicRecipe;
import nc.recipe.NCRecipes;
import nc.recipe.RecipeHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileFissionSource
extends TileFissionPart {
    protected double efficiency;
    public EnumFacing facing = EnumFacing.DOWN;

    public TileFissionSource() {
        super(CuboidalPartPositionType.WALL);
    }

    public TileFissionSource(double efficiency) {
        this();
        this.efficiency = efficiency;
    }

    @Override
    public void onMachineAssembled(FissionReactor controller) {
        this.doStandardNullControllerResponse(controller);
        super.onMachineAssembled(controller);
    }

    @Override
    public void onMachineBroken() {
        super.onMachineBroken();
    }

    @Override
    @Nonnull
    public PartPosition getPartPosition() {
        PartPosition partPos = super.getPartPosition();
        if (partPos.getFacing() != null) {
            this.facing = partPos.getFacing();
        }
        return partPos;
    }

    @Override
    public int[] weakSidesToCheck(World worldIn, BlockPos posIn) {
        return new int[]{2, 3, 4, 5};
    }

    @Override
    public void onBlockNeighborChanged(IBlockState state, World worldIn, BlockPos posIn, BlockPos fromPos) {
        boolean wasRedstonePowered = this.getIsRedstonePowered();
        super.onBlockNeighborChanged(state, worldIn, posIn, fromPos);
        this.setActivity(this.getIsRedstonePowered());
        if (!worldIn.field_72995_K && wasRedstonePowered != this.getIsRedstonePowered()) {
            ((FissionReactorLogic)this.getLogic()).onSourceUpdated(this);
        }
    }

    public PrimingTargetInfo getPrimingTarget(boolean simulate) {
        EnumFacing posFacing = this.getPartPosition().getFacing();
        if (posFacing == null && (posFacing = this.facing) == null) {
            return null;
        }
        EnumFacing dir = posFacing.func_176734_d();
        for (int i = 1; i <= NCConfig.fission_max_size; ++i) {
            BlockPos offPos = this.field_174879_c.func_177967_a(dir, i);
            BasicRecipe blockRecipe = RecipeHelper.blockRecipe(NCRecipes.fission_reflector, this.field_145850_b, offPos);
            if (blockRecipe != null && blockRecipe.getFissionReflectorReflectivity() >= 1.0) {
                return null;
            }
            IFissionComponent component = (IFissionComponent)((FissionReactor)this.getMultiblock()).getPartMap(IFissionComponent.class).get(offPos.func_177986_g());
            if (component != null && component.isNullifyingSources(posFacing)) {
                return null;
            }
            if (!(component instanceof IFissionFuelComponent)) continue;
            IFissionFuelComponent fuelComponent = (IFissionFuelComponent)component;
            if (simulate) {
                return new PrimingTargetInfo(fuelComponent, false);
            }
            if (!fuelComponent.isAcceptingFlux(posFacing)) continue;
            double oldSourceEfficiency = fuelComponent.getSourceEfficiency();
            fuelComponent.setSourceEfficiency(this.efficiency, true);
            return new PrimingTargetInfo(fuelComponent, oldSourceEfficiency != fuelComponent.getSourceEfficiency());
        }
        return null;
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        nbt.func_74768_a("facing", this.facing.func_176745_a());
        nbt.func_74780_a("efficiency", this.efficiency);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.facing = EnumFacing.func_82600_a((int)nbt.func_74762_e("facing"));
        if (nbt.func_74764_b("efficiency")) {
            this.efficiency = nbt.func_74769_h("efficiency");
        }
    }

    public static class PrimingTargetInfo {
        public final IFissionFuelComponent fuelComponent;
        public final boolean newSourceEfficiency;

        PrimingTargetInfo(IFissionFuelComponent fuelComponent, boolean newSourceEfficiency) {
            this.fuelComponent = fuelComponent;
            this.newSourceEfficiency = newSourceEfficiency;
        }
    }

    public static class Californium
    extends Meta {
        public Californium() {
            super(MetaEnums.NeutronSourceType.CALIFORNIUM);
        }
    }

    public static class PoloniumBeryllium
    extends Meta {
        public PoloniumBeryllium() {
            super(MetaEnums.NeutronSourceType.POLONIUM_BERYLLIUM);
        }
    }

    public static class RadiumBeryllium
    extends Meta {
        public RadiumBeryllium() {
            super(MetaEnums.NeutronSourceType.RADIUM_BERYLLIUM);
        }
    }

    protected static class Meta
    extends TileFissionSource {
        protected Meta(MetaEnums.NeutronSourceType type) {
            super(type.getEfficiency());
        }

        @Override
        public boolean shouldRefresh(World worldIn, BlockPos posIn, IBlockState oldState, IBlockState newState) {
            return oldState.func_177230_c() != newState.func_177230_c() || oldState.func_177230_c().func_176201_c(oldState) != newState.func_177230_c().func_176201_c(newState);
        }
    }
}

