/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.fission.tile;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import nc.config.NCConfig;
import nc.multiblock.fission.FissionReactor;
import nc.multiblock.fission.FissionReactorLogic;
import nc.multiblock.fission.tile.IFissionComponent;
import nc.multiblock.fission.tile.IFissionFluxSink;
import nc.multiblock.fission.tile.IFissionHeatingComponent;
import nc.recipe.BasicRecipe;
import nc.recipe.NCRecipes;
import nc.recipe.RecipeHelper;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public interface IFissionFuelComponent
extends IFissionFluxSink,
IFissionHeatingComponent {
    public void tryPriming(FissionReactor var1, boolean var2);

    public boolean isPrimed();

    public void addToPrimedCache(ObjectSet<IFissionFuelComponent> var1);

    public void unprime();

    @Override
    default public boolean isNullifyingSources(EnumFacing side) {
        return false;
    }

    default public boolean isProducingFlux() {
        return this.isPrimed() || this.isFunctional();
    }

    public boolean isFluxSearched();

    public void setFluxSearched(boolean var1);

    public void incrementHeatMultiplier();

    public double getSourceEfficiency();

    public void setSourceEfficiency(double var1, boolean var3);

    public long[] getModeratorLineFluxes();

    public Double[] getModeratorLineEfficiencies();

    public IFissionFluxSink[] getAdjacentFluxSinks();

    public LongSet[] getPassiveModeratorCaches();

    public LongSet[] getActiveModeratorCaches();

    public ModeratorLine[] getModeratorLineCaches();

    public LongSet[] getPassiveReflectorModeratorCaches();

    public LongSet[] getActiveReflectorModeratorCaches();

    public LongSet getActiveReflectorCache();

    public long getHeatMultiplier();

    default public double getModeratorEfficiencyFactor() {
        int count = 0;
        double efficiency = 0.0;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            Double lineEfficiency = this.getModeratorLineEfficiencies()[dir.func_176745_a()];
            if (lineEfficiency == null) continue;
            count = (byte)(count + 1);
            efficiency += this.getModeratorLineFluxes()[dir.func_176745_a()] == 0L ? 0.0 : lineEfficiency;
        }
        return count == 0 ? 0.0 : efficiency / (double)count;
    }

    public double getFluxEfficiencyFactor();

    @Override
    default public double moderatorLineEfficiencyFactor() {
        return 1.0;
    }

    @Override
    default public boolean canSupportActiveModerator(boolean activeModeratorPos) {
        return activeModeratorPos;
    }

    public double getEfficiency();

    public double getEfficiencyIgnoreCoolingPenalty();

    public void setUndercoolingLifetimeFactor(double var1);

    public long getCriticality();

    public double getFloatingPointCriticality();

    public boolean isSelfPriming();

    default public void fluxSearch(ObjectSet<IFissionFuelComponent> fluxSearchCache, Long2ObjectMap<IFissionComponent> componentFailCache, Long2ObjectMap<IFissionComponent> assumedValidCache) {
        if (this.isFluxSearched() || !this.isProducingFlux()) {
            return;
        }
        this.setFluxSearched(true);
        ((FissionReactorLogic)this.getLogic()).distributeFluxFromFuelComponent(this, fluxSearchCache, componentFailCache, assumedValidCache);
    }

    default public void defaultDistributeFlux(ObjectSet<IFissionFuelComponent> fluxSearchCache, Long2ObjectMap<IFissionComponent> componentFailCache, Long2ObjectMap<IFissionComponent> assumedValidCache) {
        block0: for (EnumFacing dir : EnumFacing.field_82609_l) {
            ModeratorBlockInfo activeInfo;
            BlockPos offPos = this.getTilePos().func_177972_a(dir);
            ModeratorBlockInfo moderatorBlockInfo = activeInfo = componentFailCache.containsKey(offPos.func_177986_g()) ? null : this.getModeratorBlockInfo(offPos, dir, this.canSupportActiveModerator(true));
            if (activeInfo == null || activeInfo.blockingFlux) continue;
            ModeratorLine line = new ModeratorLine((ObjectList<ModeratorBlockInfo>)new ObjectArrayList(), this);
            line.info.add((Object)activeInfo);
            line.flux = activeInfo.fluxFactor;
            double moderatorEfficiency = activeInfo.efficiency;
            for (int i = 2; i <= NCConfig.fission_neutron_reach + 1; ++i) {
                BasicRecipe recipe;
                ModeratorBlockInfo info;
                offPos = this.getTilePos().func_177967_a(dir, i);
                ModeratorBlockInfo moderatorBlockInfo2 = info = componentFailCache.containsKey(offPos.func_177986_g()) ? null : this.getModeratorBlockInfo(offPos, dir, this.canSupportActiveModerator(false));
                if (info != null) {
                    if (info.blockingFlux) continue block0;
                    line.info.add((Object)info);
                    line.flux += info.fluxFactor;
                    moderatorEfficiency += info.efficiency;
                    continue;
                }
                IFissionFuelComponent fuelComponent = ((FissionReactorLogic)this.getLogic()).getNextFuelComponent(this, offPos);
                if (fuelComponent != null) {
                    line.fluxSink = fuelComponent;
                    fuelComponent.addFlux(line.flux);
                    fuelComponent.getModeratorLineFluxes()[dir.func_176734_d().func_176745_a()] = line.flux;
                    fuelComponent.getModeratorLineEfficiencies()[dir.func_176734_d().func_176745_a()] = moderatorEfficiency / (double)(i - 1);
                    fuelComponent.incrementHeatMultiplier();
                    this.updateModeratorLine(fuelComponent, dir, line, componentFailCache, assumedValidCache);
                    fluxSearchCache.add((Object)fuelComponent);
                    continue block0;
                }
                IFissionComponent component = (IFissionComponent)((FissionReactor)this.getMultiblock()).getPartMap(IFissionComponent.class).get(offPos.func_177986_g());
                if (component instanceof IFissionFluxSink) {
                    IFissionFluxSink fluxSink = (IFissionFluxSink)component;
                    if (!fluxSink.isAcceptingFlux(dir.func_176734_d())) continue block0;
                    line.fluxSink = fluxSink;
                    fluxSink.addFlux(line.flux);
                    this.getModeratorLineFluxes()[dir.func_176745_a()] = line.flux;
                    this.getModeratorLineEfficiencies()[dir.func_176745_a()] = fluxSink.moderatorLineEfficiencyFactor() * moderatorEfficiency / (double)(i - 1);
                    this.incrementHeatMultiplier();
                    this.updateModeratorLine(fluxSink, dir, line, componentFailCache, assumedValidCache);
                    continue block0;
                }
                if (i - 1 > NCConfig.fission_neutron_reach / 2 || (recipe = RecipeHelper.blockRecipe(NCRecipes.fission_reflector, this.getTileWorld(), offPos)) == null) continue block0;
                line.reflectorRecipe = recipe;
                line.flux = (long)Math.floor(2.0 * (double)line.flux * recipe.getFissionReflectorReflectivity());
                this.addFlux(line.flux);
                this.getModeratorLineFluxes()[dir.func_176745_a()] = line.flux;
                this.getModeratorLineEfficiencies()[dir.func_176745_a()] = recipe.getFissionReflectorEfficiency() * moderatorEfficiency / (double)(i - 1);
                this.incrementHeatMultiplier();
                if (this.isFunctional()) {
                    IFissionFuelComponent.onModeratorLineComplete(line, dir);
                    IFissionFuelComponent.addToModeratorCache(line, ((FissionReactor)this.getMultiblock()).activeModeratorCache, ((FissionReactor)this.getMultiblock()).passiveModeratorCache, componentFailCache, assumedValidCache);
                    ((FissionReactor)this.getMultiblock()).activeReflectorCache.add(offPos.func_177986_g());
                    continue block0;
                }
                this.getModeratorLineCaches()[dir.func_176745_a()] = line;
                IFissionFuelComponent.addToModeratorCache(line, dir, this.getActiveReflectorModeratorCaches(), this.getPassiveReflectorModeratorCaches(), componentFailCache, assumedValidCache);
                this.getActiveReflectorCache().add(offPos.func_177986_g());
                continue block0;
            }
        }
    }

    default public ModeratorBlockInfo getModeratorBlockInfo(BlockPos pos, EnumFacing dir, boolean validActiveModeratorPos) {
        IFissionComponent component = (IFissionComponent)((FissionReactor)this.getMultiblock()).getPartMap(IFissionComponent.class).get(pos.func_177986_g());
        if (component != null) {
            return component.getModeratorBlockInfo(dir, validActiveModeratorPos);
        }
        BasicRecipe recipe = RecipeHelper.blockRecipe(NCRecipes.fission_moderator, this.getTileWorld(), pos);
        if (recipe != null) {
            return new ModeratorBlockInfo(pos, null, false, validActiveModeratorPos, recipe.getFissionModeratorFluxFactor(), recipe.getFissionModeratorEfficiency());
        }
        return null;
    }

    public static void addToModeratorCache(ModeratorLine line, LongSet activeCache, LongSet passiveCache, Long2ObjectMap<IFissionComponent> componentFailCache, Long2ObjectMap<IFissionComponent> assumedValidCache) {
        for (ModeratorBlockInfo info : line.info) {
            IFissionFuelComponent.addToModeratorCache(info, activeCache, passiveCache, componentFailCache, assumedValidCache);
        }
    }

    public static void addToModeratorCache(ModeratorBlockInfo info, LongSet activeCache, LongSet passiveCache, Long2ObjectMap<IFissionComponent> componentFailCache, Long2ObjectMap<IFissionComponent> assumedValidCache) {
        if (info.component != null && !componentFailCache.containsKey(info.posLong)) {
            assumedValidCache.put(info.posLong, (Object)info.component);
            info.component.onAddedToModeratorCache(info);
        } else {
            (info.validActiveModeratorPos ? activeCache : passiveCache).add(info.posLong);
        }
    }

    public static void addToModeratorCache(ModeratorLine line, EnumFacing dir, LongSet[] activeCache, LongSet[] passiveCache, Long2ObjectMap<IFissionComponent> componentFailCache, Long2ObjectMap<IFissionComponent> assumedValidCache) {
        for (ModeratorBlockInfo info : line.info) {
            IFissionFuelComponent.addToModeratorCache(info, dir, activeCache, passiveCache, componentFailCache, assumedValidCache);
        }
    }

    public static void addToModeratorCache(ModeratorBlockInfo info, EnumFacing dir, LongSet[] activeCache, LongSet[] passiveCache, Long2ObjectMap<IFissionComponent> componentFailCache, Long2ObjectMap<IFissionComponent> assumedValidCache) {
        if (info.component != null && !componentFailCache.containsKey(info.posLong)) {
            assumedValidCache.put(info.posLong, (Object)info.component);
            info.component.onAddedToModeratorCache(info);
        } else if (info.validActiveModeratorPos) {
            activeCache[dir.func_176745_a()].add(info.posLong);
        } else {
            passiveCache[dir.func_176745_a()].add(info.posLong);
        }
    }

    public static void onModeratorLineComplete(ModeratorLine line, EnumFacing dir) {
        for (ModeratorBlockInfo info : line.info) {
            if (info.component == null) continue;
            info.component.onModeratorLineComplete(line, info, dir);
        }
    }

    default public void updateModeratorLine(IFissionFluxSink fluxSink, EnumFacing dir, ModeratorLine line, Long2ObjectMap<IFissionComponent> componentFailCache, Long2ObjectMap<IFissionComponent> assumedValidCache) {
        fluxSink.refreshIsProcessing(false);
        ((ModeratorBlockInfo)line.info.get(line.info.size() - 1)).updateModeratorPosValidity(fluxSink.canSupportActiveModerator(true));
        if (this.isFunctional() && fluxSink.isFunctional()) {
            IFissionFuelComponent.onModeratorLineComplete(line, dir);
            IFissionFuelComponent.addToModeratorCache(line, ((FissionReactor)this.getMultiblock()).activeModeratorCache, ((FissionReactor)this.getMultiblock()).passiveModeratorCache, componentFailCache, assumedValidCache);
        } else {
            this.getModeratorLineCaches()[dir.func_176745_a()] = line;
            IFissionFuelComponent.addToModeratorCache(line, dir, this.getActiveModeratorCaches(), this.getPassiveModeratorCaches(), componentFailCache, assumedValidCache);
        }
        this.getAdjacentFluxSinks()[dir.func_176745_a()] = fluxSink;
    }

    default public void defaultRefreshLocal() {
        if (this.isFunctional()) {
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                ModeratorLine line = this.getModeratorLineCaches()[dir.func_176745_a()];
                if (line != null && line.hasValidEndpoint()) {
                    IFissionFuelComponent.onModeratorLineComplete(line, dir);
                    ((FissionReactor)this.getMultiblock()).passiveModeratorCache.addAll((LongCollection)this.getPassiveModeratorCaches()[dir.func_176745_a()]);
                    ((FissionReactor)this.getMultiblock()).activeModeratorCache.addAll((LongCollection)this.getActiveModeratorCaches()[dir.func_176745_a()]);
                }
                ((FissionReactor)this.getMultiblock()).passiveModeratorCache.addAll((LongCollection)this.getPassiveReflectorModeratorCaches()[dir.func_176745_a()]);
                ((FissionReactor)this.getMultiblock()).activeModeratorCache.addAll((LongCollection)this.getActiveReflectorModeratorCaches()[dir.func_176745_a()]);
                ((FissionReactor)this.getMultiblock()).activeReflectorCache.addAll((LongCollection)this.getActiveReflectorCache());
            }
        }
    }

    default public void defaultRefreshModerators(Long2ObjectMap<IFissionComponent> componentFailCache, Long2ObjectMap<IFissionComponent> assumedValidCache) {
        if (this.isFunctional()) {
            this.defaultRefreshAdjacentActiveModerators(componentFailCache, assumedValidCache);
        }
    }

    default public void defaultRefreshAdjacentActiveModerators(Long2ObjectMap<IFissionComponent> componentFailCache, Long2ObjectMap<IFissionComponent> assumedValidCache) {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            BlockPos adjPos;
            IFissionFluxSink fluxSink = this.getAdjacentFluxSinks()[dir.func_176745_a()];
            if (fluxSink == null || !fluxSink.isFunctional() || !((FissionReactor)this.getMultiblock()).passiveModeratorCache.contains((adjPos = this.getTilePos().func_177972_a(dir)).func_177986_g())) continue;
            IFissionFuelComponent.addToModeratorCache(this.getModeratorBlockInfo(adjPos, dir, this.canSupportActiveModerator(true)), ((FissionReactor)this.getMultiblock()).activeModeratorCache, ((FissionReactor)this.getMultiblock()).passiveModeratorCache, componentFailCache, assumedValidCache);
        }
    }

    default public void defaultForceAdjacentActiveModerators(Long2ObjectMap<IFissionComponent> componentFailCache, Long2ObjectMap<IFissionComponent> assumedValidCache) {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            ModeratorBlockInfo info = this.getModeratorBlockInfo(this.getTilePos().func_177972_a(dir), dir, true);
            if (info == null) continue;
            IFissionFuelComponent.addToModeratorCache(info, ((FissionReactor)this.getMultiblock()).activeModeratorCache, ((FissionReactor)this.getMultiblock()).passiveModeratorCache, componentFailCache, assumedValidCache);
        }
    }

    public static class ModeratorBlockInfo {
        public final long posLong;
        public final IFissionComponent component;
        public final boolean blockingFlux;
        public boolean validActiveModeratorPos;
        public final long fluxFactor;
        public final double efficiency;

        public ModeratorBlockInfo(BlockPos pos, IFissionComponent component, boolean blockingFlux, boolean validActiveModeratorPos, long fluxFactor, double efficiency) {
            this.posLong = pos.func_177986_g();
            this.component = component;
            this.blockingFlux = blockingFlux;
            this.validActiveModeratorPos = validActiveModeratorPos;
            this.fluxFactor = fluxFactor;
            this.efficiency = efficiency;
        }

        public void updateModeratorPosValidity(boolean validActiveModeratorPosIn) {
            this.validActiveModeratorPos |= validActiveModeratorPosIn;
        }
    }

    public static class ModeratorLine {
        public final ObjectList<ModeratorBlockInfo> info;
        public final IFissionFuelComponent fuelComponent;
        public IFissionFluxSink fluxSink = null;
        public BasicRecipe reflectorRecipe = null;
        public long flux = 0L;

        public ModeratorLine(ObjectList<ModeratorBlockInfo> info, IFissionFuelComponent fuelComponent) {
            this.info = new ObjectArrayList(info);
            this.fuelComponent = fuelComponent;
        }

        public boolean hasValidEndpoint() {
            return this.fluxSink != null && this.fluxSink.isFunctional() || this.reflectorRecipe != null;
        }
    }
}

