/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.fission.tile;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Iterator;
import javax.annotation.Nullable;
import nc.multiblock.fission.FissionCluster;
import nc.multiblock.fission.FissionReactor;
import nc.multiblock.fission.tile.IFissionFuelComponent;
import nc.multiblock.fission.tile.IFissionPart;
import nc.multiblock.fission.tile.TileFissionPart;
import nc.util.Lang;
import nc.util.NBTHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public interface IFissionComponent
extends IFissionPart {
    @Nullable
    public FissionCluster getCluster();

    default public FissionCluster newCluster(int id) {
        return new FissionCluster((FissionReactor)this.getMultiblock(), id);
    }

    default public void setCluster(@Nullable FissionCluster cluster) {
        if ((cluster != null || this.getCluster() == null) && cluster != null) {
            cluster.getComponentMap().put(this.getTilePos().func_177986_g(), (Object)this);
        }
        this.setClusterInternal(cluster);
    }

    public void setClusterInternal(@Nullable FissionCluster var1);

    default public boolean isClusterSearched() {
        return this.getCluster() != null;
    }

    public boolean isValidHeatConductor(Long2ObjectMap<IFissionComponent> var1, Long2ObjectMap<IFissionComponent> var2);

    public boolean isFunctional();

    public void resetStats();

    public boolean isClusterRoot();

    default public void clusterSearch(Integer id, Object2IntMap<IFissionComponent> clusterSearchCache, Long2ObjectMap<IFissionComponent> componentFailCache, Long2ObjectMap<IFissionComponent> assumedValidCache) {
        FissionCluster cluster;
        if (!this.isValidHeatConductor(componentFailCache, assumedValidCache)) {
            return;
        }
        if (this.isClusterSearched()) {
            if (id != null) {
                ((FissionReactor)this.getMultiblock()).mergeClusters(id, this.getCluster());
            }
            return;
        }
        if (id == null) {
            id = ((FissionReactor)this.getMultiblock()).clusterCount++;
        }
        if ((cluster = (FissionCluster)((FissionReactor)this.getMultiblock()).getClusterMap().get(id.intValue())) == null) {
            cluster = this.newCluster(id);
            ((FissionReactor)this.getMultiblock()).getClusterMap().put(id.intValue(), (Object)cluster);
        }
        this.setCluster(cluster);
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            TileEntity part;
            BlockPos offPos = this.getTilePos().func_177972_a(dir);
            if (!this.getCluster().connectedToWall && (part = this.getTileWorld().func_175625_s(offPos)) instanceof TileFissionPart && ((TileFissionPart)part).getPartPositionType().isGoodForWall()) {
                this.getCluster().connectedToWall = true;
                continue;
            }
            IFissionComponent component = (IFissionComponent)((FissionReactor)this.getMultiblock()).getPartMap(IFissionComponent.class).get(offPos.func_177986_g());
            if (component == null) continue;
            clusterSearchCache.put((Object)component, (Object)id);
        }
    }

    public long getHeatStored();

    public void setHeatStored(long var1);

    public void onClusterMeltdown(Iterator<IFissionComponent> var1);

    public boolean isNullifyingSources(EnumFacing var1);

    default public IFissionFuelComponent.ModeratorBlockInfo getModeratorBlockInfo(EnumFacing dir, boolean validActiveModeratorPos) {
        return null;
    }

    default public void onAddedToModeratorCache(IFissionFuelComponent.ModeratorBlockInfo thisInfo) {
    }

    default public void onModeratorLineComplete(IFissionFuelComponent.ModeratorLine line, IFissionFuelComponent.ModeratorBlockInfo thisInfo, EnumFacing dir) {
    }

    default public boolean isActiveModerator() {
        return false;
    }

    @Override
    default public boolean onUseMultitool(ItemStack multitool, EntityPlayer player, World world, EnumFacing facing, float hitX, float hitY, float hitZ) {
        NBTTagCompound nbt;
        if (player.func_70093_af() && (nbt = NBTHelper.getStackNBT(multitool)) != null) {
            nbt.func_74772_a("componentPos", this.getTilePos().func_177986_g());
            player.func_145747_a((ITextComponent)new TextComponentString(Lang.localise("info.nuclearcraft.multitool.copy_component_info")));
            return true;
        }
        return IFissionPart.super.onUseMultitool(multitool, player, world, facing, hitX, hitY, hitZ);
    }
}

