/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.battery;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import javax.annotation.Nonnull;
import nc.multiblock.Multiblock;
import nc.multiblock.battery.tile.TileBattery;
import nc.multiblock.tile.TileBeefAbstract;
import nc.tile.internal.energy.EnergyStorage;
import nc.util.NCMath;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BatteryMultiblock
extends Multiblock<BatteryMultiblock, TileBattery> {
    public static final ObjectSet<Class<? extends TileBattery>> PART_CLASSES = new ObjectOpenHashSet();
    protected final Multiblock.PartSuperMap<BatteryMultiblock, TileBattery> partSuperMap = new Multiblock.PartSuperMap();
    @Nonnull
    protected final EnergyStorage storage = new EnergyStorage(1L);
    protected int comparatorStrength = 0;
    protected boolean refreshEnergy = false;

    public BatteryMultiblock(World world) {
        super(world, BatteryMultiblock.class, TileBattery.class);
        for (Class clazz : PART_CLASSES) {
            this.partSuperMap.equip(clazz);
        }
    }

    @Override
    public Multiblock.PartSuperMap<BatteryMultiblock, TileBattery> getPartSuperMap() {
        return this.partSuperMap;
    }

    @Nonnull
    public EnergyStorage getEnergyStorage() {
        return this.storage;
    }

    @Override
    public void onAttachedPartWithMultiblockData(TileBattery part, NBTTagCompound data) {
        this.syncDataFrom(data, TileBeefAbstract.SyncReason.FullSync);
    }

    @Override
    protected void onBlockAdded(TileBattery newPart) {
        this.onPartAdded(newPart);
    }

    @Override
    protected void onBlockRemoved(TileBattery oldPart) {
        this.onPartRemoved(oldPart);
    }

    @Override
    protected void onMachineAssembled() {
        this.onMultiblockFormed();
    }

    @Override
    protected void onMachineRestored() {
        this.onMultiblockFormed();
    }

    protected void onMultiblockFormed() {
        if (!this.WORLD.field_72995_K) {
            long capacity = 0L;
            for (TileBattery battery : this.getParts(TileBattery.class)) {
                capacity += battery.capacity;
                battery.onMultiblockRefresh();
            }
            this.storage.setStorageCapacity(capacity);
            this.storage.setMaxTransfer(NCMath.toInt(capacity));
            this.refreshEnergy = true;
        }
    }

    @Override
    protected void onMachinePaused() {
    }

    @Override
    protected void onMachineDisassembled() {
    }

    @Override
    protected int getMinimumNumberOfBlocksForAssembledMachine() {
        return 1;
    }

    @Override
    protected int getMaximumXSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected int getMaximumZSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected int getMaximumYSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected boolean isMachineWhole() {
        return true;
    }

    @Override
    protected void onAssimilate(BatteryMultiblock assimilated) {
        this.storage.mergeEnergyStorage(assimilated.storage);
    }

    @Override
    protected void onAssimilated(BatteryMultiblock assimilator) {
    }

    @Override
    protected boolean updateServer() {
        if (this.refreshEnergy) {
            this.storage.cullEnergyStored();
            this.refreshEnergy = false;
        }
        boolean shouldUpdate = false;
        int compStrength = this.getComparatorStrength();
        if (this.comparatorStrength != compStrength) {
            shouldUpdate = true;
        }
        this.comparatorStrength = compStrength;
        if (shouldUpdate) {
            for (TileBattery battery : this.getParts(TileBattery.class)) {
                battery.func_70296_d();
                battery.updateComparatorOutputLevel();
            }
        }
        return shouldUpdate;
    }

    public int getComparatorStrength() {
        return NCMath.getComparatorSignal(this.storage.getEnergyStoredLong(), this.storage.getMaxEnergyStoredLong(), 0.0);
    }

    @Override
    protected void updateClient() {
    }

    @Override
    protected boolean isBlockGoodForInterior(World world, BlockPos pos) {
        return true;
    }

    @Override
    public void syncDataFrom(NBTTagCompound data, TileBeefAbstract.SyncReason syncReason) {
        this.readEnergy(this.storage, data, "energyStorage");
        this.comparatorStrength = data.func_74762_e("comparatorStrength");
    }

    @Override
    public void syncDataTo(NBTTagCompound data, TileBeefAbstract.SyncReason syncReason) {
        this.writeEnergy(this.storage, data, "energyStorage");
        data.func_74768_a("comparatorStrength", this.comparatorStrength);
    }
}

