/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock;

import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectOpenHashMap;
import nc.multiblock.PropertyBlockFacing;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public final class BlockFacing {
    public static final BlockFacing NONE;
    public static final BlockFacing ALL;
    public static final BlockFacing DOWN;
    public static final BlockFacing UP;
    public static final BlockFacing NORTH;
    public static final BlockFacing SOUTH;
    public static final BlockFacing WEST;
    public static final BlockFacing EAST;
    public static final PropertyBool FACING_DOWN;
    public static final PropertyBool FACING_UP;
    public static final PropertyBool FACING_WEST;
    public static final PropertyBool FACING_EAST;
    public static final PropertyBool FACING_NORTH;
    public static final PropertyBool FACING_SOUTH;
    private final byte _value;
    private static final Byte2ObjectMap<BlockFacing> CACHE;

    public boolean isSet(EnumFacing facing) {
        return 0 != (this._value & 1 << facing.func_176745_a());
    }

    public boolean none() {
        return 0 == this._value;
    }

    public boolean all() {
        return 63 == this._value;
    }

    public boolean down() {
        return this.isSet(EnumFacing.DOWN);
    }

    public boolean up() {
        return this.isSet(EnumFacing.UP);
    }

    public boolean north() {
        return this.isSet(EnumFacing.NORTH);
    }

    public boolean south() {
        return this.isSet(EnumFacing.SOUTH);
    }

    public boolean west() {
        return this.isSet(EnumFacing.WEST);
    }

    public boolean east() {
        return this.isSet(EnumFacing.EAST);
    }

    public IBlockState toBlockState(IBlockState state) {
        return state.func_177226_a((IProperty)FACING_DOWN, (Comparable)Boolean.valueOf(this.isSet(EnumFacing.DOWN))).func_177226_a((IProperty)FACING_UP, (Comparable)Boolean.valueOf(this.isSet(EnumFacing.UP))).func_177226_a((IProperty)FACING_WEST, (Comparable)Boolean.valueOf(this.isSet(EnumFacing.WEST))).func_177226_a((IProperty)FACING_EAST, (Comparable)Boolean.valueOf(this.isSet(EnumFacing.EAST))).func_177226_a((IProperty)FACING_NORTH, (Comparable)Boolean.valueOf(this.isSet(EnumFacing.NORTH))).func_177226_a((IProperty)FACING_SOUTH, (Comparable)Boolean.valueOf(this.isSet(EnumFacing.SOUTH)));
    }

    public BlockFacing set(EnumFacing facing, boolean value) {
        byte newHash = this._value;
        newHash = value ? (byte)(newHash | 1 << facing.func_176745_a()) : (byte)(newHash & ~(1 << facing.func_176745_a()));
        return BlockFacing.from(newHash);
    }

    public int countFacesIf(boolean areSet) {
        int checkFor = areSet ? 1 : 0;
        int mask = this._value;
        int faces = 0;
        int i = 0;
        while (i < 6) {
            if ((mask & 1) == checkFor) {
                ++faces;
            }
            ++i;
            mask >>>= 1;
        }
        return faces;
    }

    public PropertyBlockFacing toProperty() {
        PropertyBlockFacing[] values;
        for (PropertyBlockFacing value : values = PropertyBlockFacing.values()) {
            if (value._hash != this._value) continue;
            return value;
        }
        return PropertyBlockFacing.None;
    }

    public BlockPos offsetBlockPos(BlockPos originalPosition) {
        int x = 0;
        int y = 0;
        int z = 0;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (!this.isSet(facing)) continue;
            x += facing.func_82601_c();
            y += facing.func_96559_d();
            z += facing.func_82599_e();
        }
        return originalPosition.func_177982_a(x, y, z);
    }

    public EnumFacing firstIf(boolean isSet) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (isSet != this.isSet(facing)) continue;
            return facing;
        }
        return null;
    }

    public static BlockFacing from(boolean down, boolean up, boolean north, boolean south, boolean west, boolean east) {
        return BlockFacing.from(BlockFacing.computeHash(down, up, north, south, west, east));
    }

    public static BlockFacing from(boolean[] facings) {
        return BlockFacing.from(BlockFacing.computeHash(facings));
    }

    public String toString() {
        return String.format("Facings: %s%s%s%s%s%s", this.isSet(EnumFacing.DOWN) ? "DOWN " : "", this.isSet(EnumFacing.UP) ? "UP " : "", this.isSet(EnumFacing.NORTH) ? "NORTH " : "", this.isSet(EnumFacing.SOUTH) ? "SOUTH " : "", this.isSet(EnumFacing.WEST) ? "WEST " : "", this.isSet(EnumFacing.EAST) ? "EAST " : "");
    }

    static BlockFacing from(byte hash) {
        BlockFacing facings = (BlockFacing)CACHE.get(hash);
        if (null == facings) {
            facings = new BlockFacing(hash);
            CACHE.put(hash, (Object)facings);
        }
        return facings;
    }

    private BlockFacing(byte value) {
        this._value = value;
    }

    static byte computeHash(boolean down, boolean up, boolean north, boolean south, boolean west, boolean east) {
        byte hash = 0;
        if (down) {
            hash = (byte)(hash | 1 << EnumFacing.DOWN.func_176745_a());
        }
        if (up) {
            hash = (byte)(hash | 1 << EnumFacing.UP.func_176745_a());
        }
        if (north) {
            hash = (byte)(hash | 1 << EnumFacing.NORTH.func_176745_a());
        }
        if (south) {
            hash = (byte)(hash | 1 << EnumFacing.SOUTH.func_176745_a());
        }
        if (west) {
            hash = (byte)(hash | 1 << EnumFacing.WEST.func_176745_a());
        }
        if (east) {
            hash = (byte)(hash | 1 << EnumFacing.EAST.func_176745_a());
        }
        return hash;
    }

    static byte computeHash(boolean[] facings) {
        int len;
        byte hash = 0;
        int n = len = null == facings ? -1 : facings.length;
        if (len < 0 || len > EnumFacing.field_82609_l.length) {
            throw new IllegalArgumentException("Invalid length of facings array");
        }
        for (int i = 0; i < len; ++i) {
            if (!facings[i]) continue;
            hash = (byte)(hash | 1 << EnumFacing.field_82609_l[i].func_176745_a());
        }
        return hash;
    }

    static {
        FACING_DOWN = PropertyBool.func_177716_a((String)"downFacing");
        FACING_UP = PropertyBool.func_177716_a((String)"upFacing");
        FACING_WEST = PropertyBool.func_177716_a((String)"westFacing");
        FACING_EAST = PropertyBool.func_177716_a((String)"eastFacing");
        FACING_NORTH = PropertyBool.func_177716_a((String)"northFacing");
        FACING_SOUTH = PropertyBool.func_177716_a((String)"southFacing");
        CACHE = new Byte2ObjectOpenHashMap();
        byte hash = BlockFacing.computeHash(false, false, false, false, false, false);
        NONE = new BlockFacing(hash);
        CACHE.put(hash, (Object)NONE);
        hash = BlockFacing.computeHash(true, true, true, true, true, true);
        ALL = new BlockFacing(hash);
        CACHE.put(hash, (Object)ALL);
        hash = BlockFacing.computeHash(true, false, false, false, false, false);
        DOWN = new BlockFacing(hash);
        CACHE.put(hash, (Object)DOWN);
        hash = BlockFacing.computeHash(false, true, false, false, false, false);
        UP = new BlockFacing(hash);
        CACHE.put(hash, (Object)UP);
        hash = BlockFacing.computeHash(false, false, true, false, false, false);
        NORTH = new BlockFacing(hash);
        CACHE.put(hash, (Object)NORTH);
        hash = BlockFacing.computeHash(false, false, false, true, false, false);
        SOUTH = new BlockFacing(hash);
        CACHE.put(hash, (Object)SOUTH);
        hash = BlockFacing.computeHash(false, false, false, false, true, false);
        WEST = new BlockFacing(hash);
        CACHE.put(hash, (Object)WEST);
        hash = BlockFacing.computeHash(false, false, false, false, false, true);
        EAST = new BlockFacing(hash);
        CACHE.put(hash, (Object)EAST);
    }
}

