/*
 * Decompiled with CFR 0.152.
 */
package nc.model;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.IFluidBlock;
import org.apache.commons.lang3.tuple.Pair;

public final class ModelTexturedFluid
implements IModel {
    public static final ModelTexturedFluid WATER = new ModelTexturedFluid(new ResourceLocation("blocks/water_still"), new ResourceLocation("blocks/water_flow"));
    protected final ResourceLocation still;
    protected final ResourceLocation flowing;

    public ModelTexturedFluid(ResourceLocation still, ResourceLocation flowing) {
        this.still = still;
        this.flowing = flowing;
    }

    public Collection<ResourceLocation> getTextures() {
        return ImmutableSet.of((Object)this.still, (Object)this.flowing);
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableMap map = PerspectiveMapWrapper.getTransforms((IModelState)state);
        return new BakedFluidTextured(state.apply(Optional.empty()), (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)map, format, bakedTextureGetter.apply(this.still), bakedTextureGetter.apply(this.flowing), Optional.empty());
    }

    public IModelState getDefaultState() {
        return ModelRotation.X0_Y0;
    }

    public IModel retexture(ImmutableMap<String, String> textures) {
        ResourceLocation stillTexture = this.still;
        ResourceLocation flowingTexture = this.flowing;
        if (textures.containsKey((Object)"still")) {
            stillTexture = new ResourceLocation((String)textures.get((Object)"still"));
        }
        if (textures.containsKey((Object)"flowing")) {
            flowingTexture = new ResourceLocation((String)textures.get((Object)"flowing"));
        }
        return new ModelTexturedFluid(stillTexture, flowingTexture);
    }

    protected static final class BakedFluidTextured
    implements IBakedModel {
        protected static final int[] X = new int[]{0, 0, 1, 1};
        protected static final int[] Z = new int[]{0, 1, 1, 0};
        protected static final float eps = 0.001f;
        protected final LoadingCache<Long, BakedFluidTextured> modelCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<Long, BakedFluidTextured>(){

            public BakedFluidTextured load(Long key) throws Exception {
                int opacity = (int)(key & 0x3FFL);
                boolean gas = ((key = Long.valueOf(key >>> 10)) & 1L) != 0L;
                key = key >>> 1;
                boolean statePresent = (key & 1L) != 0L;
                key = key >>> 1;
                int[] cornerRound = new int[4];
                for (int i = 0; i < 4; ++i) {
                    cornerRound[i] = (int)(key & 0x3FFL);
                    key = key >>> 10;
                }
                int flowRound = (int)(key & 0x7FFL) - 1024;
                return new BakedFluidTextured(transformation, transforms, format, opacity, still, flowing, gas, statePresent, cornerRound, flowRound);
            }
        });
        protected final Optional<TRSRTransformation> transformation;
        protected final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
        protected final VertexFormat format;
        protected final TextureAtlasSprite still;
        protected final TextureAtlasSprite flowing;
        protected final EnumMap<EnumFacing, List<BakedQuad>> faceQuads;

        public BakedFluidTextured(Optional<TRSRTransformation> transformation, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, VertexFormat format, TextureAtlasSprite still, TextureAtlasSprite flowing, Optional<IExtendedBlockState> stateOption) {
            this(transformation, transforms, format, 255, still, flowing, false, stateOption.isPresent(), BakedFluidTextured.getCorners(stateOption), BakedFluidTextured.getFlow(stateOption));
        }

        private static int[] getCorners(Optional<IExtendedBlockState> stateOption) {
            int[] cornerRound = new int[]{0, 0, 0, 0};
            if (stateOption.isPresent()) {
                IExtendedBlockState state = stateOption.get();
                for (int i = 0; i < 4; ++i) {
                    Float level = (Float)state.getValue((IUnlistedProperty)BlockFluidBase.LEVEL_CORNERS[i]);
                    cornerRound[i] = Math.round((level == null ? 0.875f : level.floatValue()) * 768.0f);
                }
            }
            return cornerRound;
        }

        protected static int getFlow(Optional<IExtendedBlockState> stateOption) {
            Float flow = Float.valueOf(-1000.0f);
            if (stateOption.isPresent() && (flow = (Float)stateOption.get().getValue((IUnlistedProperty)BlockFluidBase.FLOW_DIRECTION)) == null) {
                flow = Float.valueOf(-1000.0f);
            }
            int flowRound = (int)Math.round(Math.toDegrees(flow.floatValue()));
            flowRound = MathHelper.func_76125_a((int)flowRound, (int)-1000, (int)1000);
            return flowRound;
        }

        public BakedFluidTextured(Optional<TRSRTransformation> transformation, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, VertexFormat format, int opacity, TextureAtlasSprite still, TextureAtlasSprite flowing, boolean gas, boolean statePresent, int[] cornerRound, int flowRound) {
            int i;
            this.transformation = transformation;
            this.transforms = transforms;
            this.format = format;
            this.still = still;
            this.flowing = flowing;
            this.faceQuads = Maps.newEnumMap(EnumFacing.class);
            for (EnumFacing side : EnumFacing.field_82609_l) {
                this.faceQuads.put(side, (List<BakedQuad>)ImmutableList.of());
            }
            if (statePresent) {
                int i2;
                UnpackedBakedQuad.Builder builder;
                float[] y = new float[4];
                for (i = 0; i < 4; ++i) {
                    y[i] = gas ? 1.0f - (float)cornerRound[i] / 768.0f : (float)cornerRound[i] / 768.0f;
                }
                float flow = (float)Math.toRadians(flowRound);
                TextureAtlasSprite topSprite = flowing;
                float scale = 4.0f;
                if (flow < -17.0f) {
                    flow = 0.0f;
                    scale = 8.0f;
                    topSprite = still;
                }
                float c = MathHelper.func_76134_b((float)flow) * scale;
                float s = MathHelper.func_76126_a((float)flow) * scale;
                EnumFacing side = gas ? EnumFacing.DOWN : EnumFacing.UP;
                ImmutableList.Builder topFaceBuilder = ImmutableList.builder();
                for (int k = 0; k < 2; ++k) {
                    builder = new UnpackedBakedQuad.Builder(format);
                    builder.setQuadOrientation(side);
                    builder.setTexture(topSprite);
                    builder.setQuadTint(0);
                    for (int i3 = gas ? 3 : 0; i3 != (gas ? -1 : 4); i3 += gas ? -1 : 1) {
                        int l = k * 3 + (1 - 2 * k) * i3;
                        this.putVertex(builder, side, X[l], y[l], Z[l], topSprite.func_94214_a((double)(8.0f + c * (float)(X[l] * 2 - 1) + s * (float)(Z[l] * 2 - 1))), topSprite.func_94207_b((double)(8.0f + c * (float)(X[(l + 1) % 4] * 2 - 1) + s * (float)(Z[(l + 1) % 4] * 2 - 1))), opacity);
                    }
                    topFaceBuilder.add((Object)builder.build());
                }
                this.faceQuads.put(side, (List<BakedQuad>)topFaceBuilder.build());
                side = side.func_176734_d();
                builder = new UnpackedBakedQuad.Builder(format);
                builder.setQuadOrientation(side);
                builder.setTexture(still);
                builder.setQuadTint(0);
                for (i2 = gas ? 3 : 0; i2 != (gas ? -1 : 4); i2 += gas ? -1 : 1) {
                    this.putVertex(builder, side, Z[i2], gas ? 1.0f : 0.0f, X[i2], still.func_94214_a((double)(Z[i2] * 16)), still.func_94207_b((double)(X[i2] * 16)), opacity);
                }
                this.faceQuads.put(side, (List<BakedQuad>)ImmutableList.of((Object)builder.build()));
                for (i2 = 0; i2 < 4; ++i2) {
                    side = EnumFacing.func_176731_b((int)((5 - i2) % 4));
                    BakedQuad[] q = new BakedQuad[2];
                    for (int k = 0; k < 2; ++k) {
                        builder = new UnpackedBakedQuad.Builder(format);
                        builder.setQuadOrientation(side);
                        builder.setTexture(flowing);
                        builder.setQuadTint(0);
                        for (int j = 0; j < 4; ++j) {
                            int l = k * 3 + (1 - 2 * k) * j;
                            float yl = (float)Z[l] * y[(i2 + X[l]) % 4];
                            if (gas && Z[l] == 0) {
                                yl = 1.0f;
                            }
                            this.putVertex(builder, side, X[(i2 + X[l]) % 4], yl, Z[(i2 + X[l]) % 4], flowing.func_94214_a((double)(X[l] * 8)), flowing.func_94207_b((double)((gas ? yl : 1.0f - yl) * 8.0f)), opacity);
                        }
                        q[k] = builder.build();
                    }
                    this.faceQuads.put(side, (List<BakedQuad>)ImmutableList.of((Object)q[0], (Object)q[1]));
                }
            } else {
                UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(format);
                builder.setQuadOrientation(EnumFacing.UP);
                builder.setTexture(still);
                builder.setQuadTint(0);
                for (i = 0; i < 4; ++i) {
                    this.putVertex(builder, EnumFacing.UP, Z[i], X[i], 0.0f, still.func_94214_a((double)(Z[i] * 16)), still.func_94207_b((double)(X[i] * 16)), opacity);
                }
                this.faceQuads.put(EnumFacing.SOUTH, (List<BakedQuad>)ImmutableList.of((Object)builder.build()));
            }
        }

        protected void putVertex(UnpackedBakedQuad.Builder builder, EnumFacing side, float x, float y, float z, float u, float v, int opacity) {
            block6: for (int e = 0; e < this.format.func_177345_h(); ++e) {
                switch (this.format.func_177348_c(e).func_177375_c()) {
                    case POSITION: {
                        float[] data = new float[]{x - (float)side.func_176730_m().func_177958_n() * 0.001f, y, z - (float)side.func_176730_m().func_177952_p() * 0.001f, 1.0f};
                        if (this.transformation.isPresent() && this.transformation.get() != TRSRTransformation.identity()) {
                            Vector4f vec = new Vector4f(data);
                            this.transformation.get().getMatrix().transform((Tuple4f)vec);
                            vec.get(data);
                        }
                        builder.put(e, data);
                        continue block6;
                    }
                    case COLOR: {
                        builder.put(e, new float[]{1.0f, 1.0f, 1.0f, (float)opacity / 255.0f});
                        continue block6;
                    }
                    case UV: {
                        if (this.format.func_177348_c(e).func_177369_e() == 0) {
                            builder.put(e, new float[]{u, v, 0.0f, 1.0f});
                            continue block6;
                        }
                    }
                    case NORMAL: {
                        builder.put(e, new float[]{side.func_82601_c(), side.func_96559_d(), side.func_82599_e(), 0.0f});
                        continue block6;
                    }
                    default: {
                        builder.put(e, new float[0]);
                    }
                }
            }
        }

        public boolean func_177555_b() {
            return true;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.still;
        }

        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            BakedFluidTextured model = this;
            if (state instanceof IExtendedBlockState) {
                IExtendedBlockState exState = (IExtendedBlockState)state;
                int[] cornerRound = BakedFluidTextured.getCorners(Optional.of(exState));
                int flowRound = BakedFluidTextured.getFlow(Optional.of(exState));
                long key = flowRound + 1024;
                for (int i = 3; i >= 0; --i) {
                    key <<= 10;
                    key |= (long)cornerRound[i];
                }
                key <<= 1;
                key |= 1L;
                Fluid fluid = ((IFluidBlock)state.func_177230_c()).getFluid();
                key <<= 1;
                key |= fluid.isGaseous() ? 1L : 0L;
                key <<= 10;
                model = (BakedFluidTextured)this.modelCache.getUnchecked((Object)(key |= (long)(fluid.getColor() >>> 24)));
            }
            if (side == null) {
                return ImmutableList.of();
            }
            return model.faceQuads.get(side);
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType type) {
            return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)type);
        }
    }

    public static enum FluidTexturedLoader implements ICustomModelLoader
    {
        INSTANCE;


        public void func_110549_a(IResourceManager resourceManager) {
        }

        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.func_110624_b().equals("nuclearcraft") && (modelLocation.func_110623_a().equals("fluid") || modelLocation.func_110623_a().equals("models/block/fluid") || modelLocation.func_110623_a().equals("models/item/fluid"));
        }

        public IModel loadModel(ResourceLocation modelLocation) {
            return WATER;
        }
    }
}

