/*
 * Decompiled with CFR 0.152.
 */
package nc.integration.jei;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferRegistry;
import nc.ModCheck;
import nc.config.NCConfig;
import nc.container.processor.ContainerAlloyFurnace;
import nc.container.processor.ContainerAssembler;
import nc.container.processor.ContainerCentrifuge;
import nc.container.processor.ContainerChemicalReactor;
import nc.container.processor.ContainerCrystallizer;
import nc.container.processor.ContainerDecayHastener;
import nc.container.processor.ContainerElectrolyzer;
import nc.container.processor.ContainerEnricher;
import nc.container.processor.ContainerExtractor;
import nc.container.processor.ContainerFuelReprocessor;
import nc.container.processor.ContainerInfuser;
import nc.container.processor.ContainerIngotFormer;
import nc.container.processor.ContainerManufactory;
import nc.container.processor.ContainerMelter;
import nc.container.processor.ContainerPressurizer;
import nc.container.processor.ContainerRockCrusher;
import nc.container.processor.ContainerSaltMixer;
import nc.container.processor.ContainerSeparator;
import nc.container.processor.ContainerSupercooler;
import nc.enumm.MetaEnums;
import nc.gui.processor.GuiAlloyFurnace;
import nc.gui.processor.GuiAssembler;
import nc.gui.processor.GuiCentrifuge;
import nc.gui.processor.GuiChemicalReactor;
import nc.gui.processor.GuiCrystallizer;
import nc.gui.processor.GuiDecayHastener;
import nc.gui.processor.GuiElectrolyzer;
import nc.gui.processor.GuiEnricher;
import nc.gui.processor.GuiExtractor;
import nc.gui.processor.GuiFuelReprocessor;
import nc.gui.processor.GuiInfuser;
import nc.gui.processor.GuiIngotFormer;
import nc.gui.processor.GuiManufactory;
import nc.gui.processor.GuiMelter;
import nc.gui.processor.GuiPressurizer;
import nc.gui.processor.GuiRockCrusher;
import nc.gui.processor.GuiSaltMixer;
import nc.gui.processor.GuiSeparator;
import nc.gui.processor.GuiSupercooler;
import nc.init.NCArmor;
import nc.init.NCBlocks;
import nc.init.NCItems;
import nc.integration.jei.JEIBasicCategory;
import nc.integration.jei.JEIBasicRecipeWrapper;
import nc.integration.jei.JEIHelper;
import nc.integration.jei.JEIRecipeWrapper;
import nc.integration.jei.generator.DecayGeneratorCategory;
import nc.integration.jei.multiblock.CondenserCategory;
import nc.integration.jei.multiblock.CoolantHeaterCategory;
import nc.integration.jei.multiblock.FissionEmergencyCoolingCategory;
import nc.integration.jei.multiblock.FissionHeatingCategory;
import nc.integration.jei.multiblock.FissionIrradiatorCategory;
import nc.integration.jei.multiblock.FissionModeratorCategory;
import nc.integration.jei.multiblock.FissionReflectorCategory;
import nc.integration.jei.multiblock.HeatExchangerCategory;
import nc.integration.jei.multiblock.PebbleFissionCategory;
import nc.integration.jei.multiblock.SaltFissionCategory;
import nc.integration.jei.multiblock.SolidFissionCategory;
import nc.integration.jei.multiblock.TurbineCategory;
import nc.integration.jei.other.CollectorCategory;
import nc.integration.jei.other.RadiationScrubberCategory;
import nc.integration.jei.processor.AlloyFurnaceCategory;
import nc.integration.jei.processor.AssemblerCategory;
import nc.integration.jei.processor.CentrifugeCategory;
import nc.integration.jei.processor.ChemicalReactorCategory;
import nc.integration.jei.processor.CrystallizerCategory;
import nc.integration.jei.processor.DecayHastenerCategory;
import nc.integration.jei.processor.ElectrolyzerCategory;
import nc.integration.jei.processor.EnricherCategory;
import nc.integration.jei.processor.ExtractorCategory;
import nc.integration.jei.processor.FuelReprocessorCategory;
import nc.integration.jei.processor.InfuserCategory;
import nc.integration.jei.processor.IngotFormerCategory;
import nc.integration.jei.processor.ManufactoryCategory;
import nc.integration.jei.processor.MelterCategory;
import nc.integration.jei.processor.PressurizerCategory;
import nc.integration.jei.processor.RockCrusherCategory;
import nc.integration.jei.processor.SaltMixerCategory;
import nc.integration.jei.processor.SeparatorCategory;
import nc.integration.jei.processor.SupercoolerCategory;
import nc.multiblock.container.ContainerFissionIrradiator;
import nc.multiblock.container.ContainerSaltFissionHeater;
import nc.multiblock.container.ContainerSaltFissionVessel;
import nc.multiblock.container.ContainerSolidFissionCell;
import nc.multiblock.fission.FissionPlacement;
import nc.multiblock.gui.GuiFissionIrradiator;
import nc.multiblock.gui.GuiSaltFissionHeater;
import nc.multiblock.gui.GuiSaltFissionVessel;
import nc.multiblock.gui.GuiSolidFissionCell;
import nc.recipe.BasicRecipe;
import nc.recipe.BasicRecipeHandler;
import nc.recipe.NCRecipes;
import nc.recipe.ingredient.IItemIngredient;
import nc.util.NCUtil;
import nc.util.StackHelper;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@JEIPlugin
public class NCJEI
implements IModPlugin {
    public void register(IModRegistry registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        for (JEIHandler handler : JEIHandler.values()) {
            if (!handler.getEnabled()) continue;
            registry.addRecipes(handler.getJEIRecipes(guiHelper));
            JEIBasicCategory<?> category = handler.getCategory(guiHelper);
            registry.addRecipeCategories(new IRecipeCategory[]{category});
            registry.addRecipeHandlers(new IRecipeHandler[]{category});
            if (handler.getCrafters() == null) continue;
            for (ItemStack crafter : handler.getCrafters()) {
                if (crafter == null) continue;
                registry.addRecipeCatalyst((Object)crafter, new String[]{handler.getUid()});
            }
        }
        IRecipeTransferRegistry recipeTransferRegistry = registry.getRecipeTransferRegistry();
        if (NCConfig.register_processor[1]) {
            registry.addRecipeClickArea(GuiManufactory.class, 73, 34, 37, 18, new String[]{JEIHandler.MANUFACTORY.getUid()});
            registry.addRecipeClickArea(GuiManufactory.SideConfig.class, 73, 34, 37, 18, new String[]{JEIHandler.MANUFACTORY.getUid()});
        }
        if (NCConfig.register_processor[2]) {
            registry.addRecipeClickArea(GuiSeparator.class, 59, 34, 37, 18, new String[]{JEIHandler.SEPARATOR.getUid()});
            registry.addRecipeClickArea(GuiSeparator.SideConfig.class, 59, 34, 37, 18, new String[]{JEIHandler.SEPARATOR.getUid()});
        }
        if (NCConfig.register_processor[3]) {
            registry.addRecipeClickArea(GuiDecayHastener.class, 73, 34, 37, 18, new String[]{JEIHandler.DECAY_HASTENER.getUid()});
            registry.addRecipeClickArea(GuiDecayHastener.SideConfig.class, 73, 34, 37, 18, new String[]{JEIHandler.DECAY_HASTENER.getUid()});
        }
        if (NCConfig.register_processor[4]) {
            registry.addRecipeClickArea(GuiFuelReprocessor.class, 47, 30, 37, 38, new String[]{JEIHandler.FUEL_REPROCESSOR.getUid()});
            registry.addRecipeClickArea(GuiFuelReprocessor.SideConfig.class, 47, 30, 37, 38, new String[]{JEIHandler.FUEL_REPROCESSOR.getUid()});
        }
        if (NCConfig.register_processor[5]) {
            registry.addRecipeClickArea(GuiAlloyFurnace.class, 83, 34, 37, 18, new String[]{JEIHandler.ALLOY_FURNACE.getUid()});
            registry.addRecipeClickArea(GuiAlloyFurnace.SideConfig.class, 83, 34, 37, 18, new String[]{JEIHandler.ALLOY_FURNACE.getUid()});
        }
        if (NCConfig.register_processor[6]) {
            registry.addRecipeClickArea(GuiInfuser.class, 83, 34, 37, 18, new String[]{JEIHandler.INFUSER.getUid()});
            registry.addRecipeClickArea(GuiInfuser.SideConfig.class, 83, 34, 37, 18, new String[]{JEIHandler.INFUSER.getUid()});
        }
        if (NCConfig.register_processor[7]) {
            registry.addRecipeClickArea(GuiMelter.class, 73, 34, 37, 18, new String[]{JEIHandler.MELTER.getUid()});
            registry.addRecipeClickArea(GuiMelter.SideConfig.class, 73, 34, 37, 18, new String[]{JEIHandler.MELTER.getUid()});
        }
        if (NCConfig.register_processor[8]) {
            registry.addRecipeClickArea(GuiSupercooler.class, 73, 34, 37, 18, new String[]{JEIHandler.SUPERCOOLER.getUid()});
            registry.addRecipeClickArea(GuiSupercooler.SideConfig.class, 73, 34, 37, 18, new String[]{JEIHandler.SUPERCOOLER.getUid()});
        }
        if (NCConfig.register_processor[9]) {
            registry.addRecipeClickArea(GuiElectrolyzer.class, 67, 30, 37, 38, new String[]{JEIHandler.ELECTROLYZER.getUid()});
            registry.addRecipeClickArea(GuiElectrolyzer.SideConfig.class, 67, 30, 37, 38, new String[]{JEIHandler.ELECTROLYZER.getUid()});
        }
        if (NCConfig.register_processor[10]) {
            registry.addRecipeClickArea(GuiAssembler.class, 83, 30, 37, 38, new String[]{JEIHandler.ASSEMBLER.getUid()});
            registry.addRecipeClickArea(GuiAssembler.SideConfig.class, 83, 30, 37, 38, new String[]{JEIHandler.ASSEMBLER.getUid()});
        }
        if (NCConfig.register_processor[11]) {
            registry.addRecipeClickArea(GuiIngotFormer.class, 73, 34, 37, 18, new String[]{JEIHandler.INGOT_FORMER.getUid()});
            registry.addRecipeClickArea(GuiIngotFormer.SideConfig.class, 73, 34, 37, 18, new String[]{JEIHandler.INGOT_FORMER.getUid()});
        }
        if (NCConfig.register_processor[12]) {
            registry.addRecipeClickArea(GuiPressurizer.class, 73, 34, 37, 18, new String[]{JEIHandler.PRESSURIZER.getUid()});
            registry.addRecipeClickArea(GuiPressurizer.SideConfig.class, 73, 34, 37, 18, new String[]{JEIHandler.PRESSURIZER.getUid()});
        }
        if (NCConfig.register_processor[13]) {
            registry.addRecipeClickArea(GuiChemicalReactor.class, 69, 34, 37, 18, new String[]{JEIHandler.CHEMICAL_REACTOR.getUid()});
            registry.addRecipeClickArea(GuiChemicalReactor.SideConfig.class, 69, 34, 37, 18, new String[]{JEIHandler.CHEMICAL_REACTOR.getUid()});
        }
        if (NCConfig.register_processor[14]) {
            registry.addRecipeClickArea(GuiSaltMixer.class, 83, 34, 37, 18, new String[]{JEIHandler.SALT_MIXER.getUid()});
            registry.addRecipeClickArea(GuiSaltMixer.SideConfig.class, 83, 34, 37, 18, new String[]{JEIHandler.SALT_MIXER.getUid()});
        }
        if (NCConfig.register_processor[15]) {
            registry.addRecipeClickArea(GuiCrystallizer.class, 73, 34, 37, 18, new String[]{JEIHandler.CRYSTALLIZER.getUid()});
            registry.addRecipeClickArea(GuiCrystallizer.SideConfig.class, 73, 34, 37, 18, new String[]{JEIHandler.CRYSTALLIZER.getUid()});
        }
        if (NCConfig.register_processor[16]) {
            registry.addRecipeClickArea(GuiEnricher.class, 83, 34, 37, 18, new String[]{JEIHandler.ENRICHER.getUid()});
            registry.addRecipeClickArea(GuiEnricher.SideConfig.class, 83, 34, 37, 18, new String[]{JEIHandler.ENRICHER.getUid()});
        }
        if (NCConfig.register_processor[17]) {
            registry.addRecipeClickArea(GuiExtractor.class, 59, 34, 37, 18, new String[]{JEIHandler.EXTRACTOR.getUid()});
            registry.addRecipeClickArea(GuiExtractor.SideConfig.class, 59, 34, 37, 18, new String[]{JEIHandler.EXTRACTOR.getUid()});
        }
        if (NCConfig.register_processor[18]) {
            registry.addRecipeClickArea(GuiCentrifuge.class, 57, 30, 37, 38, new String[]{JEIHandler.CENTRIFUGE.getUid()});
            registry.addRecipeClickArea(GuiCentrifuge.SideConfig.class, 57, 30, 37, 38, new String[]{JEIHandler.CENTRIFUGE.getUid()});
        }
        if (NCConfig.register_processor[19]) {
            registry.addRecipeClickArea(GuiRockCrusher.class, 55, 34, 37, 18, new String[]{JEIHandler.ROCK_CRUSHER.getUid()});
            registry.addRecipeClickArea(GuiRockCrusher.SideConfig.class, 55, 34, 37, 18, new String[]{JEIHandler.ROCK_CRUSHER.getUid()});
        }
        registry.addRecipeClickArea(GuiFissionIrradiator.class, 73, 34, 37, 18, new String[]{JEIHandler.FISSION_IRRADIATOR.getUid()});
        registry.addRecipeClickArea(GuiSolidFissionCell.class, 73, 34, 37, 18, new String[]{JEIHandler.SOLID_FISSION.getUid()});
        registry.addRecipeClickArea(GuiSaltFissionVessel.class, 73, 34, 37, 18, new String[]{JEIHandler.SALT_FISSION.getUid()});
        registry.addRecipeClickArea(GuiSaltFissionHeater.class, 73, 34, 37, 18, new String[]{JEIHandler.COOLANT_HEATER.getUid()});
        recipeTransferRegistry.addRecipeTransferHandler(ContainerManufactory.class, JEIHandler.MANUFACTORY.getUid(), 0, 1, 4, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerSeparator.class, JEIHandler.SEPARATOR.getUid(), 0, 1, 5, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerDecayHastener.class, JEIHandler.DECAY_HASTENER.getUid(), 0, 1, 4, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerFuelReprocessor.class, JEIHandler.FUEL_REPROCESSOR.getUid(), 0, 1, 9, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerAlloyFurnace.class, JEIHandler.ALLOY_FURNACE.getUid(), 0, 2, 5, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerInfuser.class, JEIHandler.INFUSER.getUid(), 0, 1, 4, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerMelter.class, JEIHandler.MELTER.getUid(), 0, 1, 3, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerSupercooler.class, JEIHandler.SUPERCOOLER.getUid(), 0, 0, 2, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerElectrolyzer.class, JEIHandler.ELECTROLYZER.getUid(), 0, 0, 2, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerAssembler.class, JEIHandler.ASSEMBLER.getUid(), 0, 4, 7, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerIngotFormer.class, JEIHandler.INGOT_FORMER.getUid(), 0, 0, 3, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerPressurizer.class, JEIHandler.PRESSURIZER.getUid(), 0, 1, 4, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerChemicalReactor.class, JEIHandler.CHEMICAL_REACTOR.getUid(), 0, 0, 2, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerSaltMixer.class, JEIHandler.SALT_MIXER.getUid(), 0, 0, 2, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerCrystallizer.class, JEIHandler.CRYSTALLIZER.getUid(), 0, 0, 3, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerEnricher.class, JEIHandler.ENRICHER.getUid(), 0, 1, 3, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerExtractor.class, JEIHandler.EXTRACTOR.getUid(), 0, 1, 4, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerCentrifuge.class, JEIHandler.CENTRIFUGE.getUid(), 0, 0, 2, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerRockCrusher.class, JEIHandler.ROCK_CRUSHER.getUid(), 0, 1, 6, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerFissionIrradiator.class, JEIHandler.FISSION_IRRADIATOR.getUid(), 0, 1, 2, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerSolidFissionCell.class, JEIHandler.SOLID_FISSION.getUid(), 0, 1, 2, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerSaltFissionVessel.class, JEIHandler.SALT_FISSION.getUid(), 0, 0, 0, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerSaltFissionHeater.class, JEIHandler.COOLANT_HEATER.getUid(), 0, 0, 0, 36);
        for (int i = 0; i < MetaEnums.OreType.values().length; ++i) {
            if (NCConfig.ore_gen[i] || !NCConfig.ore_hide_disabled) continue;
            NCJEI.blacklist(jeiHelpers, new ItemStack(NCBlocks.ore, 1, i), new ItemStack(NCBlocks.ingot_block, 1, i), new ItemStack(NCItems.ingot, 1, i), new ItemStack(NCItems.dust, 1, i));
        }
        if (!ModCheck.openComputersLoaded()) {
            NCJEI.blacklist(jeiHelpers, NCBlocks.fission_computer_port);
            NCJEI.blacklist(jeiHelpers, NCBlocks.heat_exchanger_computer_port);
            NCJEI.blacklist(jeiHelpers, NCBlocks.turbine_computer_port);
        }
        if (!NCConfig.radiation_enabled_public) {
            NCJEI.blacklist(jeiHelpers, NCBlocks.radiation_scrubber);
            NCJEI.blacklist(jeiHelpers, NCBlocks.geiger_block, NCItems.geiger_counter);
            NCJEI.blacklistAll(jeiHelpers, MetaEnums.RadShieldingType.class, NCItems.rad_shielding);
            NCJEI.blacklist(jeiHelpers, NCItems.radiation_badge);
            NCJEI.blacklist(jeiHelpers, NCItems.radaway, NCItems.radaway_slow);
            NCJEI.blacklist(jeiHelpers, NCItems.rad_x);
            if (!ModCheck.ic2Loaded()) {
                NCJEI.blacklist(jeiHelpers, NCArmor.helm_hazmat, NCArmor.chest_hazmat, NCArmor.legs_hazmat, NCArmor.boots_hazmat);
            }
        }
        if (!ModCheck.ic2Loaded()) {
            NCJEI.blacklistAll(jeiHelpers, MetaEnums.IC2DepletedFuelType.class, NCItems.depleted_fuel_ic2);
        }
        NCJEI.blacklist(jeiHelpers, NCItems.foursmore);
        NCUtil.getLogger().info("JEI integration complete!");
    }

    private static void blacklist(IJeiHelpers jeiHelpers, Object ... items) {
        for (Object item : items) {
            if (item == null) {
                return;
            }
            jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)StackHelper.fixItemStack(item));
        }
    }

    private static <T extends Enum<T>> void blacklistAll(IJeiHelpers jeiHelpers, Class<T> enumm, Item item) {
        if (item == null) {
            return;
        }
        for (int i = 0; i < ((Enum[])enumm.getEnumConstants()).length; ++i) {
            NCJEI.blacklist(jeiHelpers, new ItemStack(item, 1, i));
        }
    }

    protected static List<ItemStack> fixStacks(List<?> list) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (Object obj : list) {
            stacks.add(StackHelper.fixItemStack(obj));
        }
        return stacks;
    }

    protected static List<Block> registeredCollectors() {
        ArrayList<Block> list = new ArrayList<Block>();
        if (NCConfig.register_passive[0]) {
            list.add(NCBlocks.cobblestone_generator);
            list.add(NCBlocks.cobblestone_generator_compact);
            list.add(NCBlocks.cobblestone_generator_dense);
        }
        if (NCConfig.register_passive[1]) {
            list.add(NCBlocks.water_source);
            list.add(NCBlocks.water_source_compact);
            list.add(NCBlocks.water_source_dense);
        }
        if (NCConfig.register_passive[2]) {
            list.add(NCBlocks.nitrogen_collector);
            list.add(NCBlocks.nitrogen_collector_compact);
            list.add(NCBlocks.nitrogen_collector_dense);
        }
        return list;
    }

    protected static List<ItemStack> getCoolantHeaters() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (BasicRecipe recipe : FissionPlacement.recipe_handler.getRecipeList()) {
            if (!recipe.getPlacementRuleID().endsWith("_heater")) continue;
            for (IItemIngredient ingredient : recipe.getItemIngredients()) {
                for (ItemStack stack : ingredient.getInputStackList()) {
                    list.add(stack);
                }
            }
        }
        return list;
    }

    public static interface IJEIHandler<WRAPPER extends JEIBasicRecipeWrapper<WRAPPER>> {
        public JEIBasicCategory<?> getCategory(IGuiHelper var1);

        public BasicRecipeHandler getRecipeHandler();

        public Class<WRAPPER> getRecipeWrapperClass();

        public List<WRAPPER> getJEIRecipes(IGuiHelper var1);

        public String getUid();

        public boolean getEnabled();

        public List<ItemStack> getCrafters();

        public String getTextureName();
    }

    public static enum JEIHandler implements IJEIHandler
    {
        MANUFACTORY((BasicRecipeHandler)NCRecipes.manufactory, NCBlocks.manufactory, "manufactory", JEIRecipeWrapper.Manufactory.class, 1),
        SEPARATOR((BasicRecipeHandler)NCRecipes.separator, NCBlocks.separator, "separator", JEIRecipeWrapper.Separator.class, 2),
        DECAY_HASTENER((BasicRecipeHandler)NCRecipes.decay_hastener, NCBlocks.decay_hastener, "decay_hastener", JEIRecipeWrapper.DecayHastener.class, 3),
        FUEL_REPROCESSOR((BasicRecipeHandler)NCRecipes.fuel_reprocessor, NCBlocks.fuel_reprocessor, "fuel_reprocessor", JEIRecipeWrapper.FuelReprocessor.class, 4),
        ALLOY_FURNACE((BasicRecipeHandler)NCRecipes.alloy_furnace, NCBlocks.alloy_furnace, "alloy_furnace", JEIRecipeWrapper.AlloyFurnace.class, 5),
        INFUSER((BasicRecipeHandler)NCRecipes.infuser, NCBlocks.infuser, "infuser", JEIRecipeWrapper.Infuser.class, 6),
        MELTER((BasicRecipeHandler)NCRecipes.melter, NCBlocks.melter, "melter", JEIRecipeWrapper.Melter.class, 7),
        SUPERCOOLER((BasicRecipeHandler)NCRecipes.supercooler, NCBlocks.supercooler, "supercooler", JEIRecipeWrapper.Supercooler.class, 8),
        ELECTROLYZER((BasicRecipeHandler)NCRecipes.electrolyzer, NCBlocks.electrolyzer, "electrolyzer", JEIRecipeWrapper.Electrolyzer.class, 9),
        ASSEMBLER((BasicRecipeHandler)NCRecipes.assembler, NCBlocks.assembler, "assembler", JEIRecipeWrapper.Assembler.class, 10),
        INGOT_FORMER((BasicRecipeHandler)NCRecipes.ingot_former, NCBlocks.ingot_former, "ingot_former", JEIRecipeWrapper.IngotFormer.class, 11),
        PRESSURIZER((BasicRecipeHandler)NCRecipes.pressurizer, NCBlocks.pressurizer, "pressurizer", JEIRecipeWrapper.Pressurizer.class, 12),
        CHEMICAL_REACTOR((BasicRecipeHandler)NCRecipes.chemical_reactor, NCBlocks.chemical_reactor, "chemical_reactor", JEIRecipeWrapper.ChemicalReactor.class, 13),
        SALT_MIXER((BasicRecipeHandler)NCRecipes.salt_mixer, NCBlocks.salt_mixer, "salt_mixer", JEIRecipeWrapper.SaltMixer.class, 14),
        CRYSTALLIZER((BasicRecipeHandler)NCRecipes.crystallizer, NCBlocks.crystallizer, "crystallizer", JEIRecipeWrapper.Crystallizer.class, 15),
        ENRICHER((BasicRecipeHandler)NCRecipes.enricher, NCBlocks.enricher, "enricher", JEIRecipeWrapper.Enricher.class, 16),
        EXTRACTOR((BasicRecipeHandler)NCRecipes.extractor, NCBlocks.extractor, "extractor", JEIRecipeWrapper.Extractor.class, 17),
        CENTRIFUGE((BasicRecipeHandler)NCRecipes.centrifuge, NCBlocks.centrifuge, "centrifuge", JEIRecipeWrapper.Centrifuge.class, 18),
        ROCK_CRUSHER((BasicRecipeHandler)NCRecipes.rock_crusher, NCBlocks.rock_crusher, "rock_crusher", JEIRecipeWrapper.RockCrusher.class, 19),
        COLLECTOR((BasicRecipeHandler)NCRecipes.collector, NCJEI.registeredCollectors(), "collector", JEIRecipeWrapper.Collector.class),
        DECAY_GENERATOR((BasicRecipeHandler)NCRecipes.decay_generator, NCBlocks.decay_generator, "decay_generator", JEIRecipeWrapper.DecayGenerator.class),
        FISSION_MODERATOR((BasicRecipeHandler)NCRecipes.fission_moderator, NCBlocks.heavy_water_moderator, "fission_moderator", JEIRecipeWrapper.FissionModerator.class),
        FISSION_REFLECTOR((BasicRecipeHandler)NCRecipes.fission_reflector, NCBlocks.fission_reflector, "fission_reflector", JEIRecipeWrapper.FissionReflector.class),
        FISSION_IRRADIATOR((BasicRecipeHandler)NCRecipes.fission_irradiator, NCBlocks.fission_irradiator, "fission_irradiator_jei", JEIRecipeWrapper.FissionIrradiator.class),
        PEBBLE_FISSION((BasicRecipeHandler)NCRecipes.pebble_fission, Lists.newArrayList(), "pebble_fission", JEIRecipeWrapper.PebbleFission.class),
        SOLID_FISSION((BasicRecipeHandler)NCRecipes.solid_fission, Lists.newArrayList((Object[])new Block[]{NCBlocks.solid_fission_controller, NCBlocks.solid_fission_cell}), "solid_fission", JEIRecipeWrapper.SolidFission.class),
        FISSION_HEATING((BasicRecipeHandler)NCRecipes.fission_heating, NCBlocks.fission_vent, "fission_heating", JEIRecipeWrapper.FissionHeating.class),
        SALT_FISSION((BasicRecipeHandler)NCRecipes.salt_fission, Lists.newArrayList((Object[])new Block[]{NCBlocks.salt_fission_controller, NCBlocks.salt_fission_vessel}), "salt_fission", JEIRecipeWrapper.SaltFission.class),
        COOLANT_HEATER((BasicRecipeHandler)NCRecipes.coolant_heater, NCJEI.getCoolantHeaters(), "coolant_heater", JEIRecipeWrapper.CoolantHeater.class),
        FISSION_EMERGENCY_COOLING((BasicRecipeHandler)NCRecipes.fission_emergency_cooling, NCBlocks.fission_vent, "fission_emergency_cooling", JEIRecipeWrapper.FissionEmergencyCooling.class),
        HEAT_EXCHANGER((BasicRecipeHandler)NCRecipes.heat_exchanger, Lists.newArrayList((Object[])new Block[]{NCBlocks.heat_exchanger_tube_copper, NCBlocks.heat_exchanger_tube_hard_carbon, NCBlocks.heat_exchanger_tube_thermoconducting}), "heat_exchanger", JEIRecipeWrapper.HeatExchanger.class),
        CONDENSER((BasicRecipeHandler)NCRecipes.condenser, Lists.newArrayList((Object[])new Block[]{NCBlocks.condenser_tube_copper, NCBlocks.condenser_tube_hard_carbon, NCBlocks.condenser_tube_thermoconducting}), "condenser", JEIRecipeWrapper.Condenser.class),
        TURBINE((BasicRecipeHandler)NCRecipes.turbine, NCBlocks.turbine_controller, "turbine", JEIRecipeWrapper.Turbine.class),
        RADIATION_SCRUBBER((BasicRecipeHandler)NCRecipes.radiation_scrubber, NCBlocks.radiation_scrubber, "radiation_scrubber", JEIRecipeWrapper.RadiationScrubber.class);

        private final BasicRecipeHandler recipeHandler;
        private final Class<? extends JEIBasicRecipeWrapper> recipeWrapper;
        private final boolean enabled;
        private final List<ItemStack> crafters;
        private final String textureName;

        private JEIHandler(BasicRecipeHandler recipeHandler, Object crafter, String textureName, Class<? extends JEIBasicRecipeWrapper> recipeWrapper) {
            this(recipeHandler, crafter, textureName, recipeWrapper, -1);
        }

        private JEIHandler(BasicRecipeHandler recipeHandler, List<?> crafters, String textureName, Class<? extends JEIBasicRecipeWrapper> recipeWrapper) {
            this(recipeHandler, crafters, textureName, recipeWrapper, -1);
        }

        private JEIHandler(BasicRecipeHandler recipeHandler, Object crafter, String textureName, Class<? extends JEIBasicRecipeWrapper> recipeWrapper, int enabled) {
            this(recipeHandler, Lists.newArrayList((Object[])new Object[]{crafter}), textureName, recipeWrapper, enabled);
        }

        private JEIHandler(BasicRecipeHandler recipeHandler, List<?> crafters, String textureName, Class<? extends JEIBasicRecipeWrapper> recipeWrapper, int enabled) {
            this.recipeHandler = recipeHandler;
            this.recipeWrapper = recipeWrapper;
            this.enabled = enabled < 0 ? true : NCConfig.register_processor[enabled];
            this.crafters = this.enabled ? NCJEI.fixStacks(crafters) : new ArrayList<ItemStack>();
            this.textureName = textureName;
        }

        @Override
        public JEIBasicCategory<?> getCategory(IGuiHelper guiHelper) {
            switch (this) {
                case MANUFACTORY: {
                    return new ManufactoryCategory(guiHelper, this);
                }
                case SEPARATOR: {
                    return new SeparatorCategory(guiHelper, this);
                }
                case DECAY_HASTENER: {
                    return new DecayHastenerCategory(guiHelper, this);
                }
                case FUEL_REPROCESSOR: {
                    return new FuelReprocessorCategory(guiHelper, this);
                }
                case ALLOY_FURNACE: {
                    return new AlloyFurnaceCategory(guiHelper, this);
                }
                case INFUSER: {
                    return new InfuserCategory(guiHelper, this);
                }
                case MELTER: {
                    return new MelterCategory(guiHelper, this);
                }
                case SUPERCOOLER: {
                    return new SupercoolerCategory(guiHelper, this);
                }
                case ELECTROLYZER: {
                    return new ElectrolyzerCategory(guiHelper, this);
                }
                case ASSEMBLER: {
                    return new AssemblerCategory(guiHelper, this);
                }
                case INGOT_FORMER: {
                    return new IngotFormerCategory(guiHelper, this);
                }
                case PRESSURIZER: {
                    return new PressurizerCategory(guiHelper, this);
                }
                case CHEMICAL_REACTOR: {
                    return new ChemicalReactorCategory(guiHelper, this);
                }
                case SALT_MIXER: {
                    return new SaltMixerCategory(guiHelper, this);
                }
                case CRYSTALLIZER: {
                    return new CrystallizerCategory(guiHelper, this);
                }
                case ENRICHER: {
                    return new EnricherCategory(guiHelper, this);
                }
                case EXTRACTOR: {
                    return new ExtractorCategory(guiHelper, this);
                }
                case CENTRIFUGE: {
                    return new CentrifugeCategory(guiHelper, this);
                }
                case ROCK_CRUSHER: {
                    return new RockCrusherCategory(guiHelper, this);
                }
                case COLLECTOR: {
                    return new CollectorCategory(guiHelper, this);
                }
                case DECAY_GENERATOR: {
                    return new DecayGeneratorCategory(guiHelper, this);
                }
                case FISSION_MODERATOR: {
                    return new FissionModeratorCategory(guiHelper, this);
                }
                case FISSION_REFLECTOR: {
                    return new FissionReflectorCategory(guiHelper, this);
                }
                case FISSION_IRRADIATOR: {
                    return new FissionIrradiatorCategory(guiHelper, this);
                }
                case PEBBLE_FISSION: {
                    return new PebbleFissionCategory(guiHelper, this);
                }
                case SOLID_FISSION: {
                    return new SolidFissionCategory(guiHelper, this);
                }
                case FISSION_HEATING: {
                    return new FissionHeatingCategory(guiHelper, this);
                }
                case SALT_FISSION: {
                    return new SaltFissionCategory(guiHelper, this);
                }
                case COOLANT_HEATER: {
                    return new CoolantHeaterCategory(guiHelper, this);
                }
                case FISSION_EMERGENCY_COOLING: {
                    return new FissionEmergencyCoolingCategory(guiHelper, this);
                }
                case HEAT_EXCHANGER: {
                    return new HeatExchangerCategory(guiHelper, this);
                }
                case TURBINE: {
                    return new TurbineCategory(guiHelper, this);
                }
                case CONDENSER: {
                    return new CondenserCategory(guiHelper, this);
                }
                case RADIATION_SCRUBBER: {
                    return new RadiationScrubberCategory(guiHelper, this);
                }
            }
            return null;
        }

        @Override
        public BasicRecipeHandler getRecipeHandler() {
            return this.recipeHandler;
        }

        public Class<? extends JEIBasicRecipeWrapper> getRecipeWrapperClass() {
            return this.recipeWrapper;
        }

        public List<? extends JEIBasicRecipeWrapper> getJEIRecipes(IGuiHelper guiHelper) {
            return JEIHelper.getJEIRecipes(guiHelper, this, this.getRecipeHandler(), this.getRecipeWrapperClass());
        }

        @Override
        public String getUid() {
            return "nuclearcraft_" + this.getRecipeHandler().getName();
        }

        @Override
        public boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public List<ItemStack> getCrafters() {
            return this.crafters;
        }

        @Override
        public String getTextureName() {
            return this.textureName;
        }
    }
}

