/*
 * Decompiled with CFR 0.152.
 */
package nc.integration.jei;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import nc.config.NCConfig;
import nc.integration.jei.JEIBasicRecipeWrapper;
import nc.integration.jei.JEIMachineRecipeWrapper;
import nc.integration.jei.NCJEI;
import nc.radiation.RadiationHelper;
import nc.recipe.BasicRecipe;
import nc.recipe.BasicRecipeHandler;
import nc.recipe.RecipeStats;
import nc.util.Lang;
import nc.util.NCMath;
import nc.util.UnitHelper;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;

public class JEIRecipeWrapper {

    public static class RadiationScrubber
    extends JEIBasicRecipeWrapper<RadiationScrubber> {
        private static final String PROCESS_TIME = Lang.localise("jei.nuclearcraft.scrubber_process_time");
        private static final String PROCESS_POWER = Lang.localise("jei.nuclearcraft.scrubber_process_power");
        private static final String PROCESS_EFFICIENCY = Lang.localise("jei.nuclearcraft.scrubber_process_efficiency");

        public RadiationScrubber(IGuiHelper guiHelper, NCJEI.IJEIHandler<RadiationScrubber> jeiHandler, BasicRecipeHandler recipeHandler, BasicRecipe recipe) {
            super(guiHelper, jeiHandler, recipeHandler, recipe, 31, 30, 176, 3, 37, 16, 70, 35);
        }

        @Override
        protected int getProgressArrowTime() {
            return MathHelper.func_76143_f((double)(this.getScrubberProcessTime() / 120.0));
        }

        protected double getScrubberProcessTime() {
            if (this.recipe == null) {
                return 1.0;
            }
            return this.recipe.getScrubberProcessTime();
        }

        protected int getScrubberProcessPower() {
            if (this.recipe == null) {
                return 0;
            }
            return this.recipe.getScrubberProcessPower();
        }

        protected double getScrubberProcessEfficiency() {
            if (this.recipe == null) {
                return 0.0;
            }
            return this.recipe.getScrubberProcessEfficiency();
        }

        @Override
        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            ArrayList<String> tooltip = new ArrayList<String>();
            if (mouseX >= 38 && mouseY >= 4 && mouseX < 76 && mouseY < 23) {
                tooltip.add(TextFormatting.GREEN + PROCESS_TIME + " " + TextFormatting.WHITE + UnitHelper.applyTimeUnitShort(this.getScrubberProcessTime(), 3));
                tooltip.add(TextFormatting.LIGHT_PURPLE + PROCESS_POWER + " " + TextFormatting.WHITE + UnitHelper.prefix(this.getScrubberProcessPower(), 5, "RF/t"));
                tooltip.add(TextFormatting.RED + PROCESS_EFFICIENCY + " " + TextFormatting.WHITE + NCMath.pcDecimalPlaces(this.getScrubberProcessEfficiency(), 1));
            }
            return tooltip;
        }
    }

    public static class Turbine
    extends JEIBasicRecipeWrapper<Turbine> {
        private static final String ENERGY_DENSITY = Lang.localise("jei.nuclearcraft.turbine_energy_density");
        private static final String EXPANSION = Lang.localise("jei.nuclearcraft.turbine_expansion");
        private static final String SPIN_UP = Lang.localise("jei.nuclearcraft.turbine_spin_up_multiplier");

        public Turbine(IGuiHelper guiHelper, NCJEI.IJEIHandler<Turbine> jeiHandler, BasicRecipeHandler recipeHandler, BasicRecipe recipe) {
            super(guiHelper, jeiHandler, recipeHandler, recipe, 47, 30, 176, 3, 37, 16, 74, 35);
        }

        @Override
        protected int getProgressArrowTime() {
            return 20;
        }

        protected double getTurbinePowerPerMB() {
            if (this.recipe == null) {
                return 0.0;
            }
            return this.recipe.getTurbinePowerPerMB();
        }

        protected double getTurbineExpansionLevel() {
            if (this.recipe == null) {
                return 1.0;
            }
            return this.recipe.getTurbineExpansionLevel();
        }

        protected double getTurbineSpinUpMultiplier() {
            if (this.recipe == null) {
                return 1.0;
            }
            return this.recipe.getTurbineSpinUpMultiplier();
        }

        @Override
        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            ArrayList<String> tooltip = new ArrayList<String>();
            if (mouseX >= 26 && mouseY >= 4 && mouseX < 64 && mouseY < 23) {
                tooltip.add(TextFormatting.LIGHT_PURPLE + ENERGY_DENSITY + " " + TextFormatting.WHITE + NCMath.decimalPlaces(this.getTurbinePowerPerMB(), 2) + " RF/mB");
                tooltip.add(TextFormatting.GRAY + EXPANSION + " " + TextFormatting.WHITE + NCMath.pcDecimalPlaces(this.getTurbineExpansionLevel(), 1));
                tooltip.add(TextFormatting.GREEN + SPIN_UP + " " + TextFormatting.WHITE + NCMath.pcDecimalPlaces(this.getTurbineSpinUpMultiplier(), 1));
            }
            return tooltip;
        }
    }

    public static class Condenser
    extends JEIBasicRecipeWrapper<Condenser> {
        private static final String CONDENSING_TEMPERATURE = Lang.localise("jei.nuclearcraft.condenser_condensing_temp");
        private static final String HEAT_REMOVAL_REQUIRED = Lang.localise("jei.nuclearcraft.condenser_heat_removal_req");

        public Condenser(IGuiHelper guiHelper, NCJEI.IJEIHandler<Condenser> jeiHandler, BasicRecipeHandler recipeHandler, BasicRecipe recipe) {
            super(guiHelper, jeiHandler, recipeHandler, recipe, 47, 30, 176, 3, 37, 16, 74, 35);
        }

        @Override
        protected int getProgressArrowTime() {
            return (int)(this.getCondenserProcessTime() / 2.0);
        }

        protected double getCondenserProcessTime() {
            if (this.recipe == null) {
                return 40.0;
            }
            return this.recipe.getCondenserProcessTime();
        }

        protected int getCondenserCondensingTemperature() {
            if (this.recipe == null) {
                return 300;
            }
            return this.recipe.getCondenserCondensingTemperature();
        }

        @Override
        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            ArrayList<String> tooltip = new ArrayList<String>();
            if (mouseX >= 26 && mouseY >= 4 && mouseX < 64 && mouseY < 23) {
                tooltip.add(TextFormatting.YELLOW + CONDENSING_TEMPERATURE + TextFormatting.WHITE + " " + this.getCondenserCondensingTemperature() + "K");
                tooltip.add(TextFormatting.BLUE + HEAT_REMOVAL_REQUIRED + TextFormatting.WHITE + " " + NCMath.sigFigs(this.getCondenserProcessTime(), 5));
            }
            return tooltip;
        }
    }

    public static class HeatExchanger
    extends JEIBasicRecipeWrapper<HeatExchanger> {
        private static final String HEATING_PROVIDED = Lang.localise("jei.nuclearcraft.exchanger_heating_provided");
        private static final String COOLING_PROVIDED = Lang.localise("jei.nuclearcraft.exchanger_cooling_provided");
        private static final String HEATING_REQUIRED = Lang.localise("jei.nuclearcraft.exchanger_heating_required");
        private static final String COOLING_REQUIRED = Lang.localise("jei.nuclearcraft.exchanger_cooling_required");

        public HeatExchanger(IGuiHelper guiHelper, NCJEI.IJEIHandler<HeatExchanger> jeiHandler, BasicRecipeHandler recipeHandler, BasicRecipe recipe) {
            super(guiHelper, jeiHandler, recipeHandler, recipe, 47, 30, 176, recipe != null && recipe.getHeatExchangerIsHeating() ? 3 : 19, 37, 16, 74, 35);
        }

        @Override
        protected int getProgressArrowTime() {
            return this.recipe != null ? (int)(this.recipe.getHeatExchangerProcessTime() / 400.0) : 40;
        }

        protected int getHeatExchangerProcessTime() {
            if (this.recipe == null) {
                return 16000;
            }
            return (int)this.recipe.getHeatExchangerProcessTime();
        }

        @Override
        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            ArrayList<String> tooltip = new ArrayList<String>();
            if (mouseX >= 26 && mouseY >= 4 && mouseX < 64 && mouseY < 23) {
                boolean heating = this.recipe.getHeatExchangerIsHeating();
                int inputTemp = this.recipe.getHeatExchangerInputTemperature();
                int outputTemp = this.recipe.getHeatExchangerOutputTemperature();
                tooltip.add((heating ? TextFormatting.AQUA + COOLING_PROVIDED : TextFormatting.RED + HEATING_PROVIDED) + TextFormatting.WHITE + " " + Math.abs(inputTemp - outputTemp) + "/t");
                tooltip.add((heating ? TextFormatting.RED + HEATING_REQUIRED : TextFormatting.AQUA + COOLING_REQUIRED) + TextFormatting.WHITE + " " + this.getHeatExchangerProcessTime());
            }
            return tooltip;
        }
    }

    public static class Fusion
    extends JEIBasicRecipeWrapper<Fusion> {
        private static final String COMBO_TIME = Lang.localise("jei.nuclearcraft.fusion_time");
        private static final String COMBO_POWER = Lang.localise("jei.nuclearcraft.fusion_power");
        private static final String COMBO_TEMP = Lang.localise("jei.nuclearcraft.fusion_temp");

        public Fusion(IGuiHelper guiHelper, NCJEI.IJEIHandler<Fusion> jeiHandler, BasicRecipeHandler recipeHandler, BasicRecipe recipe) {
            super(guiHelper, jeiHandler, recipeHandler, recipe, 55, 30, 176, 3, 37, 16, 74, 35);
        }

        @Override
        protected int getProgressArrowTime() {
            return (int)(this.getFusionComboTime() / 4.0);
        }

        protected double getFusionComboTime() {
            if (this.recipe == null) {
                return 1.0;
            }
            return this.recipe.getFusionComboTime();
        }

        protected double getFusionComboHeat() {
            if (this.recipe == null) {
                return 0.0;
            }
            return this.recipe.getFusionComboHeat();
        }

        protected double getFusionComboOptimalTemperature() {
            if (this.recipe == null) {
                return 1000.0;
            }
            return this.recipe.getFusionComboOptimalTemperature();
        }

        @Override
        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            ArrayList<String> tooltip = new ArrayList<String>();
            if (mouseX >= 18 && mouseY >= 4 && mouseX < 56 && mouseY < 23) {
                tooltip.add(TextFormatting.GREEN + COMBO_TIME + " " + TextFormatting.WHITE + UnitHelper.applyTimeUnitShort(this.getFusionComboTime(), 3));
                tooltip.add(TextFormatting.LIGHT_PURPLE + COMBO_POWER + " " + TextFormatting.WHITE + UnitHelper.prefix(this.getFusionComboHeat(), 5, "RF/t"));
                double optimalTemp = this.getFusionComboOptimalTemperature();
                tooltip.add(TextFormatting.YELLOW + COMBO_TEMP + " " + (optimalTemp < 20000.0 ? TextFormatting.WHITE : TextFormatting.GOLD) + UnitHelper.prefix(optimalTemp, 5, "K", 2));
            }
            return tooltip;
        }
    }

    public static class FissionEmergencyCooling
    extends JEIBasicRecipeWrapper<FissionEmergencyCooling> {
        private static final String COOLING_PER_MB = Lang.localise("jei.nuclearcraft.fission_emergency_cooling_per_mb");

        public FissionEmergencyCooling(IGuiHelper guiHelper, NCJEI.IJEIHandler<FissionEmergencyCooling> jeiHandler, BasicRecipeHandler recipeHandler, BasicRecipe recipe) {
            super(guiHelper, jeiHandler, recipeHandler, recipe, 47, 30, 176, 3, 37, 16, 74, 35);
        }

        @Override
        protected int getProgressArrowTime() {
            return (int)(16.0 / this.getEmergencyCoolingHeatPerInputMB());
        }

        public double getEmergencyCoolingHeatPerInputMB() {
            if (this.recipe == null) {
                return 1.0;
            }
            return this.recipe.getEmergencyCoolingHeatPerInputMB();
        }

        @Override
        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            ArrayList<String> tooltip = new ArrayList<String>();
            if (mouseX >= 26 && mouseY >= 4 && mouseX < 64 && mouseY < 23) {
                tooltip.add(TextFormatting.BLUE + COOLING_PER_MB + " " + TextFormatting.WHITE + NCMath.decimalPlaces(this.getEmergencyCoolingHeatPerInputMB(), 2) + " H/mB");
            }
            return tooltip;
        }
    }

    public static class CoolantHeater
    extends JEIBasicRecipeWrapper<CoolantHeater> {
        private static final String COOLING = Lang.localise("jei.nuclearcraft.coolant_heater_rate");

        public CoolantHeater(IGuiHelper guiHelper, NCJEI.IJEIHandler<CoolantHeater> jeiHandler, BasicRecipeHandler recipeHandler, BasicRecipe recipe) {
            super(guiHelper, jeiHandler, recipeHandler, recipe, 45, 30, 176, 3, 37, 16, 84, 35);
        }

        @Override
        protected int getProgressArrowTime() {
            return 20;
        }

        protected int getCoolantHeaterCoolingRate() {
            if (this.recipe == null) {
                return 40;
            }
            return this.recipe.getCoolantHeaterCoolingRate();
        }

        protected String[] getCoolantHeaterJEIInfo() {
            if (this.recipe == null) {
                return null;
            }
            return this.recipe.getCoolantHeaterJEIInfo();
        }

        @Override
        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            ArrayList<String> tooltip = new ArrayList<String>();
            if (mouseX >= 26 && mouseY >= 4 && mouseX < 64 && mouseY < 23) {
                tooltip.add(TextFormatting.BLUE + COOLING + " " + TextFormatting.WHITE + UnitHelper.prefix(this.getCoolantHeaterCoolingRate(), 5, "H/t"));
                if (this.getCoolantHeaterJEIInfo() != null) {
                    for (String posInfo : this.getCoolantHeaterJEIInfo()) {
                        tooltip.add(TextFormatting.AQUA + posInfo);
                    }
                }
            }
            return tooltip;
        }
    }

    public static class SaltFission
    extends JEIBasicRecipeWrapper<SaltFission> {
        private static final String FUEL_TIME = Lang.localise("jei.nuclearcraft.salt_fuel_time");
        private static final String FUEL_HEAT = Lang.localise("jei.nuclearcraft.salt_fuel_heat");
        private static final String FUEL_EFFICIENCY = Lang.localise("jei.nuclearcraft.salt_fuel_efficiency");
        private static final String FUEL_CRITICALITY = Lang.localise("jei.nuclearcraft.salt_fuel_criticality");
        private static final String FUEL_DECAY_FACTOR = Lang.localise("jei.nuclearcraft.salt_fuel_decay_factor");
        private static final String FUEL_SELF_PRIMING = Lang.localise("jei.nuclearcraft.salt_fuel_self_priming");
        private static final String FUEL_RADIATION = Lang.localise("jei.nuclearcraft.salt_fuel_radiation");

        public SaltFission(IGuiHelper guiHelper, NCJEI.IJEIHandler<SaltFission> jeiHandler, BasicRecipeHandler recipeHandler, BasicRecipe recipe) {
            super(guiHelper, jeiHandler, recipeHandler, recipe, 47, 30, 176, 3, 37, 16, 74, 35);
        }

        @Override
        protected int getProgressArrowTime() {
            return (int)(144.0 * this.getSaltFissionFuelTime() / 80.0);
        }

        protected double getSaltFissionFuelTime() {
            if (this.recipe == null) {
                return 1.0;
            }
            return this.recipe.getSaltFissionFuelTime();
        }

        protected int getFissionFuelHeat() {
            if (this.recipe == null) {
                return 0;
            }
            return this.recipe.getFissionFuelHeat();
        }

        protected double getFissionFuelEfficiency() {
            if (this.recipe == null) {
                return 0.0;
            }
            return this.recipe.getFissionFuelEfficiency();
        }

        protected int getFissionFuelCriticality() {
            if (this.recipe == null) {
                return 1;
            }
            return this.recipe.getFissionFuelCriticality();
        }

        protected double getFissionFuelDecayFactor() {
            if (this.recipe == null) {
                return 0.0;
            }
            return this.recipe.getFissionFuelDecayFactor();
        }

        protected boolean getFissionFuelSelfPriming() {
            if (this.recipe == null) {
                return false;
            }
            return this.recipe.getFissionFuelSelfPriming();
        }

        protected double getFissionFuelRadiation() {
            if (this.recipe == null) {
                return 0.0;
            }
            return this.recipe.getFissionFuelRadiation();
        }

        @Override
        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            ArrayList<String> tooltip = new ArrayList<String>();
            if (mouseX >= 26 && mouseY >= 4 && mouseX < 64 && mouseY < 23) {
                double radiation;
                tooltip.add(TextFormatting.GREEN + FUEL_TIME + " " + TextFormatting.WHITE + UnitHelper.applyTimeUnitShort(this.getSaltFissionFuelTime(), 3));
                tooltip.add(TextFormatting.YELLOW + FUEL_HEAT + " " + TextFormatting.WHITE + UnitHelper.prefix(this.getFissionFuelHeat(), 5, "H/t"));
                tooltip.add(TextFormatting.LIGHT_PURPLE + FUEL_EFFICIENCY + " " + TextFormatting.WHITE + NCMath.pcDecimalPlaces(this.getFissionFuelEfficiency(), 1));
                tooltip.add(TextFormatting.RED + FUEL_CRITICALITY + " " + TextFormatting.WHITE + this.getFissionFuelCriticality() + " N/t");
                if (NCConfig.fission_decay_mechanics) {
                    tooltip.add(TextFormatting.GRAY + FUEL_DECAY_FACTOR + " " + TextFormatting.WHITE + NCMath.pcDecimalPlaces(this.getFissionFuelDecayFactor(), 1));
                }
                if (this.getFissionFuelSelfPriming()) {
                    tooltip.add(TextFormatting.DARK_AQUA + FUEL_SELF_PRIMING);
                }
                if ((radiation = this.getFissionFuelRadiation()) > 0.0) {
                    tooltip.add(TextFormatting.GOLD + FUEL_RADIATION + " " + RadiationHelper.radsColoredPrefix(radiation, true));
                }
            }
            return tooltip;
        }
    }

    public static class FissionHeating
    extends JEIBasicRecipeWrapper<FissionHeating> {
        private static final String HEAT_PER_MB = Lang.localise("jei.nuclearcraft.fission_heating_heat_per_mb");

        public FissionHeating(IGuiHelper guiHelper, NCJEI.IJEIHandler<FissionHeating> jeiHandler, BasicRecipeHandler recipeHandler, BasicRecipe recipe) {
            super(guiHelper, jeiHandler, recipeHandler, recipe, 47, 30, 176, 3, 37, 16, 74, 35);
        }

        @Override
        protected int getProgressArrowTime() {
            return this.getFissionHeatingHeatPerInputMB() / 4;
        }

        protected int getFissionHeatingHeatPerInputMB() {
            if (this.recipe == null) {
                return 64;
            }
            return this.recipe.getFissionHeatingHeatPerInputMB();
        }

        @Override
        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            ArrayList<String> tooltip = new ArrayList<String>();
            if (mouseX >= 26 && mouseY >= 4 && mouseX < 64 && mouseY < 23) {
                tooltip.add(TextFormatting.YELLOW + HEAT_PER_MB + " " + TextFormatting.WHITE + this.getFissionHeatingHeatPerInputMB() + " H/mB");
            }
            return tooltip;
        }
    }

    public static class SolidFission
    extends JEIBasicRecipeWrapper<SolidFission> {
        private static final String FUEL_TIME = Lang.localise("jei.nuclearcraft.solid_fuel_time");
        private static final String FUEL_HEAT = Lang.localise("jei.nuclearcraft.solid_fuel_heat");
        private static final String FUEL_EFFICIENCY = Lang.localise("jei.nuclearcraft.solid_fuel_efficiency");
        private static final String FUEL_CRITICALITY = Lang.localise("jei.nuclearcraft.solid_fuel_criticality");
        private static final String FUEL_DECAY_FACTOR = Lang.localise("jei.nuclearcraft.solid_fuel_decay_factor");
        private static final String FUEL_SELF_PRIMING = Lang.localise("jei.nuclearcraft.solid_fuel_self_priming");
        private static final String FUEL_RADIATION = Lang.localise("jei.nuclearcraft.solid_fuel_radiation");

        public SolidFission(IGuiHelper guiHelper, NCJEI.IJEIHandler<SolidFission> jeiHandler, BasicRecipeHandler recipeHandler, BasicRecipe recipe) {
            super(guiHelper, jeiHandler, recipeHandler, recipe, 47, 30, 176, 3, 37, 16, 74, 35);
        }

        @Override
        protected int getProgressArrowTime() {
            return (int)((double)this.getFissionFuelTime() / 80.0);
        }

        protected int getFissionFuelTime() {
            if (this.recipe == null) {
                return 1;
            }
            return this.recipe.getFissionFuelTime();
        }

        protected int getFissionFuelHeat() {
            if (this.recipe == null) {
                return 0;
            }
            return this.recipe.getFissionFuelHeat();
        }

        protected double getFissionFuelEfficiency() {
            if (this.recipe == null) {
                return 0.0;
            }
            return this.recipe.getFissionFuelEfficiency();
        }

        protected int getFissionFuelCriticality() {
            if (this.recipe == null) {
                return 1;
            }
            return this.recipe.getFissionFuelCriticality();
        }

        protected double getFissionFuelDecayFactor() {
            if (this.recipe == null) {
                return 0.0;
            }
            return this.recipe.getFissionFuelDecayFactor();
        }

        protected boolean getFissionFuelSelfPriming() {
            if (this.recipe == null) {
                return false;
            }
            return this.recipe.getFissionFuelSelfPriming();
        }

        protected double getFissionFuelRadiation() {
            if (this.recipe == null) {
                return 0.0;
            }
            return this.recipe.getFissionFuelRadiation();
        }

        @Override
        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            ArrayList<String> tooltip = new ArrayList<String>();
            if (mouseX >= 26 && mouseY >= 4 && mouseX < 64 && mouseY < 23) {
                double radiation;
                tooltip.add(TextFormatting.GREEN + FUEL_TIME + " " + TextFormatting.WHITE + UnitHelper.applyTimeUnitShort(this.getFissionFuelTime(), 3));
                tooltip.add(TextFormatting.YELLOW + FUEL_HEAT + " " + TextFormatting.WHITE + UnitHelper.prefix(this.getFissionFuelHeat(), 5, "H/t"));
                tooltip.add(TextFormatting.LIGHT_PURPLE + FUEL_EFFICIENCY + " " + TextFormatting.WHITE + NCMath.pcDecimalPlaces(this.getFissionFuelEfficiency(), 1));
                tooltip.add(TextFormatting.RED + FUEL_CRITICALITY + " " + TextFormatting.WHITE + this.getFissionFuelCriticality() + " N/t");
                if (NCConfig.fission_decay_mechanics) {
                    tooltip.add(TextFormatting.GRAY + FUEL_DECAY_FACTOR + " " + TextFormatting.WHITE + NCMath.pcDecimalPlaces(this.getFissionFuelDecayFactor(), 1));
                }
                if (this.getFissionFuelSelfPriming()) {
                    tooltip.add(TextFormatting.DARK_AQUA + FUEL_SELF_PRIMING);
                }
                if ((radiation = this.getFissionFuelRadiation()) > 0.0) {
                    tooltip.add(TextFormatting.GOLD + FUEL_RADIATION + " " + RadiationHelper.radsColoredPrefix(radiation, true));
                }
            }
            return tooltip;
        }
    }

    public static class PebbleFission
    extends JEIBasicRecipeWrapper<PebbleFission> {
        private static final String FUEL_TIME = Lang.localise("jei.nuclearcraft.pebble_fuel_time");
        private static final String FUEL_HEAT = Lang.localise("jei.nuclearcraft.pebble_fuel_heat");
        private static final String FUEL_EFFICIENCY = Lang.localise("jei.nuclearcraft.pebble_fuel_efficiency");
        private static final String FUEL_CRITICALITY = Lang.localise("jei.nuclearcraft.pebble_fuel_criticality");
        private static final String FUEL_DECAY_FACTOR = Lang.localise("jei.nuclearcraft.pebble_fuel_decay_factor");
        private static final String FUEL_SELF_PRIMING = Lang.localise("jei.nuclearcraft.pebble_fuel_self_priming");
        private static final String FUEL_RADIATION = Lang.localise("jei.nuclearcraft.pebble_fuel_radiation");

        public PebbleFission(IGuiHelper guiHelper, NCJEI.IJEIHandler<PebbleFission> jeiHandler, BasicRecipeHandler recipeHandler, BasicRecipe recipe) {
            super(guiHelper, jeiHandler, recipeHandler, recipe, 47, 30, 176, 3, 37, 16, 74, 35);
        }

        @Override
        protected int getProgressArrowTime() {
            return (int)((double)this.getFissionFuelTime() / 80.0);
        }

        protected int getFissionFuelTime() {
            if (this.recipe == null) {
                return 1;
            }
            return this.recipe.getFissionFuelTime();
        }

        protected int getFissionFuelHeat() {
            if (this.recipe == null) {
                return 0;
            }
            return this.recipe.getFissionFuelHeat();
        }

        protected double getFissionFuelEfficiency() {
            if (this.recipe == null) {
                return 0.0;
            }
            return this.recipe.getFissionFuelEfficiency();
        }

        protected int getFissionFuelCriticality() {
            if (this.recipe == null) {
                return 1;
            }
            return this.recipe.getFissionFuelCriticality();
        }

        protected double getFissionFuelDecayFactor() {
            if (this.recipe == null) {
                return 0.0;
            }
            return this.recipe.getFissionFuelDecayFactor();
        }

        protected boolean getFissionFuelSelfPriming() {
            if (this.recipe == null) {
                return false;
            }
            return this.recipe.getFissionFuelSelfPriming();
        }

        protected double getFissionFuelRadiation() {
            if (this.recipe == null) {
                return 0.0;
            }
            return this.recipe.getFissionFuelRadiation();
        }

        @Override
        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            ArrayList<String> tooltip = new ArrayList<String>();
            if (mouseX >= 26 && mouseY >= 4 && mouseX < 64 && mouseY < 23) {
                double radiation;
                tooltip.add(TextFormatting.GREEN + FUEL_TIME + " " + TextFormatting.WHITE + UnitHelper.applyTimeUnitShort(this.getFissionFuelTime(), 3));
                tooltip.add(TextFormatting.YELLOW + FUEL_HEAT + " " + TextFormatting.WHITE + UnitHelper.prefix(this.getFissionFuelHeat(), 5, "H/t"));
                tooltip.add(TextFormatting.LIGHT_PURPLE + FUEL_EFFICIENCY + " " + TextFormatting.WHITE + NCMath.pcDecimalPlaces(this.getFissionFuelEfficiency(), 1));
                tooltip.add(TextFormatting.RED + FUEL_CRITICALITY + " " + TextFormatting.WHITE + this.getFissionFuelCriticality() + " N/t");
                if (NCConfig.fission_decay_mechanics) {
                    tooltip.add(TextFormatting.GRAY + FUEL_DECAY_FACTOR + " " + TextFormatting.WHITE + NCMath.pcDecimalPlaces(this.getFissionFuelDecayFactor(), 1));
                }
                if (this.getFissionFuelSelfPriming()) {
                    tooltip.add(TextFormatting.DARK_AQUA + FUEL_SELF_PRIMING);
                }
                if ((radiation = this.getFissionFuelRadiation()) > 0.0) {
                    tooltip.add(TextFormatting.GOLD + FUEL_RADIATION + " " + RadiationHelper.radsColoredPrefix(radiation, true));
                }
            }
            return tooltip;
        }
    }

    public static class FissionIrradiator
    extends JEIBasicRecipeWrapper<FissionIrradiator> {
        private static final String FLUX_REQUIRED = Lang.localise("jei.nuclearcraft.irradiator_flux_required");
        private static final String HEAT_PER_FLUX = Lang.localise("jei.nuclearcraft.irradiator_heat_per_flux");
        private static final String EFFICIENCY = Lang.localise("jei.nuclearcraft.irradiator_process_efficiency");
        private static final String VALID_FLUX_MINIMUM = Lang.localise("jei.nuclearcraft.irradiator_valid_flux_minimum");
        private static final String VALID_FLUX_MAXIMUM = Lang.localise("jei.nuclearcraft.irradiator_valid_flux_maximum");
        private static final String VALID_FLUX_RANGE = Lang.localise("jei.nuclearcraft.irradiator_valid_flux_range");
        private static final String RADIATION_PER_FLUX = Lang.localise("jei.nuclearcraft.radiation_per_flux");

        public FissionIrradiator(IGuiHelper guiHelper, NCJEI.IJEIHandler<FissionIrradiator> jeiHandler, BasicRecipeHandler recipeHandler, BasicRecipe recipe) {
            super(guiHelper, jeiHandler, recipeHandler, recipe, 47, 30, 176, 3, 37, 16, 74, 35);
        }

        @Override
        protected int getProgressArrowTime() {
            return (int)((double)this.getIrradiatorFluxRequired() / 8000.0);
        }

        protected int getIrradiatorFluxRequired() {
            if (this.recipe == null) {
                return 1;
            }
            return this.recipe.getIrradiatorFluxRequired();
        }

        protected double getIrradiatorHeatPerFlux() {
            if (this.recipe == null) {
                return 0.0;
            }
            return this.recipe.getIrradiatorHeatPerFlux();
        }

        protected double getIrradiatorProcessEfficiency() {
            if (this.recipe == null) {
                return 0.0;
            }
            return this.recipe.getIrradiatorProcessEfficiency();
        }

        protected int getIrradiatorMinFluxPerTick() {
            if (this.recipe == null) {
                return 0;
            }
            return this.recipe.getIrradiatorMinFluxPerTick();
        }

        protected int getIrradiatorMaxFluxPerTick() {
            if (this.recipe == null) {
                return -1;
            }
            return this.recipe.getIrradiatorMaxFluxPerTick();
        }

        protected double getIrradiatorBaseProcessRadiation() {
            if (this.recipe == null) {
                return 0.0;
            }
            return this.recipe.getIrradiatorBaseProcessRadiation();
        }

        @Override
        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            ArrayList<String> tooltip = new ArrayList<String>();
            if (mouseX >= 26 && mouseY >= 4 && mouseX < 64 && mouseY < 23) {
                double radiation;
                double efficiency;
                tooltip.add(TextFormatting.RED + FLUX_REQUIRED + " " + TextFormatting.WHITE + UnitHelper.prefix(this.getIrradiatorFluxRequired(), 5, "N"));
                double heatPerFlux = this.getIrradiatorHeatPerFlux();
                if (heatPerFlux > 0.0) {
                    tooltip.add(TextFormatting.YELLOW + HEAT_PER_FLUX + " " + TextFormatting.WHITE + UnitHelper.prefix(heatPerFlux, 5, "H/N"));
                }
                if ((efficiency = this.getIrradiatorProcessEfficiency()) > 0.0) {
                    tooltip.add(TextFormatting.LIGHT_PURPLE + EFFICIENCY + " " + TextFormatting.WHITE + NCMath.pcDecimalPlaces(efficiency, 1));
                }
                int minFluxPerTick = this.getIrradiatorMinFluxPerTick();
                int maxFluxPerTick = this.getIrradiatorMaxFluxPerTick();
                if (minFluxPerTick > 0 || maxFluxPerTick >= 0) {
                    if (minFluxPerTick <= 0) {
                        tooltip.add(TextFormatting.RED + VALID_FLUX_MAXIMUM + " " + TextFormatting.WHITE + minFluxPerTick + " N/t");
                    } else if (maxFluxPerTick < 0) {
                        tooltip.add(TextFormatting.RED + VALID_FLUX_MINIMUM + " " + TextFormatting.WHITE + maxFluxPerTick + " N/t");
                    } else {
                        tooltip.add(TextFormatting.RED + VALID_FLUX_RANGE + " " + TextFormatting.WHITE + minFluxPerTick + " - " + maxFluxPerTick + " N/t");
                    }
                }
                if ((radiation = this.getIrradiatorBaseProcessRadiation() / (double)RecipeStats.getFissionMaxModeratorLineFlux()) > 0.0) {
                    tooltip.add(TextFormatting.GOLD + RADIATION_PER_FLUX + " " + RadiationHelper.getRadiationTextColor(radiation) + UnitHelper.prefix(radiation, 3, "Rad/N"));
                }
            }
            return tooltip;
        }
    }

    public static class FissionReflector
    extends JEIBasicRecipeWrapper<FissionReflector> {
        public FissionReflector(IGuiHelper guiHelper, NCJEI.IJEIHandler<FissionReflector> jeiHandler, BasicRecipeHandler recipeHandler, BasicRecipe recipe) {
            super(guiHelper, jeiHandler, recipeHandler, recipe, 47, 30, 176, 3, -1, -1, 74, 35);
        }

        @Override
        protected int getProgressArrowTime() {
            return 1;
        }
    }

    public static class FissionModerator
    extends JEIBasicRecipeWrapper<FissionModerator> {
        public FissionModerator(IGuiHelper guiHelper, NCJEI.IJEIHandler<FissionModerator> jeiHandler, BasicRecipeHandler recipeHandler, BasicRecipe recipe) {
            super(guiHelper, jeiHandler, recipeHandler, recipe, 47, 30, 176, 3, -1, -1, 74, 35);
        }

        @Override
        protected int getProgressArrowTime() {
            return 1;
        }
    }

    public static class DecayGenerator
    extends JEIBasicRecipeWrapper<DecayGenerator> {
        private static final String BLOCK_LIFETIME = Lang.localise("jei.nuclearcraft.decay_gen_lifetime");
        private static final String BLOCK_POWER = Lang.localise("jei.nuclearcraft.decay_gen_power");
        private static final String BLOCK_RADIATION = Lang.localise("jei.nuclearcraft.decay_gen_radiation");

        public DecayGenerator(IGuiHelper guiHelper, NCJEI.IJEIHandler<DecayGenerator> jeiHandler, BasicRecipeHandler recipeHandler, BasicRecipe recipe) {
            super(guiHelper, jeiHandler, recipeHandler, recipe, 47, 30, 176, 3, 37, 16, 74, 35);
        }

        @Override
        protected int getProgressArrowTime() {
            return (int)(this.getDecayGeneratorLifetime() / 20.0);
        }

        protected double getDecayGeneratorLifetime() {
            if (this.recipe == null) {
                return 1200.0;
            }
            return this.recipe.getDecayGeneratorLifetime();
        }

        protected double getDecayGeneratorPower() {
            if (this.recipe == null) {
                return 0.0;
            }
            return this.recipe.getDecayGeneratorPower();
        }

        protected double getDecayGeneratorRadiation() {
            if (this.recipe == null) {
                return 0.0;
            }
            return this.recipe.getDecayGeneratorRadiation();
        }

        @Override
        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            ArrayList<String> tooltip = new ArrayList<String>();
            if (mouseX >= 26 && mouseY >= 4 && mouseX < 64 && mouseY < 23) {
                tooltip.add(TextFormatting.GREEN + BLOCK_LIFETIME + " " + TextFormatting.WHITE + UnitHelper.applyTimeUnitShort(this.getDecayGeneratorLifetime(), 3, 1));
                tooltip.add(TextFormatting.LIGHT_PURPLE + BLOCK_POWER + " " + TextFormatting.WHITE + UnitHelper.prefix(this.getDecayGeneratorPower(), 5, "RF/t"));
                double radiation = this.getDecayGeneratorRadiation();
                if (radiation > 0.0) {
                    tooltip.add(TextFormatting.GOLD + BLOCK_RADIATION + " " + RadiationHelper.radsColoredPrefix(radiation, true));
                }
            }
            return tooltip;
        }
    }

    public static class Collector
    extends JEIBasicRecipeWrapper<Collector> {
        private static final String PRODUCTION_RATE = Lang.localise("jei.nuclearcraft.collector_production_rate");

        public Collector(IGuiHelper guiHelper, NCJEI.IJEIHandler<Collector> jeiHandler, BasicRecipeHandler recipeHandler, BasicRecipe recipe) {
            super(guiHelper, jeiHandler, recipeHandler, recipe, 33, 30, 176, 3, 37, 18, 60, 34);
        }

        @Override
        protected int getProgressArrowTime() {
            return NCConfig.machine_update_rate;
        }

        protected String getCollectorProductionRate() {
            if (this.recipe == null) {
                return null;
            }
            return this.recipe.getCollectorProductionRate();
        }

        @Override
        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            ArrayList<String> tooltip = new ArrayList<String>();
            if (mouseX >= 26 && mouseY >= 4 && mouseX < 64 && mouseY < 23) {
                tooltip.add(TextFormatting.GREEN + PRODUCTION_RATE + " " + TextFormatting.WHITE + this.getCollectorProductionRate());
            }
            return tooltip;
        }
    }

    public static class RockCrusher
    extends JEIMachineRecipeWrapper<RockCrusher> {
        public RockCrusher(IGuiHelper guiHelper, NCJEI.IJEIHandler<RockCrusher> jeiHandler, BasicRecipeHandler recipeHandler, BasicRecipe recipe) {
            super(guiHelper, jeiHandler, recipeHandler, recipe, 29, 30, 176, 3, 37, 16, 56, 35, 55, 34, 37, 18);
        }

        @Override
        protected double getBaseProcessTime() {
            if (this.recipe == null) {
                return NCConfig.processor_time_multiplier * (double)NCConfig.processor_time[18];
            }
            return this.recipe.getBaseProcessTime(NCConfig.processor_time_multiplier * (double)NCConfig.processor_time[18]);
        }

        @Override
        protected double getBaseProcessPower() {
            if (this.recipe == null) {
                return NCConfig.processor_power_multiplier * (double)NCConfig.processor_power[18];
            }
            return this.recipe.getBaseProcessPower(NCConfig.processor_power_multiplier * (double)NCConfig.processor_power[18]);
        }
    }

    public static class Centrifuge
    extends JEIMachineRecipeWrapper<Centrifuge> {
        public Centrifuge(IGuiHelper guiHelper, NCJEI.IJEIHandler<Centrifuge> jeiHandler, BasicRecipeHandler recipeHandler, BasicRecipe recipe) {
            super(guiHelper, jeiHandler, recipeHandler, recipe, 39, 30, 176, 3, 37, 38, 58, 30, 57, 30, 37, 38);
        }

        @Override
        protected double getBaseProcessTime() {
            if (this.recipe == null) {
                return NCConfig.processor_time_multiplier * (double)NCConfig.processor_time[17];
            }
            return this.recipe.getBaseProcessTime(NCConfig.processor_time_multiplier * (double)NCConfig.processor_time[17]);
        }

        @Override
        protected double getBaseProcessPower() {
            if (this.recipe == null) {
                return NCConfig.processor_power_multiplier * (double)NCConfig.processor_power[17];
            }
            return this.recipe.getBaseProcessPower(NCConfig.processor_power_multiplier * (double)NCConfig.processor_power[17]);
        }
    }

    public static class Extractor
    extends JEIMachineRecipeWrapper<Extractor> {
        public Extractor(IGuiHelper guiHelper, NCJEI.IJEIHandler<Extractor> jeiHandler, BasicRecipeHandler recipeHandler, BasicRecipe recipe) {
            super(guiHelper, jeiHandler, recipeHandler, recipe, 33, 30, 176, 3, 37, 18, 60, 34, 59, 34, 37, 18);
        }

        @Override
        protected double getBaseProcessTime() {
            if (this.recipe == null) {
                return NCConfig.processor_time_multiplier * (double)NCConfig.processor_time[16];
            }
            return this.recipe.getBaseProcessTime(NCConfig.processor_time_multiplier * (double)NCConfig.processor_time[16]);
        }

        @Override
        protected double getBaseProcessPower() {
            if (this.recipe == null) {
                return NCConfig.processor_power_multiplier * (double)NCConfig.processor_power[16];
            }
            return this.recipe.getBaseProcessPower(NCConfig.processor_power_multiplier * (double)NCConfig.processor_power[16]);
        }
    }

    public static class Enricher
    extends JEIMachineRecipeWrapper<Enricher> {
        public Enricher(IGuiHelper guiHelper, NCJEI.IJEIHandler<Enricher> jeiHandler, BasicRecipeHandler recipeHandler, BasicRecipe recipe) {
            super(guiHelper, jeiHandler, recipeHandler, recipe, 45, 30, 176, 3, 37, 16, 84, 35, 83, 34, 37, 18);
        }

        @Override
        protected double getBaseProcessTime() {
            if (this.recipe == null) {
                return NCConfig.processor_time_multiplier * (double)NCConfig.processor_time[15];
            }
            return this.recipe.getBaseProcessTime(NCConfig.processor_time_multiplier * (double)NCConfig.processor_time[15]);
        }

        @Override
        protected double getBaseProcessPower() {
            if (this.recipe == null) {
                return NCConfig.processor_power_multiplier * (double)NCConfig.processor_power[15];
            }
            return this.recipe.getBaseProcessPower(NCConfig.processor_power_multiplier * (double)NCConfig.processor_power[15]);
        }
    }

    public static class Crystallizer
    extends JEIMachineRecipeWrapper<Crystallizer> {
        public Crystallizer(IGuiHelper guiHelper, NCJEI.IJEIHandler<Crystallizer> jeiHandler, BasicRecipeHandler recipeHandler, BasicRecipe recipe) {
            super(guiHelper, jeiHandler, recipeHandler, recipe, 47, 30, 176, 3, 37, 16, 74, 35, 73, 34, 37, 18);
        }

        @Override
        protected double getBaseProcessTime() {
            if (this.recipe == null) {
                return NCConfig.processor_time_multiplier * (double)NCConfig.processor_time[14];
            }
            return this.recipe.getBaseProcessTime(NCConfig.processor_time_multiplier * (double)NCConfig.processor_time[14]);
        }

        @Override
        protected double getBaseProcessPower() {
            if (this.recipe == null) {
                return NCConfig.processor_power_multiplier * (double)NCConfig.processor_power[14];
            }
            return this.recipe.getBaseProcessPower(NCConfig.processor_power_multiplier * (double)NCConfig.processor_power[14]);
        }
    }

    public static class SaltMixer
    extends JEIMachineRecipeWrapper<SaltMixer> {
        public SaltMixer(IGuiHelper guiHelper, NCJEI.IJEIHandler<SaltMixer> jeiHandler, BasicRecipeHandler recipeHandler, BasicRecipe recipe) {
            super(guiHelper, jeiHandler, recipeHandler, recipe, 45, 30, 176, 3, 37, 18, 84, 34, 83, 34, 37, 18);
        }

        @Override
        protected double getBaseProcessTime() {
            if (this.recipe == null) {
                return NCConfig.processor_time_multiplier * (double)NCConfig.processor_time[13];
            }
            return this.recipe.getBaseProcessTime(NCConfig.processor_time_multiplier * (double)NCConfig.processor_time[13]);
        }

        @Override
        protected double getBaseProcessPower() {
            if (this.recipe == null) {
                return NCConfig.processor_power_multiplier * (double)NCConfig.processor_power[13];
            }
            return this.recipe.getBaseProcessPower(NCConfig.processor_power_multiplier * (double)NCConfig.processor_power[13]);
        }
    }

    public static class ChemicalReactor
    extends JEIMachineRecipeWrapper<ChemicalReactor> {
        public ChemicalReactor(IGuiHelper guiHelper, NCJEI.IJEIHandler<ChemicalReactor> jeiHandler, BasicRecipeHandler recipeHandler, BasicRecipe recipe) {
            super(guiHelper, jeiHandler, recipeHandler, recipe, 31, 30, 176, 3, 37, 18, 70, 34, 69, 34, 37, 18);
        }

        @Override
        protected double getBaseProcessTime() {
            if (this.recipe == null) {
                return NCConfig.processor_time_multiplier * (double)NCConfig.processor_time[12];
            }
            return this.recipe.getBaseProcessTime(NCConfig.processor_time_multiplier * (double)NCConfig.processor_time[12]);
        }

        @Override
        protected double getBaseProcessPower() {
            if (this.recipe == null) {
                return NCConfig.processor_power_multiplier * (double)NCConfig.processor_power[12];
            }
            return this.recipe.getBaseProcessPower(NCConfig.processor_power_multiplier * (double)NCConfig.processor_power[12]);
        }
    }

    public static class Pressurizer
    extends JEIMachineRecipeWrapper<Pressurizer> {
        public Pressurizer(IGuiHelper guiHelper, NCJEI.IJEIHandler<Pressurizer> jeiHandler, BasicRecipeHandler recipeHandler, BasicRecipe recipe) {
            super(guiHelper, jeiHandler, recipeHandler, recipe, 47, 30, 176, 3, 37, 16, 74, 35, 73, 34, 37, 18);
        }

        @Override
        protected double getBaseProcessTime() {
            if (this.recipe == null) {
                return NCConfig.processor_time_multiplier * (double)NCConfig.processor_time[11];
            }
            return this.recipe.getBaseProcessTime(NCConfig.processor_time_multiplier * (double)NCConfig.processor_time[11]);
        }

        @Override
        protected double getBaseProcessPower() {
            if (this.recipe == null) {
                return NCConfig.processor_power_multiplier * (double)NCConfig.processor_power[11];
            }
            return this.recipe.getBaseProcessPower(NCConfig.processor_power_multiplier * (double)NCConfig.processor_power[11]);
        }
    }

    public static class IngotFormer
    extends JEIMachineRecipeWrapper<IngotFormer> {
        public IngotFormer(IGuiHelper guiHelper, NCJEI.IJEIHandler<IngotFormer> jeiHandler, BasicRecipeHandler recipeHandler, BasicRecipe recipe) {
            super(guiHelper, jeiHandler, recipeHandler, recipe, 47, 30, 176, 3, 37, 16, 74, 35, 73, 34, 37, 18);
        }

        @Override
        protected double getBaseProcessTime() {
            if (this.recipe == null) {
                return NCConfig.processor_time_multiplier * (double)NCConfig.processor_time[10];
            }
            return this.recipe.getBaseProcessTime(NCConfig.processor_time_multiplier * (double)NCConfig.processor_time[10]);
        }

        @Override
        protected double getBaseProcessPower() {
            if (this.recipe == null) {
                return NCConfig.processor_power_multiplier * (double)NCConfig.processor_power[10];
            }
            return this.recipe.getBaseProcessPower(NCConfig.processor_power_multiplier * (double)NCConfig.processor_power[10]);
        }
    }

    public static class Assembler
    extends JEIMachineRecipeWrapper<Assembler> {
        public Assembler(IGuiHelper guiHelper, NCJEI.IJEIHandler<Assembler> jeiHandler, BasicRecipeHandler recipeHandler, BasicRecipe recipe) {
            super(guiHelper, jeiHandler, recipeHandler, recipe, 45, 30, 176, 3, 37, 36, 84, 31, 83, 30, 37, 38);
        }

        @Override
        protected double getBaseProcessTime() {
            if (this.recipe == null) {
                return NCConfig.processor_time_multiplier * (double)NCConfig.processor_time[9];
            }
            return this.recipe.getBaseProcessTime(NCConfig.processor_time_multiplier * (double)NCConfig.processor_time[9]);
        }

        @Override
        protected double getBaseProcessPower() {
            if (this.recipe == null) {
                return NCConfig.processor_power_multiplier * (double)NCConfig.processor_power[9];
            }
            return this.recipe.getBaseProcessPower(NCConfig.processor_power_multiplier * (double)NCConfig.processor_power[9]);
        }
    }

    public static class Electrolyzer
    extends JEIMachineRecipeWrapper<Electrolyzer> {
        public Electrolyzer(IGuiHelper guiHelper, NCJEI.IJEIHandler<Electrolyzer> jeiHandler, BasicRecipeHandler recipeHandler, BasicRecipe recipe) {
            super(guiHelper, jeiHandler, recipeHandler, recipe, 49, 30, 176, 3, 37, 38, 68, 30, 67, 30, 37, 38);
        }

        @Override
        protected double getBaseProcessTime() {
            if (this.recipe == null) {
                return NCConfig.processor_time_multiplier * (double)NCConfig.processor_time[8];
            }
            return this.recipe.getBaseProcessTime(NCConfig.processor_time_multiplier * (double)NCConfig.processor_time[8]);
        }

        @Override
        protected double getBaseProcessPower() {
            if (this.recipe == null) {
                return NCConfig.processor_power_multiplier * (double)NCConfig.processor_power[8];
            }
            return this.recipe.getBaseProcessPower(NCConfig.processor_power_multiplier * (double)NCConfig.processor_power[8]);
        }
    }

    public static class Supercooler
    extends JEIMachineRecipeWrapper<Supercooler> {
        public Supercooler(IGuiHelper guiHelper, NCJEI.IJEIHandler<Supercooler> jeiHandler, BasicRecipeHandler recipeHandler, BasicRecipe recipe) {
            super(guiHelper, jeiHandler, recipeHandler, recipe, 47, 30, 176, 3, 37, 16, 74, 35, 73, 34, 37, 18);
        }

        @Override
        protected double getBaseProcessTime() {
            if (this.recipe == null) {
                return NCConfig.processor_time_multiplier * (double)NCConfig.processor_time[7];
            }
            return this.recipe.getBaseProcessTime(NCConfig.processor_time_multiplier * (double)NCConfig.processor_time[7]);
        }

        @Override
        protected double getBaseProcessPower() {
            if (this.recipe == null) {
                return NCConfig.processor_power_multiplier * (double)NCConfig.processor_power[7];
            }
            return this.recipe.getBaseProcessPower(NCConfig.processor_power_multiplier * (double)NCConfig.processor_power[7]);
        }
    }

    public static class Melter
    extends JEIMachineRecipeWrapper<Melter> {
        public Melter(IGuiHelper guiHelper, NCJEI.IJEIHandler<Melter> jeiHandler, BasicRecipeHandler recipeHandler, BasicRecipe recipe) {
            super(guiHelper, jeiHandler, recipeHandler, recipe, 47, 30, 176, 3, 37, 16, 74, 35, 73, 34, 37, 18);
        }

        @Override
        protected double getBaseProcessTime() {
            if (this.recipe == null) {
                return NCConfig.processor_time_multiplier * (double)NCConfig.processor_time[6];
            }
            return this.recipe.getBaseProcessTime(NCConfig.processor_time_multiplier * (double)NCConfig.processor_time[6]);
        }

        @Override
        protected double getBaseProcessPower() {
            if (this.recipe == null) {
                return NCConfig.processor_power_multiplier * (double)NCConfig.processor_power[6];
            }
            return this.recipe.getBaseProcessPower(NCConfig.processor_power_multiplier * (double)NCConfig.processor_power[6]);
        }
    }

    public static class Infuser
    extends JEIMachineRecipeWrapper<Infuser> {
        public Infuser(IGuiHelper guiHelper, NCJEI.IJEIHandler<Infuser> jeiHandler, BasicRecipeHandler recipeHandler, BasicRecipe recipe) {
            super(guiHelper, jeiHandler, recipeHandler, recipe, 45, 30, 176, 3, 37, 16, 84, 35, 83, 34, 37, 18);
        }

        @Override
        protected double getBaseProcessTime() {
            if (this.recipe == null) {
                return NCConfig.processor_time_multiplier * (double)NCConfig.processor_time[5];
            }
            return this.recipe.getBaseProcessTime(NCConfig.processor_time_multiplier * (double)NCConfig.processor_time[5]);
        }

        @Override
        protected double getBaseProcessPower() {
            if (this.recipe == null) {
                return NCConfig.processor_power_multiplier * (double)NCConfig.processor_power[5];
            }
            return this.recipe.getBaseProcessPower(NCConfig.processor_power_multiplier * (double)NCConfig.processor_power[5]);
        }
    }

    public static class AlloyFurnace
    extends JEIMachineRecipeWrapper<AlloyFurnace> {
        public AlloyFurnace(IGuiHelper guiHelper, NCJEI.IJEIHandler<AlloyFurnace> jeiHandler, BasicRecipeHandler recipeHandler, BasicRecipe recipe) {
            super(guiHelper, jeiHandler, recipeHandler, recipe, 45, 30, 176, 3, 37, 16, 84, 35, 83, 34, 37, 18);
        }

        @Override
        protected double getBaseProcessTime() {
            if (this.recipe == null) {
                return NCConfig.processor_time_multiplier * (double)NCConfig.processor_time[4];
            }
            return this.recipe.getBaseProcessTime(NCConfig.processor_time_multiplier * (double)NCConfig.processor_time[4]);
        }

        @Override
        protected double getBaseProcessPower() {
            if (this.recipe == null) {
                return NCConfig.processor_power_multiplier * (double)NCConfig.processor_power[4];
            }
            return this.recipe.getBaseProcessPower(NCConfig.processor_power_multiplier * (double)NCConfig.processor_power[4]);
        }
    }

    public static class FuelReprocessor
    extends JEIMachineRecipeWrapper<FuelReprocessor> {
        public FuelReprocessor(IGuiHelper guiHelper, NCJEI.IJEIHandler<FuelReprocessor> jeiHandler, BasicRecipeHandler recipeHandler, BasicRecipe recipe) {
            super(guiHelper, jeiHandler, recipeHandler, recipe, 29, 30, 176, 3, 37, 38, 48, 30, 47, 30, 37, 38);
        }

        @Override
        protected double getBaseProcessTime() {
            if (this.recipe == null) {
                return NCConfig.processor_time_multiplier * (double)NCConfig.processor_time[3];
            }
            return this.recipe.getBaseProcessTime(NCConfig.processor_time_multiplier * (double)NCConfig.processor_time[3]);
        }

        @Override
        protected double getBaseProcessPower() {
            if (this.recipe == null) {
                return NCConfig.processor_power_multiplier * (double)NCConfig.processor_power[3];
            }
            return this.recipe.getBaseProcessPower(NCConfig.processor_power_multiplier * (double)NCConfig.processor_power[3]);
        }
    }

    public static class DecayHastener
    extends JEIMachineRecipeWrapper<DecayHastener> {
        public DecayHastener(IGuiHelper guiHelper, NCJEI.IJEIHandler<DecayHastener> jeiHandler, BasicRecipeHandler recipeHandler, BasicRecipe recipe) {
            super(guiHelper, jeiHandler, recipeHandler, recipe, 47, 30, 176, 3, 37, 16, 74, 35, 73, 34, 37, 18);
        }

        @Override
        protected double getBaseProcessTime() {
            if (this.recipe == null) {
                return NCConfig.processor_time_multiplier * (double)NCConfig.processor_time[2];
            }
            return this.recipe.getBaseProcessTime(NCConfig.processor_time_multiplier * (double)NCConfig.processor_time[2]);
        }

        @Override
        protected double getBaseProcessPower() {
            if (this.recipe == null) {
                return NCConfig.processor_power_multiplier * (double)NCConfig.processor_power[2];
            }
            return this.recipe.getBaseProcessPower(NCConfig.processor_power_multiplier * (double)NCConfig.processor_power[2]);
        }
    }

    public static class Separator
    extends JEIMachineRecipeWrapper<Separator> {
        public Separator(IGuiHelper guiHelper, NCJEI.IJEIHandler<Separator> jeiHandler, BasicRecipeHandler recipeHandler, BasicRecipe recipe) {
            super(guiHelper, jeiHandler, recipeHandler, recipe, 33, 30, 176, 3, 37, 18, 60, 34, 59, 34, 37, 18);
        }

        @Override
        protected double getBaseProcessTime() {
            if (this.recipe == null) {
                return NCConfig.processor_time_multiplier * (double)NCConfig.processor_time[1];
            }
            return this.recipe.getBaseProcessTime(NCConfig.processor_time_multiplier * (double)NCConfig.processor_time[1]);
        }

        @Override
        protected double getBaseProcessPower() {
            if (this.recipe == null) {
                return NCConfig.processor_power_multiplier * (double)NCConfig.processor_power[1];
            }
            return this.recipe.getBaseProcessPower(NCConfig.processor_power_multiplier * (double)NCConfig.processor_power[1]);
        }
    }

    public static class Manufactory
    extends JEIMachineRecipeWrapper<Manufactory> {
        public Manufactory(IGuiHelper guiHelper, NCJEI.IJEIHandler<Manufactory> jeiHandler, BasicRecipeHandler recipeHandler, BasicRecipe recipe) {
            super(guiHelper, jeiHandler, recipeHandler, recipe, 47, 30, 176, 3, 37, 16, 74, 35, 73, 34, 37, 18);
        }

        @Override
        protected double getBaseProcessTime() {
            if (this.recipe == null) {
                return NCConfig.processor_time_multiplier * (double)NCConfig.processor_time[0];
            }
            return this.recipe.getBaseProcessTime(NCConfig.processor_time_multiplier * (double)NCConfig.processor_time[0]);
        }

        @Override
        protected double getBaseProcessPower() {
            if (this.recipe == null) {
                return NCConfig.processor_power_multiplier * (double)NCConfig.processor_power[0];
            }
            return this.recipe.getBaseProcessPower(NCConfig.processor_power_multiplier * (double)NCConfig.processor_power[0]);
        }
    }
}

