/*
 * Decompiled with CFR 0.152.
 */
package nc.integration.jei;

import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import nc.integration.jei.NCJEI;
import nc.recipe.BasicRecipe;
import nc.recipe.BasicRecipeHandler;
import nc.recipe.RecipeHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public abstract class JEIBasicRecipeWrapper<WRAPPER extends JEIBasicRecipeWrapper<WRAPPER>>
implements IRecipeWrapper {
    public final BasicRecipeHandler recipeHandler;
    public final BasicRecipe recipe;
    public final List<List<ItemStack>> itemInputs;
    public final List<List<FluidStack>> fluidInputs;
    public final List<List<ItemStack>> itemOutputs;
    public final List<List<FluidStack>> fluidOutputs;
    public final boolean drawArrow;
    public final IDrawable arrow;
    public final int arrowDrawPosX;
    public final int arrowDrawPosY;

    public JEIBasicRecipeWrapper(IGuiHelper guiHelper, NCJEI.IJEIHandler<WRAPPER> handler, BasicRecipeHandler recipeHandler, BasicRecipe recipe, int backX, int backY, int arrowX, int arrowY, int arrowWidth, int arrowHeight, int arrowPosX, int arrowPosY) {
        this.recipeHandler = recipeHandler;
        this.recipe = recipe;
        this.itemInputs = RecipeHelper.getItemInputLists(recipe.getItemIngredients());
        this.fluidInputs = RecipeHelper.getFluidInputLists(recipe.getFluidIngredients());
        this.itemOutputs = RecipeHelper.getItemOutputLists(recipe.getItemProducts());
        this.fluidOutputs = RecipeHelper.getFluidOutputLists(recipe.getFluidProducts());
        this.drawArrow = arrowWidth > 0 && arrowHeight > 0;
        ResourceLocation location = new ResourceLocation("nuclearcraft:textures/gui/container/" + handler.getTextureName() + ".png");
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(location, arrowX, arrowY, Math.max(arrowWidth, 1), Math.max(arrowHeight, 1));
        this.arrow = this.staticArrow() ? arrowDrawable : guiHelper.createAnimatedDrawable(arrowDrawable, this.getProgressArrowTime(), IDrawableAnimated.StartDirection.LEFT, false);
        this.arrowDrawPosX = arrowPosX - backX;
        this.arrowDrawPosY = arrowPosY - backY;
    }

    protected abstract int getProgressArrowTime();

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, this.itemInputs);
        ingredients.setInputLists(FluidStack.class, this.fluidInputs);
        ingredients.setOutputLists(ItemStack.class, this.itemOutputs);
        ingredients.setOutputLists(FluidStack.class, this.fluidOutputs);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        if (this.drawArrow) {
            this.arrow.draw(minecraft, this.arrowDrawPosX, this.arrowDrawPosY);
        }
    }

    protected boolean staticArrow() {
        return this.getProgressArrowTime() < 2;
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        return null;
    }

    public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        return false;
    }
}

