/*
 * Decompiled with CFR 0.152.
 */
package nc.integration.crafttweaker.ingredient;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemCondition;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.IItemTransformer;
import crafttweaker.api.item.IItemTransformerNew;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.player.IPlayer;
import java.util.List;
import nc.integration.crafttweaker.CTHelper;
import nc.recipe.ingredient.ChanceFluidIngredient;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.nuclearcraft.ChanceFluidIngredient")
@ZenRegister
public class CTChanceFluidIngredient
implements IIngredient {
    private final IIngredient internalIngredient;
    private final int chancePercent;
    private final int stackDiff;
    private final int minStackSize;
    private final ChanceFluidIngredient chanceIngredient;

    private CTChanceFluidIngredient(IIngredient ingredient, int chancePercent, int stackDiff, int minStackSize) {
        this.internalIngredient = ingredient;
        this.chancePercent = chancePercent;
        this.stackDiff = stackDiff;
        this.minStackSize = minStackSize;
        this.chanceIngredient = new ChanceFluidIngredient(CTHelper.buildAdditionFluidIngredient(ingredient), chancePercent, stackDiff, minStackSize);
    }

    @ZenMethod
    public static CTChanceFluidIngredient create(IIngredient ingredient, int chancePercent, int stackDiff, @Optional int minStackSize) {
        return new CTChanceFluidIngredient(ingredient, chancePercent, stackDiff, minStackSize);
    }

    @ZenMethod
    public IIngredient getInternalIngredient() {
        return this.internalIngredient;
    }

    @ZenMethod
    public int getChancePercent() {
        return this.chancePercent;
    }

    @ZenMethod
    public int getStackDiff() {
        return this.stackDiff;
    }

    @ZenMethod
    public int getMinStackSize() {
        return this.minStackSize;
    }

    public String getMark() {
        return this.internalIngredient.getMark();
    }

    public int getAmount() {
        return this.internalIngredient.getAmount();
    }

    public List<IItemStack> getItems() {
        return this.internalIngredient.getItems();
    }

    public IItemStack[] getItemArray() {
        return this.internalIngredient.getItemArray();
    }

    public List<ILiquidStack> getLiquids() {
        return this.internalIngredient.getLiquids();
    }

    public IIngredient amount(int amount) {
        return this.internalIngredient.amount(amount);
    }

    public IIngredient or(IIngredient ingredient) {
        return this.internalIngredient.or(ingredient);
    }

    public IIngredient transformNew(IItemTransformerNew transformer) {
        return this.internalIngredient.transformNew(transformer);
    }

    public IIngredient only(IItemCondition condition) {
        return this.internalIngredient.only(condition);
    }

    public IIngredient marked(String mark) {
        return this.internalIngredient.marked(mark);
    }

    public boolean matches(IItemStack item) {
        return this.internalIngredient.matches(item);
    }

    public boolean matchesExact(IItemStack item) {
        return this.internalIngredient.matchesExact(item);
    }

    public boolean matches(ILiquidStack liquid) {
        return this.internalIngredient.matches(liquid);
    }

    public boolean contains(IIngredient ingredient) {
        return this.internalIngredient.contains(ingredient);
    }

    public IItemStack applyTransform(IItemStack item, IPlayer byPlayer) {
        return this.internalIngredient.applyTransform(item, byPlayer);
    }

    public IItemStack applyNewTransform(IItemStack item) {
        return this.internalIngredient.applyNewTransform(item);
    }

    public boolean hasNewTransformers() {
        return this.internalIngredient.hasNewTransformers();
    }

    public boolean hasTransformers() {
        return this.internalIngredient.hasTransformers();
    }

    public IIngredient transform(IItemTransformer transformer) {
        return this.internalIngredient.transform(transformer);
    }

    public Object getInternal() {
        return this.chanceIngredient;
    }

    public String toCommandString() {
        return this.chanceIngredient.getIngredientName();
    }
}

