/*
 * Decompiled with CFR 0.152.
 */
package nc.integration.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.mc1120.util.CraftTweakerPlatformUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import nc.NCInfo;
import nc.block.item.energy.ItemBlockBattery;
import nc.config.NCConfig;
import nc.handler.OreDictHandler;
import nc.init.NCBlocks;
import nc.init.NCFissionFluids;
import nc.init.NCItems;
import nc.item.NCItemMetaArray;
import nc.multiblock.battery.block.BlockBattery;
import nc.multiblock.battery.tile.TileBattery;
import nc.multiblock.fission.FissionPlacement;
import nc.multiblock.fission.block.BlockFissionShield;
import nc.multiblock.fission.block.BlockFissionSource;
import nc.multiblock.fission.block.port.BlockFissionFluidPort;
import nc.multiblock.fission.salt.block.BlockSaltFissionHeater;
import nc.multiblock.fission.salt.tile.TileSaltFissionHeater;
import nc.multiblock.fission.solid.block.BlockSolidFissionSink;
import nc.multiblock.fission.solid.tile.TileSolidFissionSink;
import nc.multiblock.fission.tile.TileFissionShield;
import nc.multiblock.fission.tile.TileFissionSource;
import nc.multiblock.fission.tile.port.TileFissionHeaterPort;
import nc.multiblock.rtg.block.BlockRTG;
import nc.multiblock.rtg.tile.TileRTG;
import nc.multiblock.turbine.TurbinePlacement;
import nc.multiblock.turbine.TurbineRotorBladeUtil;
import nc.multiblock.turbine.block.BlockTurbineDynamoCoil;
import nc.multiblock.turbine.block.BlockTurbineRotorBlade;
import nc.multiblock.turbine.block.BlockTurbineRotorStator;
import nc.multiblock.turbine.tile.TileTurbineDynamoCoil;
import nc.multiblock.turbine.tile.TileTurbineRotorBlade;
import nc.multiblock.turbine.tile.TileTurbineRotorStator;
import nc.radiation.RadSources;
import nc.recipe.AbstractRecipeHandler;
import nc.recipe.NCRecipes;
import nc.recipe.ingredient.EmptyFluidIngredient;
import nc.tab.NCTabs;
import nc.util.IOHelper;
import nc.util.InfoHelper;
import nc.util.Lang;
import nc.util.NCMath;
import nc.util.NCUtil;
import nc.util.StringHelper;
import nc.util.UnitHelper;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.io.FileUtils;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.nuclearcraft.Registration")
@ZenRegister
public class CTRegistration {
    public static final List<RegistrationInfo> INFO_LIST = new ArrayList<RegistrationInfo>();
    public static final Object2ObjectMap<String, FissionIsotopeRegistrationInfo> FISSION_ISOTOPE_INFO_MAP = new Object2ObjectLinkedOpenHashMap();
    public static final Object2ObjectMap<String, FissionFuelRegistrationInfo> FISSION_FUEL_INFO_MAP = new Object2ObjectLinkedOpenHashMap();
    public static final double TRISO_TIME_MULT = 0.9;
    public static final double TRISO_HEAT_MULT = 1.1111111111111112;
    public static final double TRISO_CRIT_MULT = 0.9;
    public static final double[] SFR_TIME_MULT = new double[]{1.0, 1.25, 0.8};
    public static final double[] SFR_HEAT_MULT = new double[]{1.0, 0.8, 1.25};
    public static final double[] SFR_CRIT_MULT = new double[]{1.0, 1.25, 0.85};
    public static final double MSR_TIME_MULT = 1.25;
    public static final double MSR_HEAT_MULT = 0.8;
    public static final double MSR_CRIT_MULT = 1.0;

    @ZenMethod
    public static void registerFissionSink(final String sinkID, final int cooling, String rule) {
        Block sink = NCBlocks.withName(new BlockSolidFissionSink(){

            public TileEntity func_149915_a(World world, int metadata) {
                return new TileSolidFissionSink(sinkID, cooling, sinkID + "_sink");
            }
        }, "solid_fission_sink_" + sinkID);
        INFO_LIST.add(new FissionSinkRegistrationInfo(sink, sinkID, cooling, rule));
        CraftTweakerAPI.logInfo((String)("Registered fission heat sink with ID \"" + sinkID + "\", cooling rate " + cooling + " H/t and placement rule \"" + rule + "\""));
    }

    @ZenMethod
    public static void registerFissionHeater(final String heaterID, final String fluidInput, int inputAmount, String fluidOutput, int outputAmount, int cooling, String rule) {
        Block port = NCBlocks.withName(new BlockFissionFluidPort<TileFissionHeaterPort, TileSaltFissionHeater>(TileFissionHeaterPort.class, 303){

            public TileEntity func_149915_a(World world, int metadata) {
                return new TileFissionHeaterPort(heaterID, fluidInput);
            }
        }, "fission_heater_port_" + heaterID);
        Block heater = NCBlocks.withName(new BlockSaltFissionHeater(){

            public TileEntity func_149915_a(World world, int metadata) {
                return new TileSaltFissionHeater(heaterID, fluidInput);
            }
        }, "salt_fission_heater_" + heaterID);
        INFO_LIST.add(new FissionHeaterPortRegistrationInfo(port, heaterID));
        INFO_LIST.add(new FissionHeaterRegistrationInfo(heater, heaterID, fluidInput, inputAmount, fluidOutput, outputAmount, cooling, rule));
        CraftTweakerAPI.logInfo((String)("Registered fission coolant heater and a respective port with ID \"" + heaterID + "\", cooling rate " + cooling + " H/t, placement rule \"" + rule + "\" and recipe [" + inputAmount + " * " + fluidInput + " -> " + outputAmount + " * " + fluidOutput + "]"));
    }

    @ZenMethod
    public static void registerFissionSource(String sourceID, final double efficiency) {
        Block source = NCBlocks.withName(new BlockFissionSource(){

            public TileEntity func_149915_a(World world, int metadata) {
                return new TileFissionSource(efficiency);
            }
        }, "fission_source_" + sourceID);
        INFO_LIST.add(new FissionSourceRegistrationInfo(source, efficiency));
        CraftTweakerAPI.logInfo((String)("Registered fission neutron source with ID \"" + sourceID + "\" and efficiency " + efficiency));
    }

    @ZenMethod
    public static void registerFissionShield(String shieldID, final double heatPerFlux, final double efficiency) {
        Block shield = NCBlocks.withName(new BlockFissionShield(){

            public TileEntity func_149915_a(World world, int metadata) {
                return new TileFissionShield(heatPerFlux, efficiency);
            }
        }, "fission_shield_" + shieldID);
        INFO_LIST.add(new FissionShieldRegistrationInfo(shield, heatPerFlux, efficiency));
        CraftTweakerAPI.logInfo((String)("Registered fission neutron shield with ID \"" + shieldID + "\", heat per flux " + heatPerFlux + " H/N and efficiency " + efficiency));
    }

    @ZenMethod
    public static void registerTurbineCoil(final String coilID, final double conductivity, String rule) {
        Block coil = NCBlocks.withName(new BlockTurbineDynamoCoil(){

            public TileEntity func_149915_a(World world, int metadata) {
                return new TileTurbineDynamoCoil(coilID, conductivity, coilID + "_coil");
            }
        }, "turbine_dynamo_coil_" + coilID);
        INFO_LIST.add(new TurbineCoilRegistrationInfo(coil, coilID, conductivity, rule));
        CraftTweakerAPI.logInfo((String)("Registered turbine dynamo coil with ID \"" + coilID + "\", conductivity " + conductivity + " and placement rule \"" + rule + "\""));
    }

    @ZenMethod
    public static void registerTurbineBlade(final String bladeID, final double efficiency, final double expansionCoefficient) {
        final TurbineRotorBladeUtil.IRotorBladeType bladeType = new TurbineRotorBladeUtil.IRotorBladeType(){

            public String func_176610_l() {
                return bladeID;
            }

            @Override
            public double getEfficiency() {
                return efficiency;
            }

            @Override
            public double getExpansionCoefficient() {
                return expansionCoefficient;
            }
        };
        Block blade = NCBlocks.withName(new BlockTurbineRotorBlade(null){

            @Override
            public TileEntity func_149915_a(World world, int metadata) {
                return new TileTurbineRotorBlade(bladeType);
            }
        }, "turbine_rotor_blade_" + bladeID);
        INFO_LIST.add(new TurbineBladeRegistrationInfo(blade, efficiency, expansionCoefficient));
        CraftTweakerAPI.logInfo((String)("Registered turbine rotor blade with ID \"" + bladeID + "\", efficiency " + efficiency + " and expansion coefficient " + expansionCoefficient));
    }

    @ZenMethod
    public static void registerTurbineStator(final String statorID, final double expansionCoefficient) {
        final TurbineRotorBladeUtil.IRotorStatorType statorType = new TurbineRotorBladeUtil.IRotorStatorType(){

            public String func_176610_l() {
                return statorID;
            }

            @Override
            public double getExpansionCoefficient() {
                return expansionCoefficient;
            }
        };
        Block stator = NCBlocks.withName(new BlockTurbineRotorStator(){

            @Override
            public TileEntity func_149915_a(World world, int metadata) {
                return new TileTurbineRotorStator(statorType);
            }
        }, "turbine_rotor_stator_" + statorID);
        INFO_LIST.add(new TurbineStatorRegistrationInfo(stator, expansionCoefficient));
        CraftTweakerAPI.logInfo((String)("Registered turbine rotor stator with ID \"" + statorID + "\" and expansion coefficient " + expansionCoefficient));
    }

    @ZenMethod
    public static void registerRTG(String rtgID, final long power, final double radiation) {
        Block rtg = NCBlocks.withName(new BlockRTG(null){

            @Override
            public TileEntity func_149915_a(World world, int metadata) {
                return new TileRTG(power, radiation);
            }
        }, "rtg_" + rtgID);
        INFO_LIST.add(new RTGRegistrationInfo(rtg, power));
        CraftTweakerAPI.logInfo((String)("Registered RTG with ID \"" + rtgID + "\", power " + power + " RF/t and radiation " + radiation + " Rad/t"));
    }

    @ZenMethod
    public static void registerBattery(String batteryID, final long capacity, final int energyTier) {
        Block battery = NCBlocks.withName(new BlockBattery(null){

            @Override
            public TileEntity func_149915_a(World world, int metadata) {
                return new TileBattery(capacity, energyTier);
            }
        }, "battery_" + batteryID);
        INFO_LIST.add(new BatteryRegistrationInfo(battery, capacity, energyTier));
        CraftTweakerAPI.logInfo((String)("Registered battery with ID \"" + batteryID + "\", capacity " + capacity + " RF/t and energy tier " + energyTier));
    }

    private static void addFissionIsotopeItem(FissionIsotopeRegistrationInfo info, String name, String model, String ore) {
        info.types.add(name);
        info.models.add(model);
        info.textures.add(name);
        info.ores.add(ore);
    }

    @ZenMethod
    public static void registerFissionIsotope(String item_, String name_, String model, String ore_, double radiation, boolean raw, boolean carbide, boolean oxide, boolean nitride, boolean zirconiumAlloy, @Optional(valueLong=-9223372036854775808L) long fluidColor) {
        FissionIsotopeRegistrationInfo info;
        String item = item_.toLowerCase(Locale.ROOT);
        String name = name_.toLowerCase(Locale.ROOT);
        String ore = StringHelper.capitalize(ore_);
        if (FISSION_ISOTOPE_INFO_MAP.containsKey((Object)item)) {
            info = (FissionIsotopeRegistrationInfo)FISSION_ISOTOPE_INFO_MAP.get((Object)item);
        } else {
            info = new FissionIsotopeRegistrationInfo(item);
            FISSION_ISOTOPE_INFO_MAP.put((Object)item, (Object)info);
            INFO_LIST.add(info);
        }
        if (raw || carbide || oxide || nitride || zirconiumAlloy) {
            info.rawNames.add(name);
            info.rawOres.add(ore);
        } else {
            info.rawNames.add(null);
            info.rawOres.add(null);
        }
        if (fluidColor != Long.MIN_VALUE) {
            info.rawFluids.add(name);
            info.rawFluidColors.add((int)fluidColor);
        } else {
            info.rawFluids.add(null);
            info.rawFluidColors.add(0);
        }
        if (raw) {
            CTRegistration.addFissionIsotopeItem(info, name, model, "ingot" + ore);
        }
        if (carbide) {
            CTRegistration.addFissionIsotopeItem(info, name + "_c", model, "ingot" + ore + "Carbide");
        }
        if (oxide) {
            CTRegistration.addFissionIsotopeItem(info, name + "_ox", model, "ingot" + ore + "Oxide");
        }
        if (nitride) {
            CTRegistration.addFissionIsotopeItem(info, name + "_ni", model, "ingot" + ore + "Nitride");
        }
        if (zirconiumAlloy) {
            CTRegistration.addFissionIsotopeItem(info, name + "_za", model, "ingot" + ore + "ZA");
        }
        RadSources.RUNNABLES.add(() -> RadSources.putIsotope(radiation, ore, name));
        CraftTweakerAPI.logInfo((String)("Registered fission isotope with name \"" + name + "\", ore dict base entry \"" + ore + "\" and radiation " + radiation + " Rad/t"));
    }

    private static void addFissionFuelItem(FissionFuelRegistrationInfo info, String name, String model, String ore) {
        info.types.add(name);
        info.models.add(model);
        info.textures.add(name);
        info.ores.add(ore);
    }

    @ZenMethod
    public static void registerFissionFuel(String item_, String name_, String model, String ore_, int time, int heat, double efficiency, int crit, double decay, boolean prime, double fissionRadiation, double fuelRadiation, double depletedRadiation, boolean raw, boolean carbide, boolean triso, boolean oxide, boolean nitride, boolean zirconiumAlloy, @Optional(valueLong=-9223372036854775808L) long fluidColor, @Optional(valueLong=-9223372036854775808L) long depletedFluidColor) {
        FissionFuelRegistrationInfo info;
        String item = item_.toLowerCase(Locale.ROOT);
        String name = name_.toLowerCase(Locale.ROOT);
        String ore = StringHelper.capitalize(ore_);
        if (FISSION_FUEL_INFO_MAP.containsKey((Object)item)) {
            info = (FissionFuelRegistrationInfo)FISSION_FUEL_INFO_MAP.get((Object)item);
        } else {
            info = new FissionFuelRegistrationInfo(item);
            FISSION_FUEL_INFO_MAP.put((Object)item, (Object)info);
            INFO_LIST.add(info);
        }
        if (raw || carbide || triso || oxide || nitride || zirconiumAlloy) {
            info.rawNames.add(name);
            info.rawOres.add(ore);
        } else {
            info.rawNames.add(null);
            info.rawOres.add(null);
        }
        if (fluidColor != Long.MIN_VALUE || depletedFluidColor != Long.MIN_VALUE) {
            info.rawFluids.add(name);
            info.rawFluidColors.add((int)fluidColor);
            info.rawDepletedFluidColors.add((int)depletedFluidColor);
        } else {
            info.rawFluids.add(null);
            info.rawFluidColors.add(0);
            info.rawDepletedFluidColors.add(0);
        }
        info.fissionStats.add(new FissionFuelStats(time, heat, efficiency, crit, decay, prime, fissionRadiation));
        if (raw) {
            CTRegistration.addFissionFuelItem(info, name, model, "ingot" + ore);
        }
        if (carbide) {
            CTRegistration.addFissionFuelItem(info, name + "_c", model, "ingot" + ore + "Carbide");
        }
        if (triso) {
            CTRegistration.addFissionFuelItem(info, name + "_tr", model, "ingot" + ore + "TRISO");
        }
        if (oxide) {
            CTRegistration.addFissionFuelItem(info, name + "_ox", model, "ingot" + ore + "Oxide");
        }
        if (nitride) {
            CTRegistration.addFissionFuelItem(info, name + "_ni", model, "ingot" + ore + "Nitride");
        }
        if (zirconiumAlloy) {
            CTRegistration.addFissionFuelItem(info, name + "_za", model, "ingot" + ore + "ZA");
        }
        if (triso) {
            CTRegistration.addFissionFuelItem(info, "depleted_" + name + "_tr", model, "ingotDepleted" + ore + "TRISO");
        }
        if (oxide) {
            CTRegistration.addFissionFuelItem(info, "depleted_" + name + "_ox", model, "ingotDepleted" + ore + "Oxide");
        }
        if (nitride) {
            CTRegistration.addFissionFuelItem(info, "depleted_" + name + "_ni", model, "ingotDepleted" + ore + "Nitride");
        }
        if (zirconiumAlloy) {
            CTRegistration.addFissionFuelItem(info, "depleted_" + name + "_za", model, "ingotDepleted" + ore + "ZA");
        }
        RadSources.RUNNABLES.add(() -> RadSources.putFuel(fuelRadiation, depletedRadiation, ore, name));
        CraftTweakerAPI.logInfo((String)("Registered fission fuel with name \"" + name + "\", item model \"" + model + "\", ore dict base entry \"" + ore + "\", radiation " + fuelRadiation + " Rad/t and depleted radiation " + depletedRadiation + " Rad/t"));
    }

    public static class FissionFuelRegistrationInfo
    extends MetaItemRegistrationInfo {
        public final List<String> rawNames = new ArrayList<String>();
        public final List<String> rawOres = new ArrayList<String>();
        public final List<String> rawFluids = new ArrayList<String>();
        public final IntList rawFluidColors = new IntArrayList();
        public final IntList rawDepletedFluidColors = new IntArrayList();
        public final List<FissionFuelStats> fissionStats = new ArrayList<FissionFuelStats>();
        public final List<String> ores = new ArrayList<String>();

        public FissionFuelRegistrationInfo(String name) {
            super(name, NCTabs.MATERIAL);
        }

        @Override
        public void preInit() {
            int i;
            super.preInit();
            if (this.item != null) {
                for (i = 0; i < this.types.size(); ++i) {
                    OreDictHandler.registerOre(this.item, i, this.ores.get(i));
                }
            }
            for (i = 0; i < this.rawFluids.size(); ++i) {
                String rawFluid = this.rawFluids.get(i);
                if (rawFluid == null) continue;
                NCFissionFluids.addFuelFluids(rawFluid, this.rawFluidColors.getInt(i));
                NCFissionFluids.addFuelFluids("depleted_" + rawFluid, this.rawDepletedFluidColors.getInt(i));
            }
        }

        @Override
        public void recipeInit() {
            if (this.item == null) {
                return;
            }
            for (int i = 0; i < this.rawOres.size(); ++i) {
                String rawOre = this.rawOres.get(i);
                String rawFluid = this.rawFluids.get(i);
                FissionFuelStats stats = this.fissionStats.get(i);
                if (rawOre != null) {
                    for (ItemStack output : OreDictionary.getOres((String)("ingot" + rawOre), (boolean)false)) {
                        for (ItemStack input : OreDictionary.getOres((String)("ingot" + rawOre + "Oxide"), (boolean)false)) {
                            GameRegistry.addSmelting((ItemStack)input, (ItemStack)output, (float)0.0f);
                        }
                        for (ItemStack input : OreDictionary.getOres((String)("ingot" + rawOre + "Nitride"), (boolean)false)) {
                            GameRegistry.addSmelting((ItemStack)input, (ItemStack)output, (float)0.0f);
                        }
                    }
                    NCRecipes.alloy_furnace.addAlloyIngotIngotRecipes(rawOre, 1, "Zirconium", 1, rawOre + "ZA", 1, 1.0, 1.0);
                    NCRecipes.alloy_furnace.addAlloyIngotIngotRecipes(rawOre, 1, "Graphite", 1, rawOre + "Carbide", 1, 1.0, 1.0);
                    NCRecipes.infuser.addRecipe("ingot" + rawOre, AbstractRecipeHandler.fluidStack("oxygen", 1000), "ingot" + rawOre + "Oxide", 1.0, 1.0);
                    NCRecipes.infuser.addRecipe("ingot" + rawOre, AbstractRecipeHandler.fluidStack("nitrogen", 1000), "ingot" + rawOre + "Nitride", 1.0, 1.0);
                    NCRecipes.separator.addRecipe("ingot" + rawOre + "ZA", "ingot" + rawOre, "dustZirconium", 1.0, 1.0);
                    NCRecipes.separator.addRecipe("ingot" + rawOre + "Carbide", "ingot" + rawOre, "dustGraphite", 1.0, 1.0);
                    NCRecipes.assembler.addRecipe(AbstractRecipeHandler.oreStack("ingot" + rawOre + "Carbide", 9), "dustGraphite", "ingotPyrolyticCarbon", "ingotSiliconCarbide", AbstractRecipeHandler.oreStack("ingot" + rawOre + "TRISO", 9), 1.0, 1.0);
                    NCRecipes.pebble_fission.addRecipe("ingot" + rawOre + "TRISO", "ingotDepleted" + rawOre + "TRISO", (int)(0.9 * (double)stats.time), (int)(1.1111111111111112 * (double)stats.heat), stats.efficiency, (int)(0.9 * (double)stats.crit), stats.decay, stats.prime, stats.radiation);
                    NCRecipes.solid_fission.addRecipe("ingot" + rawOre + "Oxide", "ingotDepleted" + rawOre + "Oxide", (int)(SFR_TIME_MULT[0] * (double)stats.time), (int)(SFR_HEAT_MULT[0] * (double)stats.heat), stats.efficiency, (int)(SFR_CRIT_MULT[0] * (double)stats.crit), stats.decay, stats.prime, stats.radiation);
                    NCRecipes.solid_fission.addRecipe("ingot" + rawOre + "Nitride", "ingotDepleted" + rawOre + "Nitride", (int)(SFR_TIME_MULT[1] * (double)stats.time), (int)(SFR_HEAT_MULT[1] * (double)stats.heat), stats.efficiency, (int)(SFR_CRIT_MULT[1] * (double)stats.crit), stats.decay, stats.prime, stats.radiation);
                    NCRecipes.solid_fission.addRecipe("ingot" + rawOre + "ZA", "ingotDepleted" + rawOre + "ZA", (int)(SFR_TIME_MULT[2] * (double)stats.time), (int)(SFR_HEAT_MULT[2] * (double)stats.heat), stats.efficiency, (int)(SFR_CRIT_MULT[2] * (double)stats.crit), stats.decay, stats.prime, stats.radiation);
                }
                if (rawFluid != null) {
                    EmptyFluidIngredient empty = AbstractRecipeHandler.emptyFluidStack();
                    NCRecipes.chemical_reactor.addRecipe(AbstractRecipeHandler.fluidStack(rawFluid, 72), AbstractRecipeHandler.fluidStack("fluorine", 500), AbstractRecipeHandler.fluidStack(rawFluid + "_fluoride", 72), empty, 0.5, 0.5);
                    NCRecipes.electrolyzer.addRecipe(AbstractRecipeHandler.fluidStack(rawFluid + "_fluoride", 72), AbstractRecipeHandler.fluidStack(rawFluid, 72), AbstractRecipeHandler.fluidStack("fluorine", 500), empty, empty, 0.5, 1.0);
                    NCRecipes.electrolyzer.addRecipe(AbstractRecipeHandler.fluidStack("depleted_" + rawFluid + "_fluoride", 72), AbstractRecipeHandler.fluidStack("depleted_" + rawFluid, 72), AbstractRecipeHandler.fluidStack("fluorine", 500), empty, empty, 0.5, 1.0);
                    NCRecipes.salt_mixer.addRecipe(AbstractRecipeHandler.fluidStack(rawFluid + "_fluoride", 72), AbstractRecipeHandler.fluidStack("flibe", 72), AbstractRecipeHandler.fluidStack(rawFluid + "_fluoride_flibe", 72), 0.5, 1.0);
                    NCRecipes.centrifuge.addRecipe(AbstractRecipeHandler.fluidStack(rawFluid + "_fluoride_flibe", 72), AbstractRecipeHandler.fluidStack(rawFluid + "_fluoride", 72), AbstractRecipeHandler.fluidStack("flibe", 72), empty, empty, empty, empty, 0.5, 1.0);
                    NCRecipes.centrifuge.addRecipe(AbstractRecipeHandler.fluidStack("depleted_" + rawFluid + "_fluoride_flibe", 72), AbstractRecipeHandler.fluidStack("depleted_" + rawFluid + "_fluoride", 72), AbstractRecipeHandler.fluidStack("flibe", 72), empty, empty, empty, empty, 0.5, 1.0);
                    NCRecipes.salt_fission.addRecipe(AbstractRecipeHandler.fluidStack(rawFluid + "_fluoride_flibe", 1), AbstractRecipeHandler.fluidStack("depleted_" + rawFluid + "_fluoride_flibe", 1), 1.25 * (double)stats.time / 144.0, (int)(0.8 * (double)stats.heat), stats.efficiency, 1.0 * (double)stats.crit, stats.decay, stats.prime, stats.radiation);
                }
                if (rawOre == null || rawFluid == null) continue;
                NCRecipes.ingot_former.addRecipe(AbstractRecipeHandler.fluidStack(rawFluid, 144), "ingot" + rawOre, 1.0, 1.0);
                NCRecipes.melter.addRecipe("ingot" + rawOre, AbstractRecipeHandler.fluidStack(rawFluid, 144), 1.0, 1.0);
            }
        }
    }

    public static class FissionIsotopeRegistrationInfo
    extends MetaItemRegistrationInfo {
        public final List<String> rawNames = new ArrayList<String>();
        public final List<String> rawOres = new ArrayList<String>();
        public final List<String> rawFluids = new ArrayList<String>();
        public final IntList rawFluidColors = new IntArrayList();
        public final List<String> ores = new ArrayList<String>();

        public FissionIsotopeRegistrationInfo(String name) {
            super(name, NCTabs.MATERIAL);
        }

        @Override
        public void preInit() {
            int i;
            super.preInit();
            if (this.item != null) {
                for (i = 0; i < this.types.size(); ++i) {
                    OreDictHandler.registerOre(this.item, i, this.ores.get(i));
                }
            }
            for (i = 0; i < this.rawFluids.size(); ++i) {
                String rawFluid = this.rawFluids.get(i);
                if (rawFluid == null) continue;
                NCFissionFluids.addIsotopeFluids(rawFluid, this.rawFluidColors.getInt(i));
            }
        }

        @Override
        public void recipeInit() {
            if (this.item == null) {
                return;
            }
            for (int i = 0; i < this.rawOres.size(); ++i) {
                String rawOre = this.rawOres.get(i);
                String rawFluid = this.rawFluids.get(i);
                if (rawOre != null) {
                    for (ItemStack output : OreDictionary.getOres((String)("ingot" + rawOre), (boolean)false)) {
                        for (ItemStack input : OreDictionary.getOres((String)("ingot" + rawOre + "Oxide"), (boolean)false)) {
                            GameRegistry.addSmelting((ItemStack)input, (ItemStack)output, (float)0.0f);
                        }
                        for (ItemStack input : OreDictionary.getOres((String)("ingot" + rawOre + "Nitride"), (boolean)false)) {
                            GameRegistry.addSmelting((ItemStack)input, (ItemStack)output, (float)0.0f);
                        }
                    }
                    NCRecipes.alloy_furnace.addAlloyIngotIngotRecipes(rawOre, 1, "Zirconium", 1, rawOre + "ZA", 1, 1.0, 1.0);
                    NCRecipes.alloy_furnace.addAlloyIngotIngotRecipes(rawOre, 1, "Graphite", 1, rawOre + "Carbide", 1, 1.0, 1.0);
                    NCRecipes.infuser.addRecipe("ingot" + rawOre, AbstractRecipeHandler.fluidStack("oxygen", 1000), "ingot" + rawOre + "Oxide", 1.0, 1.0);
                    NCRecipes.infuser.addRecipe("ingot" + rawOre, AbstractRecipeHandler.fluidStack("nitrogen", 1000), "ingot" + rawOre + "Nitride", 1.0, 1.0);
                    NCRecipes.separator.addRecipe("ingot" + rawOre + "ZA", "ingot" + rawOre, "dustZirconium", 1.0, 1.0);
                    NCRecipes.separator.addRecipe("ingot" + rawOre + "Carbide", "ingot" + rawOre, "dustGraphite", 1.0, 1.0);
                }
                if (rawOre == null || rawFluid == null) continue;
                NCRecipes.ingot_former.addRecipe(AbstractRecipeHandler.fluidStack(rawFluid, 144), "ingot" + rawOre, 1.0, 1.0);
                NCRecipes.melter.addRecipe("ingot" + rawOre, AbstractRecipeHandler.fluidStack(rawFluid, 144), 1.0, 1.0);
            }
        }
    }

    public static class MetaItemRegistrationInfo
    extends RegistrationInfo {
        protected final String name;
        protected Item item = null;
        protected CreativeTabs tab;
        public final List<String> types = new ArrayList<String>();
        public final List<String> models = new ArrayList<String>();
        public final List<String> textures = new ArrayList<String>();

        public MetaItemRegistrationInfo(String name, CreativeTabs tab) {
            this.name = name;
            this.tab = tab;
        }

        public void createModelJson() {
            StringBuilder builder = new StringBuilder();
            String s = IOHelper.NEW_LINE;
            builder.append("{" + s + "\t\"forge_marker\": 1," + s + "\t\"defaults\": {" + s + "\t\t\"model\": \"builtin/generated\"," + s + "\t\t\"transform\": \"forge:default-item\"" + s + "\t}," + s + "\t\"variants\": {" + s + "\t\t\"type\": {" + s);
            for (int i = 0; i < this.types.size(); ++i) {
                builder.append("\t\t\t\"" + this.types.get(i) + "\": {" + s);
                String model = this.models.get(i);
                if (model != null) {
                    builder.append("\t\t\t\t\"model\": \"" + model + "\"," + s);
                }
                builder.append("\t\t\t\t\"textures\": {" + s + "\t\t\t\t\t\"layer0\": \"nuclearcraft:items/" + this.name + "/" + this.textures.get(i) + "\"" + s + "\t\t\t\t}" + s + "\t\t\t" + (i < this.types.size() - 1 ? "}," : "}") + s);
            }
            builder.append("\t\t}" + s + "\t}" + s + "}" + s);
            try {
                FileUtils.writeStringToFile((File)new File("resources/nuclearcraft/blockstates/items/" + this.name + ".json"), (String)builder.toString());
            }
            catch (IOException e) {
                NCUtil.getLogger().catching((Throwable)e);
            }
        }

        @Override
        public void preInit() {
            if (this.types.isEmpty()) {
                return;
            }
            this.createModelJson();
            this.item = NCItems.withName(new NCItemMetaArray(this.types, new String[0][]), this.name);
            this.registerItem();
            if (CraftTweakerPlatformUtils.isClient()) {
                this.registerRender();
            }
        }

        public void registerItem() {
            NCItems.registerItem(this.item, this.tab);
        }

        public void registerRender() {
            for (int i = 0; i < this.types.size(); ++i) {
                NCItems.registerRender(this.item, i, this.types.get(i));
            }
        }

        @Override
        public void init() {
        }

        @Override
        public void postInit() {
        }
    }

    public static class ItemRegistrationInfo
    extends RegistrationInfo {
        protected final Item item;
        protected final CreativeTabs tab;

        public ItemRegistrationInfo(Item item, CreativeTabs tab) {
            this.item = item;
            this.tab = tab;
        }

        @Override
        public void preInit() {
            this.registerItem();
            if (CraftTweakerPlatformUtils.isClient()) {
                this.registerRender();
            }
        }

        public void registerItem() {
            NCItems.registerItem(this.item, this.tab);
        }

        public void registerRender() {
            NCItems.registerRender(this.item);
        }

        @Override
        public void init() {
        }

        @Override
        public void postInit() {
        }
    }

    public static class BatteryRegistrationInfo
    extends TileBlockRegistrationInfo {
        protected final long capacity;
        protected final int energyTier;

        BatteryRegistrationInfo(Block block, long capacity, int energyTier) {
            super(block);
            this.capacity = capacity;
            this.energyTier = energyTier;
        }

        @Override
        public void registerBlock() {
            NCBlocks.registerBlock(this.block, new ItemBlockBattery(this.block, this.capacity, NCMath.toInt(this.capacity), this.energyTier, InfoHelper.formattedInfo(NCBlocks.infoLine("energy_storage"), new Object[0])));
        }
    }

    public static class RTGRegistrationInfo
    extends TileBlockRegistrationInfo {
        protected final long power;

        RTGRegistrationInfo(Block block, long power) {
            super(block);
            this.power = power;
        }

        @Override
        public void registerBlock() {
            NCBlocks.registerBlock(this.block, InfoHelper.formattedInfo(NCBlocks.infoLine("rtg"), UnitHelper.prefix(this.power, 5, "RF/t")));
        }
    }

    public static class TurbineStatorRegistrationInfo
    extends TileBlockRegistrationInfo {
        protected final double expansionCoefficient;

        TurbineStatorRegistrationInfo(Block block, double expansionCoefficient) {
            super(block);
            this.expansionCoefficient = expansionCoefficient;
        }

        @Override
        public void registerBlock() {
            NCBlocks.registerBlock(this.block, TextFormatting.GRAY, new String[]{Lang.localise(NCBlocks.fixedLine("turbine_rotor_stator_expansion"), NCMath.pcDecimalPlaces(this.expansionCoefficient, 1))}, TextFormatting.AQUA, InfoHelper.formattedInfo(NCBlocks.infoLine("turbine_rotor_stator"), new Object[0]));
        }
    }

    public static class TurbineBladeRegistrationInfo
    extends TileBlockRegistrationInfo {
        protected final double efficiency;
        protected final double expansionCoefficient;

        TurbineBladeRegistrationInfo(Block block, double efficiency, double expansionCoefficient) {
            super(block);
            this.efficiency = efficiency;
            this.expansionCoefficient = expansionCoefficient;
        }

        @Override
        public void registerBlock() {
            NCBlocks.registerBlock(this.block, new TextFormatting[]{TextFormatting.LIGHT_PURPLE, TextFormatting.GRAY}, new String[]{Lang.localise(NCBlocks.fixedLine("turbine_rotor_blade_efficiency"), NCMath.pcDecimalPlaces(this.efficiency, 1)), Lang.localise(NCBlocks.fixedLine("turbine_rotor_blade_expansion"), NCMath.pcDecimalPlaces(this.expansionCoefficient, 1))}, TextFormatting.AQUA, InfoHelper.formattedInfo(NCBlocks.infoLine("turbine_rotor_blade"), UnitHelper.prefix((long)NCConfig.turbine_mb_per_blade, 5, "B/t", -1)));
        }
    }

    public static class TurbineCoilRegistrationInfo
    extends TileBlockRegistrationInfo {
        protected final String coilID;
        protected final String rule;
        protected final double conductivity;

        TurbineCoilRegistrationInfo(Block block, String coilID, double conductivity, String rule) {
            super(block);
            this.coilID = coilID;
            this.conductivity = conductivity;
            this.rule = rule;
        }

        @Override
        public void registerBlock() {
            NCBlocks.registerBlock(this.block, TextFormatting.LIGHT_PURPLE, NCInfo.coilConductivityInfo(this.conductivity), TextFormatting.AQUA, InfoHelper.NULL_ARRAY);
        }

        @Override
        public void init() {
            super.init();
            TurbinePlacement.addRule(this.coilID + "_coil", this.rule, this.block);
        }
    }

    public static class FissionShieldRegistrationInfo
    extends TileBlockRegistrationInfo {
        protected final double heatPerFlux;
        protected final double efficiency;

        FissionShieldRegistrationInfo(Block block, double heatPerFlux, double efficiency) {
            super(block);
            this.heatPerFlux = heatPerFlux;
            this.efficiency = efficiency;
        }

        @Override
        public void registerBlock() {
            NCBlocks.registerBlock(this.block, new TextFormatting[]{TextFormatting.YELLOW, TextFormatting.LIGHT_PURPLE}, NCInfo.neutronShieldStatInfo(this.heatPerFlux, this.efficiency), TextFormatting.AQUA, NCInfo.neutronShieldDescriptionInfo());
        }
    }

    public static class FissionSourceRegistrationInfo
    extends TileBlockRegistrationInfo {
        protected final double efficiency;

        FissionSourceRegistrationInfo(Block block, double efficiency) {
            super(block);
            this.efficiency = efficiency;
        }

        @Override
        public void registerBlock() {
            NCBlocks.registerBlock(this.block, TextFormatting.LIGHT_PURPLE, NCInfo.neutronSourceEfficiencyInfo(this.efficiency), TextFormatting.AQUA, NCInfo.neutronSourceDescriptionInfo());
        }
    }

    public static class FissionHeaterPortRegistrationInfo
    extends TileBlockRegistrationInfo {
        FissionHeaterPortRegistrationInfo(Block block, String heaterID) {
            super(block);
        }

        @Override
        public void registerBlock() {
            NCBlocks.registerBlock(this.block, new String[0]);
        }
    }

    public static class FissionHeaterRegistrationInfo
    extends TileBlockRegistrationInfo {
        protected final String heaterID;
        protected final String fluidInput;
        protected final String fluidOutput;
        protected final String rule;
        protected final int inputAmount;
        protected final int outputAmount;
        protected final int cooling;

        FissionHeaterRegistrationInfo(Block block, String heaterID, String fluidInput, int inputAmount, String fluidOutput, int outputAmount, int cooling, String rule) {
            super(block);
            this.heaterID = heaterID;
            this.fluidInput = fluidInput;
            this.inputAmount = inputAmount;
            this.fluidOutput = fluidOutput;
            this.outputAmount = outputAmount;
            this.cooling = cooling;
            this.rule = rule;
        }

        @Override
        public void registerBlock() {
            NCBlocks.registerBlock(this.block, TextFormatting.BLUE, NCInfo.coolingRateInfo(this.cooling, "salt_fission_heater"), TextFormatting.AQUA, InfoHelper.NULL_ARRAY);
        }

        @Override
        public void recipeInit() {
            NCRecipes.coolant_heater.addRecipe(this.block, AbstractRecipeHandler.fluidStack(this.fluidInput, this.inputAmount), AbstractRecipeHandler.fluidStack(this.fluidOutput, this.outputAmount), this.cooling, this.heaterID + "_heater");
        }

        @Override
        public void init() {
            super.init();
            FissionPlacement.addRule(this.heaterID + "_heater", this.rule, this.block);
        }
    }

    public static class FissionSinkRegistrationInfo
    extends TileBlockRegistrationInfo {
        protected final String sinkID;
        protected final String rule;
        protected final int cooling;

        FissionSinkRegistrationInfo(Block block, String sinkID, int cooling, String rule) {
            super(block);
            this.sinkID = sinkID;
            this.cooling = cooling;
            this.rule = rule;
        }

        @Override
        public void registerBlock() {
            NCBlocks.registerBlock(this.block, TextFormatting.BLUE, NCInfo.coolingRateInfo(this.cooling, "solid_fission_sink"), TextFormatting.AQUA, InfoHelper.NULL_ARRAY);
        }

        @Override
        public void init() {
            super.init();
            FissionPlacement.addRule(this.sinkID + "_sink", this.rule, this.block);
        }
    }

    public static class TileBlockRegistrationInfo
    extends BlockRegistrationInfo {
        public TileBlockRegistrationInfo(Block block) {
            super(block);
        }
    }

    public static class BlockRegistrationInfo
    extends RegistrationInfo {
        protected final Block block;

        public BlockRegistrationInfo(Block block) {
            this.block = block;
        }

        @Override
        public void preInit() {
            this.registerBlock();
            if (CraftTweakerPlatformUtils.isClient()) {
                this.registerRender();
            }
        }

        public void registerBlock() {
            NCBlocks.registerBlock(this.block, new String[0]);
        }

        public void registerRender() {
            NCBlocks.registerRender(this.block);
        }

        @Override
        public void init() {
        }

        @Override
        public void postInit() {
        }
    }

    public static abstract class RegistrationInfo {
        public abstract void preInit();

        public void recipeInit() {
        }

        public abstract void init();

        public abstract void postInit();
    }

    private static class FissionFuelStats {
        final int time;
        final int heat;
        final double efficiency;
        final int crit;
        final double decay;
        final boolean prime;
        final double radiation;

        public FissionFuelStats(int time, int heat, double efficiency, int crit, double decay, boolean prime, double radiation) {
            this.time = time;
            this.heat = heat;
            this.efficiency = efficiency;
            this.crit = crit;
            this.decay = decay;
            this.prime = prime;
            this.radiation = radiation;
        }
    }
}

