/*
 * Decompiled with CFR 0.152.
 */
package nc.init;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import nc.ModCheck;
import nc.NuclearCraft;
import nc.block.fluid.BlockFluidCoolant;
import nc.block.fluid.BlockFluidHotCoolant;
import nc.block.fluid.BlockFluidMolten;
import nc.block.fluid.NCBlockFluid;
import nc.block.item.NCItemBlock;
import nc.config.NCConfig;
import nc.fluid.FluidCoolant;
import nc.fluid.FluidHotCoolant;
import nc.fluid.FluidMolten;
import nc.util.ColorHelper;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;

public class NCCoolantFluids {
    public static List<Pair<Fluid, NCBlockFluid>> fluidPairList = new ArrayList<Pair<Fluid, NCBlockFluid>>();
    public static List<Fluid> fluidList = new ArrayList<Fluid>();
    public static final List<String> COOLANTS = Lists.newArrayList((Object[])new String[]{null});

    public static void init() {
        NCCoolantFluids.addMoltenPair("iron", 9245973);
        NCCoolantFluids.addNAKPairs("iron", 9245973);
        if (NCCoolantFluids.registerCoFHAlt()) {
            NCCoolantFluids.addMoltenPair("redstone", 11213833);
        }
        NCCoolantFluids.addNAKPairs("redstone", 11213833);
        NCCoolantFluids.addMoltenPair("quartz", 15526370);
        NCCoolantFluids.addNAKPairs("quartz", 15526370);
        NCCoolantFluids.addMoltenPair("obsidian", 1841192);
        NCCoolantFluids.addNAKPairs("obsidian", 1841192);
        NCCoolantFluids.addMoltenPair("nether_brick", 2560791);
        NCCoolantFluids.addNAKPairs("nether_brick", 2560791);
        if (NCCoolantFluids.registerCoFHAlt()) {
            NCCoolantFluids.addMoltenPair("glowstone", 10715191);
        }
        NCCoolantFluids.addNAKPairs("glowstone", 10715191);
        NCCoolantFluids.addMoltenPair("lapis", 2573194);
        NCCoolantFluids.addNAKPairs("lapis", 2573194);
        NCCoolantFluids.addMoltenPair("gold", 15129148);
        NCCoolantFluids.addNAKPairs("gold", 15129148);
        NCCoolantFluids.addMoltenPair("prismarine", 7382677);
        NCCoolantFluids.addNAKPairs("prismarine", 7382677);
        NCCoolantFluids.addMoltenPair("slime", 7981157);
        NCCoolantFluids.addNAKPairs("slime", 7981157);
        NCCoolantFluids.addMoltenPair("end_stone", 15198643);
        NCCoolantFluids.addNAKPairs("end_stone", 15198643);
        NCCoolantFluids.addMoltenPair("purpur", 0xA979A9);
        NCCoolantFluids.addNAKPairs("purpur", 0xA979A9);
        NCCoolantFluids.addMoltenPair("diamond", 7331802);
        NCCoolantFluids.addNAKPairs("diamond", 7331802);
        NCCoolantFluids.addMoltenPair("emerald", 5364085);
        NCCoolantFluids.addNAKPairs("emerald", 5364085);
        NCCoolantFluids.addMoltenPair("copper", 11363652);
        NCCoolantFluids.addNAKPairs("copper", 11363652);
        NCCoolantFluids.addMoltenPair("tin", 14278128);
        NCCoolantFluids.addNAKPairs("tin", 14278128);
        NCCoolantFluids.addMoltenPair("lead", 4148300);
        NCCoolantFluids.addNAKPairs("lead", 4148300);
        NCCoolantFluids.addMoltenPair("boron", 0x7D7D7D);
        NCCoolantFluids.addNAKPairs("boron", 0x7D7D7D);
        NCCoolantFluids.addMoltenPair("lithium", 0xEFEFEF);
        NCCoolantFluids.addNAKPairs("lithium", 0xEFEFEF);
        NCCoolantFluids.addMoltenPair("magnesium", 15652321);
        NCCoolantFluids.addNAKPairs("magnesium", 15652321);
        NCCoolantFluids.addMoltenPair("manganese", 10068426);
        NCCoolantFluids.addNAKPairs("manganese", 10068426);
        NCCoolantFluids.addMoltenPair("aluminum", 11922645);
        NCCoolantFluids.addNAKPairs("aluminum", 11922645);
        NCCoolantFluids.addMoltenPair("silver", 14867190);
        NCCoolantFluids.addNAKPairs("silver", 14867190);
        NCCoolantFluids.addMoltenPair("fluorite", 9090194);
        NCCoolantFluids.addNAKPairs("fluorite", 9090194);
        NCCoolantFluids.addMoltenPair("villiaumite", 11562070);
        NCCoolantFluids.addNAKPairs("villiaumite", 11562070);
        NCCoolantFluids.addMoltenPair("carobbiite", 9806417);
        NCCoolantFluids.addNAKPairs("carobbiite", 9806417);
        NCCoolantFluids.addNAKPairs("arsenic", 8488053);
        NCCoolantFluids.addNAKPairs("liquid_nitrogen", 3260986);
        NCCoolantFluids.addNAKPairs("liquid_helium", 15942461);
        NCCoolantFluids.addNAKPairs("enderium", 744284);
        NCCoolantFluids.addNAKPairs("cryotheum", 39361);
    }

    private static void addMoltenPair(String name, int color) {
        FluidMolten fluid = new FluidMolten(name, color);
        fluidPairList.add((Pair<Fluid, NCBlockFluid>)Pair.of((Object)((Object)fluid), (Object)((Object)(NCConfig.register_fluid_blocks ? new BlockFluidMolten(fluid) : null))));
    }

    private static void addNAKPairs(String name, int color) {
        COOLANTS.add(name);
        FluidCoolant coolant = new FluidCoolant(name + "_nak", ColorHelper.getNAKColor(color));
        fluidPairList.add((Pair<Fluid, NCBlockFluid>)Pair.of((Object)((Object)coolant), (Object)((Object)(NCConfig.register_fluid_blocks ? new BlockFluidCoolant(coolant) : null))));
        FluidHotCoolant hotCoolant = new FluidHotCoolant(name + "_nak_hot", FluidHotCoolant.getNAKColor(color));
        fluidPairList.add((Pair<Fluid, NCBlockFluid>)Pair.of((Object)((Object)hotCoolant), (Object)((Object)(NCConfig.register_fluid_blocks ? new BlockFluidHotCoolant(hotCoolant) : null))));
    }

    public static void register() {
        for (Pair<Fluid, NCBlockFluid> fluidPair : fluidPairList) {
            Fluid fluid = (Fluid)fluidPair.getLeft();
            if (!FluidRegistry.registerFluid((Fluid)fluid)) {
                fluid = FluidRegistry.getFluid((String)fluid.getName());
            }
            FluidRegistry.addBucketForFluid((Fluid)fluid);
            fluidList.add(fluid);
            NCBlockFluid fluidBlock = (NCBlockFluid)((Object)fluidPair.getRight());
            if (fluidBlock == null) continue;
            NCCoolantFluids.registerBlock(fluidBlock);
        }
    }

    private static void registerBlock(NCBlockFluid block) {
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)NCCoolantFluids.withName(block));
        ForgeRegistries.ITEMS.register(new NCItemBlock((Block)block, TextFormatting.AQUA, new String[0]).setRegistryName(block.getRegistryName()));
        NuclearCraft.proxy.registerFluidBlockRendering((Block)block, "fluid_molten_colored");
    }

    private static <T extends NCBlockFluid> Block withName(T block) {
        return (Block)block.func_149663_c("nuclearcraft." + block.name).setRegistryName(new ResourceLocation("nuclearcraft", block.name));
    }

    private static boolean registerCoFHAlt() {
        return NCConfig.register_cofh_fluids || !ModCheck.thermalFoundationLoaded();
    }
}

