/*
 * Decompiled with CFR 0.152.
 */
package nc.handler;

import nc.capability.radiation.source.IRadiationSource;
import nc.config.NCConfig;
import nc.entity.EntityFeralGhoul;
import nc.radiation.RadiationHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EntityHandler {
    @SubscribeEvent
    public void onEntityLivingSpawn(LivingSpawnEvent.CheckSpawn event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity instanceof EntityFeralGhoul && !event.isSpawner()) {
            World world = entity.field_70170_p;
            BlockPos pos = new BlockPos(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            boolean canSeeSky = world.func_175678_i(pos);
            if (!canSeeSky) {
                event.setResult(Event.Result.DENY);
                return;
            }
            boolean tooManyGhouls = false;
            ClassInheritanceMultiMap[] entityListArray = world.func_175726_f(pos).func_177429_s();
            for (int i = 0; i < entityListArray.length; ++i) {
                Iterable ghouls = entityListArray[i].func_180215_b(EntityFeralGhoul.class);
                if (!ghouls.iterator().hasNext()) continue;
                tooManyGhouls = true;
                break;
            }
            if (tooManyGhouls) {
                event.setResult(Event.Result.DENY);
                return;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onItemExpired(ItemExpireEvent event) {
        IRadiationSource chunkSource;
        Chunk chunk;
        if (event.isCanceled()) {
            return;
        }
        EntityItem entity = event.getEntityItem();
        if (entity == null || entity.field_70170_p == null) {
            return;
        }
        ItemStack stack = entity.func_92059_d();
        if (stack.func_190926_b()) {
            return;
        }
        if (NCConfig.radiation_enabled_public && NCConfig.radiation_hardcore_stacks && (chunk = entity.field_70170_p.func_175726_f(new BlockPos((Entity)entity))).func_177410_o() && (chunkSource = RadiationHelper.getRadiationSource((ICapabilityProvider)chunk)) != null) {
            RadiationHelper.addToSourceRadiation(chunkSource, RadiationHelper.getRadiationFromStack(stack, 8.0));
        }
    }
}

