/*
 * Decompiled with CFR 0.152.
 */
package nc.handler;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Random;
import nc.capability.radiation.resistance.IRadiationResistance;
import nc.config.NCConfig;
import nc.entity.EntityFeralGhoul;
import nc.enumm.MetaEnums;
import nc.init.NCItems;
import nc.radiation.RadiationHelper;
import nc.util.FourPos;
import nc.util.OreDictHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class DropHandler {
    private final Random rand = new Random();
    private final Object2ObjectMap<FourPos, TileEntity> tileMap = new Object2ObjectOpenHashMap();

    @SubscribeEvent
    public void addEntityDrops(LivingDropsEvent event) {
        Entity entity = event.getEntity();
        if (entity.func_130014_f_().func_82736_K().func_82766_b("doMobLoot")) {
            if (entity instanceof EntityFeralGhoul) {
                if (this.rand.nextInt(50) < 1) {
                    event.getDrops().add(DropHandler.entityItem(entity, new ItemStack(NCItems.ingot, 1, 3), "ingotThorium"));
                }
                if (this.rand.nextInt(50) < 1) {
                    event.getDrops().add(DropHandler.entityItem(entity, new ItemStack(NCItems.ingot, 1, 4), "ingotUranium"));
                }
            }
            if (NCConfig.rare_drops && entity instanceof EntityMob && this.rand.nextInt(100) < 1) {
                event.getDrops().add(DropHandler.entityItem(entity, new ItemStack(NCItems.dominos, 1), null));
            }
        }
    }

    private static EntityItem entityItem(Entity entity, ItemStack stack, String oreName) {
        return new EntityItem(entity.func_130014_f_(), entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, OreDictHelper.getPrioritisedCraftingStack(stack, oreName));
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        BlockPos pos;
        TileEntity tile;
        World world = event.getWorld();
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops") && (tile = world.func_175625_s(pos = event.getPos())) != null) {
            this.tileMap.put((Object)new FourPos(pos, world.field_73011_w.getDimension()), (Object)tile);
        }
    }

    @SubscribeEvent
    public void addBlockDrops(BlockEvent.HarvestDropsEvent event) {
        World world = event.getWorld();
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops")) {
            FourPos pos;
            TileEntity tile;
            List drops = event.getDrops();
            Block block = event.getState().func_177230_c();
            if (!event.isSilkTouching()) {
                if (NCConfig.ore_drops[0]) {
                    this.blockDrop(drops, block, NCItems.gem, 1, 1, 0, Blocks.field_150450_ax, 25);
                }
                if (NCConfig.ore_drops[0]) {
                    this.blockDrop(drops, block, NCItems.gem, 1, 1, 0, Blocks.field_150439_ay, 25);
                }
                if (NCConfig.ore_drops[1]) {
                    this.blockDrop(drops, block, NCItems.dust, 1, 1, 9, Blocks.field_150365_q, 18);
                }
                if (NCConfig.ore_drops[2]) {
                    this.blockDrop(drops, block, NCItems.dust, 1, 1, 10, Blocks.field_150449_bY, 18);
                }
                if (NCConfig.ore_drops[3]) {
                    this.blockDrop(drops, block, NCItems.gem, 2, 2, 2, Blocks.field_150369_x, 95);
                }
                if (NCConfig.ore_drops[4]) {
                    this.blockDrop(drops, block, NCItems.gem_dust, 1, 1, 6, Blocks.field_150365_q, 18);
                }
                if (NCConfig.ore_drops[5]) {
                    this.blockDrop(drops, block, NCItems.gem, 0, 1, 3, Blocks.field_150482_ag, 100);
                }
                if (NCConfig.ore_drops[6]) {
                    this.blockDrop(drops, block, NCItems.gem, 1, 3, 4, Blocks.field_150482_ag, 100);
                }
            }
            if ((tile = (TileEntity)this.tileMap.get((Object)(pos = new FourPos(event.getPos(), world.field_73011_w.getDimension())))) != null) {
                IRadiationResistance resistance = RadiationHelper.getRadiationResistance((ICapabilityProvider)tile);
                if (resistance != null) {
                    for (int i = MetaEnums.RadShieldingType.values().length; i > 0; --i) {
                        if (!(resistance.getShieldingRadResistance() >= NCConfig.radiation_shielding_level[i - 1])) continue;
                        drops.add(new ItemStack(NCItems.rad_shielding, 1, i - 1));
                        break;
                    }
                }
                this.tileMap.remove((Object)pos);
            }
        }
    }

    private void blockDrop(List<ItemStack> drops, Block block, Item drop, int min, int max, int meta, Block target, int chance) {
        if (block == target && this.rand.nextInt(100) < chance) {
            drops.add(new ItemStack(drop, min + this.rand.nextInt(max - min + 1), meta));
        }
    }
}

