/*
 * Decompiled with CFR 0.152.
 */
package nc.gui.processor;

import java.io.IOException;
import nc.container.ContainerTile;
import nc.container.processor.ContainerMachineConfig;
import nc.container.processor.ContainerSupercooler;
import nc.gui.element.GuiFluidRenderer;
import nc.gui.element.NCButton;
import nc.gui.element.NCToggleButton;
import nc.gui.processor.GuiFluidProcessor;
import nc.gui.processor.GuiFluidSorptions;
import nc.gui.processor.GuiItemSorptions;
import nc.network.PacketHandler;
import nc.network.gui.EmptyTankPacket;
import nc.network.gui.OpenSideConfigGuiPacket;
import nc.network.gui.OpenTileGuiPacket;
import nc.network.gui.ToggleRedstoneControlPacket;
import nc.tile.processor.TileFluidProcessor;
import nc.util.Lang;
import nc.util.NCUtil;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiSupercooler
extends GuiFluidProcessor {
    public GuiSupercooler(EntityPlayer player, TileFluidProcessor tile) {
        this(player, tile, new ContainerSupercooler(player, tile));
    }

    protected GuiSupercooler(EntityPlayer player, TileFluidProcessor tile, ContainerTile<TileFluidProcessor> container) {
        super("supercooler", player, tile, container);
        this.field_146999_f = 176;
        this.field_147000_g = 166;
    }

    @Override
    public void renderTooltips(int mouseX, int mouseY) {
        this.drawEnergyTooltip(this.tile, mouseX, mouseY, 8, 6, 16, 74);
        this.renderButtonTooltips(mouseX, mouseY);
    }

    public void renderButtonTooltips(int mouseX, int mouseY) {
        this.drawFluidTooltip(this.tile.getTanks().get(0), mouseX, mouseY, 56, 35, 16, 16);
        this.drawFluidTooltip(this.tile.getTanks().get(1), mouseX, mouseY, 112, 31, 24, 24);
        this.drawTooltip(Lang.localise("gui.nc.container.machine_side_config"), mouseX, mouseY, 27, 63, 18, 18);
        this.drawTooltip(Lang.localise("gui.nc.container.redstone_control"), mouseX, mouseY, 47, 63, 18, 18);
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        if (this.tile.defaultProcessPower != 0.0) {
            int e = (int)Math.round(74.0 * (double)this.tile.getEnergyStorage().getEnergyStored() / (double)this.tile.getEnergyStorage().getMaxEnergyStored());
            this.func_73729_b(this.field_147003_i + 8, this.field_147009_r + 6 + 74 - e, 176, 164 - e, 16, e);
        } else {
            this.func_73733_a(this.field_147003_i + 8, this.field_147009_r + 6, this.field_147003_i + 8 + 16, this.field_147009_r + 6 + 74, -3750202, -7631989);
        }
        this.func_73729_b(this.field_147003_i + 74, this.field_147009_r + 35, 176, 3, this.getCookProgressScaled(37), 16);
        this.drawUpgradeRenderers();
        this.drawBackgroundExtras();
    }

    protected void drawBackgroundExtras() {
        GuiFluidRenderer.renderGuiTank(this.tile.getTanks().get(0), this.field_147003_i + 56, this.field_147009_r + 35, this.field_73735_i, 16.0, 16.0);
        GuiFluidRenderer.renderGuiTank(this.tile.getTanks().get(1), this.field_147003_i + 112, this.field_147009_r + 31, this.field_73735_i, 24.0, 24.0);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.initButtons();
    }

    public void initButtons() {
        this.field_146292_n.add(new NCButton.EmptyTank(0, this.field_147003_i + 56, this.field_147009_r + 35, 16, 16));
        this.field_146292_n.add(new NCButton.EmptyTank(1, this.field_147003_i + 112, this.field_147009_r + 31, 24, 24));
        this.field_146292_n.add(new NCButton.MachineConfig(2, this.field_147003_i + 27, this.field_147009_r + 63));
        this.field_146292_n.add(new NCToggleButton.RedstoneControl(3, this.field_147003_i + 47, this.field_147009_r + 63, this.tile));
    }

    @Override
    protected void func_146284_a(GuiButton guiButton) {
        if (this.tile.func_145831_w().field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                if (guiButton.field_146127_k != i || !NCUtil.isModifierKeyDown()) continue;
                PacketHandler.instance.sendToServer((IMessage)new EmptyTankPacket(this.tile, i));
                return;
            }
            if (guiButton.field_146127_k == 2) {
                PacketHandler.instance.sendToServer((IMessage)new OpenSideConfigGuiPacket(this.tile));
            } else if (guiButton.field_146127_k == 3) {
                this.tile.setRedstoneControl(!this.tile.getRedstoneControl());
                PacketHandler.instance.sendToServer((IMessage)new ToggleRedstoneControlPacket(this.tile));
            }
        }
    }

    public static class SideConfig
    extends GuiSupercooler {
        public SideConfig(EntityPlayer player, TileFluidProcessor tile) {
            super(player, tile, new ContainerMachineConfig<TileFluidProcessor>(player, tile));
        }

        protected void func_73869_a(char typedChar, int keyCode) throws IOException {
            if (this.isEscapeKeyDown(keyCode)) {
                PacketHandler.instance.sendToServer((IMessage)new OpenTileGuiPacket(this.tile));
            } else {
                super.func_73869_a(typedChar, keyCode);
            }
        }

        @Override
        public void renderButtonTooltips(int mouseX, int mouseY) {
            this.drawTooltip(TextFormatting.DARK_AQUA + Lang.localise("gui.nc.container.input_tank_config"), mouseX, mouseY, 55, 34, 18, 18);
            this.drawTooltip(TextFormatting.RED + Lang.localise("gui.nc.container.output_tank_config"), mouseX, mouseY, 111, 30, 26, 26);
            this.drawTooltip(TextFormatting.DARK_BLUE + Lang.localise("gui.nc.container.upgrade_config"), mouseX, mouseY, 131, 63, 18, 18);
            this.drawTooltip(TextFormatting.YELLOW + Lang.localise("gui.nc.container.upgrade_config"), mouseX, mouseY, 151, 63, 18, 18);
        }

        @Override
        protected void drawUpgradeRenderers() {
        }

        @Override
        protected void drawBackgroundExtras() {
        }

        @Override
        public void initButtons() {
            this.field_146292_n.add(new NCButton.SorptionConfig.FluidInput(0, this.field_147003_i + 55, this.field_147009_r + 34));
            this.field_146292_n.add(new NCButton.SorptionConfig.FluidOutput(1, this.field_147003_i + 111, this.field_147009_r + 30));
            this.field_146292_n.add(new NCButton.SorptionConfig.SpeedUpgrade(2, this.field_147003_i + 131, this.field_147009_r + 63));
            this.field_146292_n.add(new NCButton.SorptionConfig.EnergyUpgrade(3, this.field_147003_i + 151, this.field_147009_r + 63));
        }

        @Override
        protected void func_146284_a(GuiButton guiButton) {
            if (this.tile.func_145831_w().field_72995_K) {
                if (guiButton.field_146127_k == 0) {
                    FMLCommonHandler.instance().showGuiScreen(new GuiFluidSorptions.Input<TileFluidProcessor>(this, this.tile, 0));
                } else if (guiButton.field_146127_k == 1) {
                    FMLCommonHandler.instance().showGuiScreen(new GuiFluidSorptions.Output<TileFluidProcessor>(this, this.tile, 1));
                } else if (guiButton.field_146127_k == 2) {
                    FMLCommonHandler.instance().showGuiScreen(new GuiItemSorptions.SpeedUpgrade<TileFluidProcessor>(this, this.tile, 0));
                } else if (guiButton.field_146127_k == 3) {
                    FMLCommonHandler.instance().showGuiScreen(new GuiItemSorptions.EnergyUpgrade<TileFluidProcessor>(this, this.tile, 1));
                }
            }
        }
    }
}

