/*
 * Decompiled with CFR 0.152.
 */
package nc.capability.radiation.resistance;

import nc.capability.radiation.resistance.IRadiationResistance;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class RadiationResistance
implements IRadiationResistance {
    private double baseRadResistance = 0.0;
    private double shieldingRadResistance = 0.0;

    public RadiationResistance(double baseRadResistance) {
        this.baseRadResistance = baseRadResistance;
    }

    @Override
    public NBTTagCompound writeNBT(IRadiationResistance instance, EnumFacing side, NBTTagCompound nbt) {
        nbt.func_74780_a("radiationResistance", this.getBaseRadResistance());
        nbt.func_74780_a("shieldingRadResistance", this.getShieldingRadResistance());
        return nbt;
    }

    @Override
    public void readNBT(IRadiationResistance instance, EnumFacing side, NBTTagCompound nbt) {
        this.setBaseRadResistance(nbt.func_74769_h("radiationResistance"));
        this.setShieldingRadResistance(nbt.func_74769_h("shieldingRadResistance"));
    }

    @Override
    public double getBaseRadResistance() {
        return this.baseRadResistance;
    }

    @Override
    public void setBaseRadResistance(double newResistance) {
        this.baseRadResistance = Math.max(newResistance, 0.0);
    }

    @Override
    public double getShieldingRadResistance() {
        return this.shieldingRadResistance;
    }

    @Override
    public void setShieldingRadResistance(double newResistance) {
        this.shieldingRadResistance = Math.max(newResistance, 0.0);
    }
}

