/*
 * Decompiled with CFR 0.152.
 */
package nc.block.fluid;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockReed;
import net.minecraft.block.BlockStandingSign;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;

public abstract class NCBlockFluid
extends BlockFluidClassic {
    public final String name;
    public final Fluid fluid;

    public NCBlockFluid(Fluid fluid, Material material) {
        super(fluid, material);
        this.name = "fluid_" + fluid.getName();
        this.fluid = fluid;
    }

    public boolean canDisplace(IBlockAccess world, BlockPos pos) {
        if (world.func_180495_p(pos).func_185904_a().func_76224_d()) {
            return false;
        }
        return super.canDisplace(world, pos);
    }

    public boolean displaceIfPossible(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_185904_a().func_76224_d()) {
            return false;
        }
        return super.displaceIfPossible(world, pos);
    }

    public void func_176213_c(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        this.checkForMixing(world, pos, state);
        super.func_176213_c(world, pos, state);
    }

    public void func_189540_a(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Block block, @Nonnull BlockPos fromPos) {
        this.checkForMixing(world, pos, state);
        super.func_189540_a(state, world, pos, block, fromPos);
    }

    protected void checkForMixing(World world, BlockPos pos, IBlockState state) {
        if (this.canMixWithFluids(world, pos, state)) {
            boolean flag = false;
            for (EnumFacing side : EnumFacing.field_82609_l) {
                if (side == EnumFacing.DOWN || !this.shouldMixWithAdjacentFluid(world, pos, state, world.func_180495_p(pos.func_177972_a(side)))) continue;
                flag = true;
                break;
            }
            if (flag) {
                int level = (Integer)state.func_177229_b((IProperty)LEVEL);
                if (level == 0) {
                    world.func_175656_a(pos, ForgeEventFactory.fireFluidPlaceBlockEvent((World)world, (BlockPos)pos, (BlockPos)pos, (IBlockState)this.getSourceMixingState(world, pos, state)));
                    this.triggerMixEffects(world, pos);
                    return;
                }
                world.func_175656_a(pos, ForgeEventFactory.fireFluidPlaceBlockEvent((World)world, (BlockPos)pos, (BlockPos)pos, (IBlockState)this.getFlowingMixingState(world, pos, state)));
                this.triggerMixEffects(world, pos);
                return;
            }
        }
    }

    protected void triggerMixEffects(World world, BlockPos pos) {
        world.func_184133_a(null, pos, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
        for (int i = 0; i < 8; ++i) {
            world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)pos.func_177958_n() + Math.random(), (double)pos.func_177956_o() + 1.2, (double)pos.func_177952_p() + Math.random(), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public void func_180650_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random rand) {
        super.func_180650_b(world, pos, state, rand);
        int level = (Integer)state.func_177229_b((IProperty)LEVEL);
        if (level == 0) {
            if (this.canSetFireToSurroundings(world, pos, state, rand) && world.func_82736_K().func_82766_b("doFireTick")) {
                int i = rand.nextInt(3);
                if (i > 0) {
                    BlockPos firePos = pos;
                    for (int j = 0; j < i; ++j) {
                        if ((firePos = firePos.func_177982_a(rand.nextInt(3) - 1, 1, rand.nextInt(3) - 1)).func_177956_o() >= 0 && firePos.func_177956_o() < world.func_72800_K() && !world.func_175667_e(firePos)) {
                            return;
                        }
                        IBlockState block = world.func_180495_p(firePos);
                        if (block.func_177230_c().isAir(block, (IBlockAccess)world, firePos)) {
                            if (!this.isSurroundingBlockFlammable(world, firePos)) continue;
                            world.func_175656_a(firePos, ForgeEventFactory.fireFluidPlaceBlockEvent((World)world, (BlockPos)firePos, (BlockPos)pos, (IBlockState)Blocks.field_150480_ab.func_176223_P()));
                            return;
                        }
                        if (!block.func_185904_a().func_76230_c()) continue;
                        return;
                    }
                } else {
                    for (int k = 0; k < 3; ++k) {
                        BlockPos firePos = pos.func_177982_a(rand.nextInt(3) - 1, 0, rand.nextInt(3) - 1);
                        if (firePos.func_177956_o() >= 0 && firePos.func_177956_o() < world.func_72800_K() && !world.func_175667_e(firePos)) {
                            return;
                        }
                        if (!world.func_175623_d(firePos.func_177984_a()) || !this.canBlockBurn(world, firePos)) continue;
                        world.func_175656_a(firePos.func_177984_a(), ForgeEventFactory.fireFluidPlaceBlockEvent((World)world, (BlockPos)firePos.func_177984_a(), (BlockPos)pos, (IBlockState)Blocks.field_150480_ab.func_176223_P()));
                    }
                }
            }
        } else {
            IBlockState newState = this.getFlowingIntoWaterState(world, pos, state, rand);
            if (newState != null) {
                IBlockState stateDown = world.func_180495_p(pos.func_177977_b());
                if (this.canFlowInto(world, pos.func_177977_b(), stateDown) && world.func_180495_p(pos.func_177977_b()).func_185904_a() == Material.field_151586_h) {
                    world.func_175656_a(pos.func_177977_b(), ForgeEventFactory.fireFluidPlaceBlockEvent((World)world, (BlockPos)pos.func_177977_b(), (BlockPos)pos, (IBlockState)newState));
                    this.triggerMixEffects(world, pos.func_177977_b());
                }
            }
        }
    }

    protected abstract boolean canMixWithFluids(World var1, BlockPos var2, IBlockState var3);

    protected abstract boolean shouldMixWithAdjacentFluid(World var1, BlockPos var2, IBlockState var3, IBlockState var4);

    protected abstract IBlockState getSourceMixingState(World var1, BlockPos var2, IBlockState var3);

    protected abstract IBlockState getFlowingMixingState(World var1, BlockPos var2, IBlockState var3);

    protected abstract boolean canSetFireToSurroundings(World var1, BlockPos var2, IBlockState var3, Random var4);

    protected abstract IBlockState getFlowingIntoWaterState(World var1, BlockPos var2, IBlockState var3, Random var4);

    protected boolean isSurroundingBlockFlammable(World world, BlockPos pos) {
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if (!this.canBlockBurn(world, pos.func_177972_a(side))) continue;
            return true;
        }
        return false;
    }

    protected boolean canBlockBurn(World world, BlockPos pos) {
        return pos.func_177956_o() >= 0 && pos.func_177956_o() < world.func_72800_K() && !world.func_175667_e(pos) ? false : world.func_180495_p(pos).func_185904_a().func_76217_h();
    }

    protected boolean canFlowInto(World world, BlockPos pos, IBlockState state) {
        Material mat = state.func_185904_a();
        return mat != this.field_149764_J && mat != Material.field_151587_i && !this.isBlocked(world, pos, state);
    }

    protected boolean isBlocked(World world, BlockPos pos, IBlockState state) {
        Block block = state.func_177230_c();
        Material mat = state.func_185904_a();
        if (!(block instanceof BlockDoor || block instanceof BlockStandingSign || block instanceof BlockLadder || block instanceof BlockReed)) {
            return mat != Material.field_151567_E && mat != Material.field_189963_J ? mat.func_76230_c() : true;
        }
        return true;
    }
}

