/*
 * Decompiled with CFR 0.152.
 */
package nc.block.fluid;

import java.util.Random;
import javax.annotation.Nonnull;
import nc.block.fluid.NCBlockFluid;
import nc.config.NCConfig;
import nc.fluid.FluidPlasma;
import nc.util.DamageSources;
import nc.util.MaterialHelper;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockFluidPlasma
extends NCBlockFluid {
    private static final Material GAS = new MaterialLiquid(MapColor.field_151660_b);

    public BlockFluidPlasma(FluidPlasma fluid) {
        super(fluid, GAS);
        this.func_149715_a(1.0f);
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        entityIn.func_70097_a(DamageSources.PLASMA_BURN, 8.0f);
        entityIn.func_70015_d(10);
    }

    @Override
    public void func_180650_b(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random rand) {
        if (NCConfig.fusion_plasma_craziness && worldIn.func_82736_K().func_82766_b("doFireTick") && BlockFluidPlasma.updateFire(worldIn, pos, state, rand)) {
            return;
        }
        super.func_180650_b(worldIn, pos, state, rand);
    }

    private static boolean updateFire(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random rand) {
        Material mat;
        EnumFacing side = EnumFacing.func_82600_a((int)rand.nextInt(6));
        BlockPos offPos = pos.func_177972_a(side);
        if (side != EnumFacing.UP && side != EnumFacing.DOWN && rand.nextInt(4) == 0 && (mat = worldIn.func_180495_p(offPos).func_185904_a()) != Material.field_151581_o && MaterialHelper.isReplaceable(mat) && !mat.func_76224_d() && worldIn.isSideSolid(offPos.func_177977_b(), EnumFacing.UP)) {
            worldIn.func_175656_a(offPos, Blocks.field_150480_ab.func_176223_P());
            return true;
        }
        return false;
    }

    @Override
    protected boolean canMixWithFluids(World world, BlockPos pos, IBlockState state) {
        return false;
    }

    @Override
    protected boolean shouldMixWithAdjacentFluid(World world, BlockPos pos, IBlockState state, IBlockState otherState) {
        return false;
    }

    @Override
    protected IBlockState getSourceMixingState(World world, BlockPos pos, IBlockState state) {
        return Blocks.field_150343_Z.func_176223_P();
    }

    @Override
    protected IBlockState getFlowingMixingState(World world, BlockPos pos, IBlockState state) {
        return Blocks.field_150347_e.func_176223_P();
    }

    @Override
    protected boolean canSetFireToSurroundings(World world, BlockPos pos, IBlockState state, Random rand) {
        return true;
    }

    @Override
    protected IBlockState getFlowingIntoWaterState(World world, BlockPos pos, IBlockState state, Random rand) {
        return null;
    }
}

