/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.structures.plants;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import paulevs.betternether.blocks.BlocksRegister;
import paulevs.betternether.structures.IStructure;

public class StructureWartTree
implements IStructure {
    private static final IBlockState WART = Blocks.field_189878_dg.func_176223_P();

    @Override
    public void generate(World world, BlockPos pos, Random random) {
        boolean b5;
        int height = 5 + random.nextInt(5);
        boolean b1 = world.func_180495_p(new BlockPos(pos.func_177958_n() - 4, pos.func_177956_o() + 5, pos.func_177952_p())).func_177230_c() == Blocks.field_150350_a;
        boolean b2 = world.func_180495_p(new BlockPos(pos.func_177958_n() + 4, pos.func_177956_o() + 5, pos.func_177952_p())).func_177230_c() == Blocks.field_150350_a;
        boolean b3 = world.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 5, pos.func_177952_p() - 4)).func_177230_c() == Blocks.field_150350_a;
        boolean b4 = world.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 5, pos.func_177952_p() + 4)).func_177230_c() == Blocks.field_150350_a;
        boolean bl = b5 = world.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + height, pos.func_177952_p())).func_177230_c() == Blocks.field_150350_a;
        if (b1 && b2 && b3 && b4 && b5) {
            int h2 = height >>> 1;
            int h3 = height >>> 2;
            int width = (height >>> 2) + 1;
            int offset = width >>> 1;
            ArrayList<BlockPos> seedBlocks = new ArrayList<BlockPos>();
            for (int x = 0; x < width; ++x) {
                int px = x + pos.func_177958_n() - offset;
                for (int z = 0; z < width; ++z) {
                    int pz = z + pos.func_177952_p() - offset;
                    int rh = random.nextInt(h2);
                    int rh2 = random.nextInt(h3);
                    for (int y = 0; y < height; ++y) {
                        int py = y + pos.func_177956_o();
                        BlockPos pos2 = new BlockPos(px, py, pz);
                        if (y < rh && random.nextInt(2) == 0) {
                            world.func_175656_a(pos2, WART);
                            continue;
                        }
                        world.func_175656_a(pos2, WART);
                        EnumFacing dir = EnumFacing.field_176754_o[random.nextInt(4)];
                        seedBlocks.add(pos2.func_177972_a(dir));
                    }
                }
            }
            int headWidth = width + 2;
            ++offset;
            height = height - width - 1 + pos.func_177956_o();
            for (int x = 0; x < headWidth; ++x) {
                int px = x + pos.func_177958_n() - offset;
                for (int z = 0; z < headWidth; ++z) {
                    if (x == z || x == headWidth - z - 1) continue;
                    int pz = z + pos.func_177952_p() - offset;
                    for (int y = 0; y < width; ++y) {
                        int py = y + height;
                        BlockPos pos2 = new BlockPos(px, py, pz);
                        if (world.func_180495_p(pos2) == WART) continue;
                        world.func_175656_a(pos2, WART);
                    }
                }
            }
            for (BlockPos pos2 : seedBlocks) {
                this.PlaceRandomSeed(world, pos2);
            }
        }
    }

    private void PlaceRandomSeed(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a) {
            IBlockState seed = BlocksRegister.BLOCK_WART_SEED.func_176223_P().func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)EnumFacing.UP);
            if (world.func_180495_p(pos.func_177978_c()).func_185913_b()) {
                seed = seed.func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)EnumFacing.SOUTH);
            } else if (world.func_180495_p(pos.func_177968_d()).func_185913_b()) {
                seed = seed.func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)EnumFacing.NORTH);
            } else if (world.func_180495_p(pos.func_177974_f()).func_185913_b()) {
                seed = seed.func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)EnumFacing.WEST);
            } else if (world.func_180495_p(pos.func_177976_e()).func_185913_b()) {
                seed = seed.func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)EnumFacing.EAST);
            } else if (world.func_180495_p(pos.func_177984_a()).func_185913_b()) {
                seed = seed.func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)EnumFacing.DOWN);
            }
            world.func_175656_a(pos, seed);
        }
    }
}

